/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.RowPagesBuilder;
import com.facebook.presto.SequencePageBuilder;
import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.connector.ConnectorId;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.GenericLongFunction;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorAssertion;
import com.facebook.presto.operator.PageAssertions;
import com.facebook.presto.operator.ScanFilterAndProjectOperator;
import com.facebook.presto.operator.SourceOperator;
import com.facebook.presto.operator.index.PageRecordSet;
import com.facebook.presto.operator.project.PageProcessor;
import com.facebook.presto.operator.project.TestPageProcessor;
import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.FixedPageSource;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.RecordPageSource;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.LazyBlock;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.sql.gen.ExpressionCompiler;
import com.facebook.presto.sql.gen.PageFunctionCompiler;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.relational.CallExpression;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.RowExpression;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.TestingSplit;
import com.facebook.presto.testing.TestingTaskContext;
import com.facebook.presto.testing.TestingTransactionHandle;
import com.facebook.presto.testing.assertions.Assert;
import com.google.common.collect.ImmutableList;
import io.airlift.concurrent.Threads;
import io.airlift.units.DataSize;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.testng.annotations.Test;

public class TestScanFilterAndProjectOperator
extends AbstractTestFunctions {
    private final MetadataManager metadata = MetadataManager.createTestMetadataManager();
    private final ExpressionCompiler expressionCompiler = new ExpressionCompiler((Metadata)this.metadata, new PageFunctionCompiler((Metadata)this.metadata, 0));
    private ExecutorService executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test-executor-%s"));
    private ScheduledExecutorService scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)"test-scheduledExecutor-%s"));

    @Test
    public void testPageSource() {
        Page input = SequencePageBuilder.createSequencePage((List<? extends Type>)ImmutableList.of((Object)VarcharType.VARCHAR), 10000, 0);
        DriverContext driverContext = this.newDriverContext();
        ImmutableList projections = ImmutableList.of((Object)Expressions.field((int)0, (Type)VarcharType.VARCHAR));
        Supplier cursorProcessor = this.expressionCompiler.compileCursorProcessor(Optional.empty(), (List)projections, (Object)"key");
        Supplier pageProcessor = this.expressionCompiler.compilePageProcessor(Optional.empty(), (List)projections);
        ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory factory = new ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory(0, new PlanNodeId("test"), new PlanNodeId("0"), (session, split, columns) -> new FixedPageSource((Iterable)ImmutableList.of((Object)input)), cursorProcessor, pageProcessor, (Iterable)ImmutableList.of(), (List)ImmutableList.of((Object)VarcharType.VARCHAR), new DataSize(0.0, DataSize.Unit.BYTE), 0);
        SourceOperator operator = factory.createOperator(driverContext);
        operator.addSplit(new Split(new ConnectorId("test"), (ConnectorTransactionHandle)TestingTransactionHandle.create(), (ConnectorSplit)TestingSplit.createLocalSplit()));
        operator.noMoreSplits();
        MaterializedResult expected = OperatorAssertion.toMaterializedResult(driverContext.getSession(), (List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR), (List<Page>)ImmutableList.of((Object)input));
        MaterializedResult actual = OperatorAssertion.toMaterializedResult(driverContext.getSession(), (List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR), TestScanFilterAndProjectOperator.toPages((Operator)operator));
        Assert.assertEquals((int)actual.getRowCount(), (int)expected.getRowCount());
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
    }

    @Test
    public void testPageSourceMergeOutput() {
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT}).addSequencePage(100, 0).addSequencePage(100, 0).addSequencePage(100, 0).addSequencePage(100, 0).build();
        CallExpression filter = Expressions.call((Signature)Signature.internalOperator((OperatorType)OperatorType.EQUAL, (TypeSignature)BooleanType.BOOLEAN.getTypeSignature(), (List)ImmutableList.of((Object)BigintType.BIGINT.getTypeSignature(), (Object)BigintType.BIGINT.getTypeSignature())), (Type)BooleanType.BOOLEAN, (RowExpression[])new RowExpression[]{Expressions.field((int)0, (Type)BigintType.BIGINT), Expressions.constant((Object)10L, (Type)BigintType.BIGINT)});
        ImmutableList projections = ImmutableList.of((Object)Expressions.field((int)0, (Type)BigintType.BIGINT));
        Supplier cursorProcessor = this.expressionCompiler.compileCursorProcessor(Optional.of(filter), (List)projections, (Object)"key");
        Supplier pageProcessor = this.expressionCompiler.compilePageProcessor(Optional.of(filter), (List)projections);
        ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory factory = new ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory(0, new PlanNodeId("test"), new PlanNodeId("0"), (session, split, columns) -> new FixedPageSource((Iterable)input), cursorProcessor, pageProcessor, (Iterable)ImmutableList.of(), (List)ImmutableList.of((Object)BigintType.BIGINT), new DataSize(64.0, DataSize.Unit.KILOBYTE), 2);
        SourceOperator operator = factory.createOperator(this.newDriverContext());
        operator.addSplit(new Split(new ConnectorId("test"), (ConnectorTransactionHandle)TestingTransactionHandle.create(), (ConnectorSplit)TestingSplit.createLocalSplit()));
        operator.noMoreSplits();
        List<Page> actual = TestScanFilterAndProjectOperator.toPages((Operator)operator);
        Assert.assertEquals((int)actual.size(), (int)1);
        List<Page> expected = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT}).row(10L).row(10L).row(10L).row(10L).build();
        PageAssertions.assertPageEquals((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), actual.get(0), expected.get(0));
    }

    @Test
    public void testPageSourceLazyLoad() {
        Block inputBlock = BlockAssertions.createLongSequenceBlock(0, 100);
        Page input = new Page(100, new Block[]{inputBlock, new LazyBlock(100, lazyBlock -> {
            throw new AssertionError((Object)"Lazy block should not be loaded");
        })});
        DriverContext driverContext = this.newDriverContext();
        ImmutableList projections = ImmutableList.of((Object)Expressions.field((int)0, (Type)VarcharType.VARCHAR));
        Supplier cursorProcessor = this.expressionCompiler.compileCursorProcessor(Optional.empty(), (List)projections, (Object)"key");
        PageProcessor pageProcessor = new PageProcessor(Optional.of(new TestPageProcessor.SelectAllFilter()), (List)ImmutableList.of((Object)new TestPageProcessor.LazyPagePageProjection()));
        ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory factory = new ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory(0, new PlanNodeId("test"), new PlanNodeId("0"), (session, split, columns) -> new SinglePagePageSource(input), cursorProcessor, () -> pageProcessor, (Iterable)ImmutableList.of(), (List)ImmutableList.of((Object)BigintType.BIGINT), new DataSize(0.0, DataSize.Unit.BYTE), 0);
        SourceOperator operator = factory.createOperator(driverContext);
        operator.addSplit(new Split(new ConnectorId("test"), (ConnectorTransactionHandle)TestingTransactionHandle.create(), (ConnectorSplit)TestingSplit.createLocalSplit()));
        operator.noMoreSplits();
        MaterializedResult expected = OperatorAssertion.toMaterializedResult(driverContext.getSession(), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT), (List<Page>)ImmutableList.of((Object)new Page(new Block[]{inputBlock})));
        MaterializedResult actual = OperatorAssertion.toMaterializedResult(driverContext.getSession(), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT), TestScanFilterAndProjectOperator.toPages((Operator)operator));
        Assert.assertEquals((int)actual.getRowCount(), (int)expected.getRowCount());
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
    }

    @Test
    public void testRecordCursorSource() {
        Page input = SequencePageBuilder.createSequencePage((List<? extends Type>)ImmutableList.of((Object)VarcharType.VARCHAR), 10000, 0);
        DriverContext driverContext = this.newDriverContext();
        ImmutableList projections = ImmutableList.of((Object)Expressions.field((int)0, (Type)VarcharType.VARCHAR));
        Supplier cursorProcessor = this.expressionCompiler.compileCursorProcessor(Optional.empty(), (List)projections, (Object)"key");
        Supplier pageProcessor = this.expressionCompiler.compilePageProcessor(Optional.empty(), (List)projections);
        ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory factory = new ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory(0, new PlanNodeId("test"), new PlanNodeId("0"), (session, split, columns) -> new RecordPageSource((RecordSet)new PageRecordSet((List)ImmutableList.of((Object)VarcharType.VARCHAR), input)), cursorProcessor, pageProcessor, (Iterable)ImmutableList.of(), (List)ImmutableList.of((Object)VarcharType.VARCHAR), new DataSize(0.0, DataSize.Unit.BYTE), 0);
        SourceOperator operator = factory.createOperator(driverContext);
        operator.addSplit(new Split(new ConnectorId("test"), (ConnectorTransactionHandle)TestingTransactionHandle.create(), (ConnectorSplit)TestingSplit.createLocalSplit()));
        operator.noMoreSplits();
        MaterializedResult expected = OperatorAssertion.toMaterializedResult(driverContext.getSession(), (List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR), (List<Page>)ImmutableList.of((Object)input));
        MaterializedResult actual = OperatorAssertion.toMaterializedResult(driverContext.getSession(), (List<Type>)ImmutableList.of((Object)VarcharType.VARCHAR), TestScanFilterAndProjectOperator.toPages((Operator)operator));
        Assert.assertEquals((int)actual.getRowCount(), (int)expected.getRowCount());
        Assert.assertEquals((Iterable)actual, (Iterable)expected);
    }

    @Test
    public void testPageYield() {
        int totalRows = 1000;
        Page input = SequencePageBuilder.createSequencePage((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), totalRows, 1);
        DriverContext driverContext = this.newDriverContext();
        int totalColumns = 20;
        ImmutableList.Builder functions = ImmutableList.builder();
        for (int i = 0; i < totalColumns; ++i) {
            functions.add((Object)new GenericLongFunction("page_col" + i, value -> {
                driverContext.getYieldSignal().forceYieldForTesting();
                return value;
            }));
        }
        Metadata metadata = this.functionAssertions.getMetadata();
        metadata.getFunctionRegistry().addFunctions((List)functions.build());
        ExpressionCompiler expressionCompiler = new ExpressionCompiler(metadata, new PageFunctionCompiler(metadata, 0));
        ImmutableList.Builder projections = ImmutableList.builder();
        for (int i = 0; i < totalColumns; ++i) {
            projections.add((Object)Expressions.call((Signature)Signature.internalScalarFunction((String)("generic_long_page_col" + i), (TypeSignature)BigintType.BIGINT.getTypeSignature(), (List)ImmutableList.of((Object)BigintType.BIGINT.getTypeSignature())), (Type)BigintType.BIGINT, (RowExpression[])new RowExpression[]{Expressions.field((int)0, (Type)BigintType.BIGINT)}));
        }
        Supplier cursorProcessor = expressionCompiler.compileCursorProcessor(Optional.empty(), (List)projections.build(), (Object)"key");
        Supplier pageProcessor = expressionCompiler.compilePageProcessor(Optional.empty(), (List)projections.build());
        ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory factory = new ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory(0, new PlanNodeId("test"), new PlanNodeId("0"), (session, split, columns) -> new FixedPageSource((Iterable)ImmutableList.of((Object)input)), cursorProcessor, pageProcessor, (Iterable)ImmutableList.of(), (List)ImmutableList.of((Object)BigintType.BIGINT), new DataSize(0.0, DataSize.Unit.BYTE), 0);
        SourceOperator operator = factory.createOperator(driverContext);
        operator.addSplit(new Split(new ConnectorId("test"), (ConnectorTransactionHandle)TestingTransactionHandle.create(), (ConnectorSplit)TestingSplit.createLocalSplit()));
        operator.noMoreSplits();
        for (int i = 0; i < totalRows * totalColumns; ++i) {
            driverContext.getYieldSignal().setWithDelay(TimeUnit.SECONDS.toNanos(1000L), driverContext.getYieldExecutor());
            org.testng.Assert.assertNull((Object)operator.getOutput());
            driverContext.getYieldSignal().reset();
        }
        Page output = operator.getOutput();
        Assert.assertEquals((int)output.getPositionCount(), (int)totalRows);
        Assert.assertEquals((int)output.getChannelCount(), (int)totalColumns);
        for (int i = 0; i < totalColumns; ++i) {
            Assert.assertEquals(BlockAssertions.toValues((Type)BigintType.BIGINT, output.getBlock(i)), BlockAssertions.toValues((Type)BigintType.BIGINT, input.getBlock(0)));
        }
    }

    @Test
    public void testRecordCursorYield() {
        int length = 15;
        Page input = SequencePageBuilder.createSequencePage((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), length, 0);
        DriverContext driverContext = this.newDriverContext();
        Metadata metadata = this.functionAssertions.getMetadata();
        metadata.getFunctionRegistry().addFunctions((List)ImmutableList.of((Object)((Object)new GenericLongFunction("record_cursor", value -> {
            driverContext.getYieldSignal().forceYieldForTesting();
            return value;
        }))));
        ExpressionCompiler expressionCompiler = new ExpressionCompiler(metadata, new PageFunctionCompiler(metadata, 0));
        ImmutableList projections = ImmutableList.of((Object)Expressions.call((Signature)Signature.internalScalarFunction((String)"generic_long_record_cursor", (TypeSignature)BigintType.BIGINT.getTypeSignature(), (List)ImmutableList.of((Object)BigintType.BIGINT.getTypeSignature())), (Type)BigintType.BIGINT, (RowExpression[])new RowExpression[]{Expressions.field((int)0, (Type)BigintType.BIGINT)}));
        Supplier cursorProcessor = expressionCompiler.compileCursorProcessor(Optional.empty(), (List)projections, (Object)"key");
        Supplier pageProcessor = expressionCompiler.compilePageProcessor(Optional.empty(), (List)projections);
        ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory factory = new ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory(0, new PlanNodeId("test"), new PlanNodeId("0"), (session, split, columns) -> new RecordPageSource((RecordSet)new PageRecordSet((List)ImmutableList.of((Object)BigintType.BIGINT), input)), cursorProcessor, pageProcessor, (Iterable)ImmutableList.of(), (List)ImmutableList.of((Object)BigintType.BIGINT), new DataSize(0.0, DataSize.Unit.BYTE), 0);
        SourceOperator operator = factory.createOperator(driverContext);
        operator.addSplit(new Split(new ConnectorId("test"), (ConnectorTransactionHandle)TestingTransactionHandle.create(), (ConnectorSplit)TestingSplit.createLocalSplit()));
        operator.noMoreSplits();
        for (int i = 0; i < length; ++i) {
            driverContext.getYieldSignal().setWithDelay(TimeUnit.SECONDS.toNanos(1000L), driverContext.getYieldExecutor());
            org.testng.Assert.assertNull((Object)operator.getOutput());
            driverContext.getYieldSignal().reset();
        }
        driverContext.getYieldSignal().setWithDelay(TimeUnit.SECONDS.toNanos(1000L), driverContext.getYieldExecutor());
        Page output = operator.getOutput();
        driverContext.getYieldSignal().reset();
        org.testng.Assert.assertNotNull((Object)output);
        Assert.assertEquals(BlockAssertions.toValues((Type)BigintType.BIGINT, output.getBlock(0)), BlockAssertions.toValues((Type)BigintType.BIGINT, input.getBlock(0)));
    }

    private static List<Page> toPages(Operator operator) {
        ImmutableList.Builder outputPages = ImmutableList.builder();
        int nullPages = 0;
        while (!operator.isFinished()) {
            Page outputPage = operator.getOutput();
            if (outputPage == null) {
                org.testng.Assert.assertTrue((nullPages < 1000000 ? 1 : 0) != 0, (String)"Too many null pages; infinite loop?");
                ++nullPages;
                continue;
            }
            outputPages.add((Object)outputPage);
            nullPages = 0;
        }
        return outputPages.build();
    }

    private DriverContext newDriverContext() {
        return TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION).addPipelineContext(0, true, true).addDriverContext();
    }

    public class SinglePagePageSource
    implements ConnectorPageSource {
        private Page page;

        public SinglePagePageSource(Page page) {
            this.page = page;
        }

        public void close() {
            this.page = null;
        }

        public long getCompletedBytes() {
            return 0L;
        }

        public long getReadTimeNanos() {
            return 0L;
        }

        public long getSystemMemoryUsage() {
            return 0L;
        }

        public boolean isFinished() {
            return this.page == null;
        }

        public Page getNextPage() {
            Page page = this.page;
            this.page = null;
            return page;
        }
    }
}

