/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.RowPagesBuilder;
import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.OperatorAssertion;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.StreamingAggregationOperator;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.gen.JoinCompiler;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.TestingTaskContext;
import com.google.common.collect.ImmutableList;
import io.airlift.concurrent.Threads;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestStreamingAggregationOperator {
    private static final MetadataManager metadata = MetadataManager.createTestMetadataManager();
    private static final InternalAggregationFunction LONG_SUM = metadata.getFunctionRegistry().getAggregateFunctionImplementation(new Signature("sum", FunctionKind.AGGREGATE, BigintType.BIGINT.getTypeSignature(), new TypeSignature[]{BigintType.BIGINT.getTypeSignature()}));
    private static final InternalAggregationFunction COUNT = metadata.getFunctionRegistry().getAggregateFunctionImplementation(new Signature("count", FunctionKind.AGGREGATE, BigintType.BIGINT.getTypeSignature(), new TypeSignature[0]));
    private ExecutorService executor;
    private ScheduledExecutorService scheduledExecutor;
    private DriverContext driverContext;
    private StreamingAggregationOperator.StreamingAggregationOperatorFactory operatorFactory;

    @BeforeMethod
    public void setUp() {
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test-executor-%s"));
        this.scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)"test-scheduledExecutor-%s"));
        this.driverContext = TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION).addPipelineContext(0, true, true).addDriverContext();
        this.operatorFactory = new StreamingAggregationOperator.StreamingAggregationOperatorFactory(0, new PlanNodeId("test"), (List)ImmutableList.of((Object)BooleanType.BOOLEAN, (Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT), (List)ImmutableList.of((Object)VarcharType.VARCHAR), (List)ImmutableList.of((Object)1), AggregationNode.Step.SINGLE, (List)ImmutableList.of((Object)COUNT.bind((List)ImmutableList.of((Object)0), Optional.empty()), (Object)LONG_SUM.bind((List)ImmutableList.of((Object)2), Optional.empty())), new JoinCompiler((Metadata)MetadataManager.createTestMetadataManager(), new FeaturesConfig()));
    }

    @AfterMethod
    public void tearDown() {
        this.executor.shutdownNow();
        this.scheduledExecutor.shutdownNow();
    }

    @Test
    public void test() {
        RowPagesBuilder rowPagesBuilder = RowPagesBuilder.rowPagesBuilder(new Type[]{BooleanType.BOOLEAN, VarcharType.VARCHAR, BigintType.BIGINT});
        List<Page> input = rowPagesBuilder.addSequencePage(3, 0, 0, 1).row(true, "3", 4).row(false, "3", 5).pageBreak().row(true, "3", 6).row(false, "4", 7).row(true, "4", 8).row(false, "4", 9).row(true, "4", 10).pageBreak().row(false, "5", 11).row(true, "5", 12).row(false, "5", 13).row(true, "5", 14).row(false, "5", 15).pageBreak().addSequencePage(3, 0, 6, 16).build();
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{"0", 1L, 1L}).row(new Object[]{"1", 1L, 2L}).row(new Object[]{"2", 1L, 3L}).row(new Object[]{"3", 3L, 15L}).row(new Object[]{"4", 4L, 34L}).row(new Object[]{"5", 5L, 65L}).row(new Object[]{"6", 1L, 16L}).row(new Object[]{"7", 1L, 17L}).row(new Object[]{"8", 1L, 18L}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)this.operatorFactory, this.driverContext, input, expected);
    }

    @Test
    public void testEmptyInput() {
        RowPagesBuilder rowPagesBuilder = RowPagesBuilder.rowPagesBuilder(new Type[]{BooleanType.BOOLEAN, VarcharType.VARCHAR, BigintType.BIGINT});
        List<Page> input = rowPagesBuilder.build();
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, BigintType.BIGINT, BigintType.BIGINT}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)this.operatorFactory, this.driverContext, input, expected);
    }

    @Test
    public void testSinglePage() {
        RowPagesBuilder rowPagesBuilder = RowPagesBuilder.rowPagesBuilder(new Type[]{BooleanType.BOOLEAN, VarcharType.VARCHAR, BigintType.BIGINT});
        List<Page> input = rowPagesBuilder.row(false, "a", 5).build();
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{"a", 1L, 5L}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)this.operatorFactory, this.driverContext, input, expected);
    }

    @Test
    public void testUniqueGroupingValues() {
        RowPagesBuilder rowPagesBuilder = RowPagesBuilder.rowPagesBuilder(new Type[]{BooleanType.BOOLEAN, VarcharType.VARCHAR, BigintType.BIGINT});
        List<Page> input = rowPagesBuilder.addSequencePage(10, 0, 0, 0).addSequencePage(10, 0, 10, 10).build();
        MaterializedResult.Builder builder = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, BigintType.BIGINT, BigintType.BIGINT});
        for (int i = 0; i < 20; ++i) {
            builder.row(new Object[]{String.format("%s", i), 1L, (long)i});
        }
        OperatorAssertion.assertOperatorEquals((OperatorFactory)this.operatorFactory, this.driverContext, input, builder.build());
    }

    @Test
    public void testSingleGroupingValue() {
        RowPagesBuilder rowPagesBuilder = RowPagesBuilder.rowPagesBuilder(new Type[]{BooleanType.BOOLEAN, VarcharType.VARCHAR, BigintType.BIGINT});
        List<Page> input = rowPagesBuilder.row(true, "a", 1).row(false, "a", 2).row(true, "a", 3).row(false, "a", 4).row(true, "a", 5).pageBreak().row(false, "a", 6).row(true, "a", 7).row(false, "a", 8).pageBreak().pageBreak().row(true, "a", 9).row(false, "a", 10).build();
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{"a", 10L, 55L}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)this.operatorFactory, this.driverContext, input, expected);
    }
}

