/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.RowPagesBuilder;
import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.connector.ConnectorId;
import com.facebook.presto.memory.context.MemoryTrackingContext;
import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.metadata.OutputTableHandle;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.operator.AggregationOperator;
import com.facebook.presto.operator.DevNullOperator;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.PageAssertions;
import com.facebook.presto.operator.TableWriterOperator;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.spi.ConnectorInsertTableHandle;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.ConnectorPageSink;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.connector.ConnectorPageSinkProvider;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.split.PageSinkManager;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.facebook.presto.testing.TestingTaskContext;
import com.google.common.collect.ImmutableList;
import io.airlift.concurrent.Threads;
import io.airlift.slice.Slice;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestTableWriterOperator {
    private static final ConnectorId CONNECTOR_ID = new ConnectorId("testConnectorId");
    private static final InternalAggregationFunction LONG_MAX = MetadataManager.createTestMetadataManager().getFunctionRegistry().getAggregateFunctionImplementation(new Signature("max", FunctionKind.AGGREGATE, BigintType.BIGINT.getTypeSignature(), new TypeSignature[]{BigintType.BIGINT.getTypeSignature()}));
    private ExecutorService executor;
    private ScheduledExecutorService scheduledExecutor;

    @BeforeClass
    public void setUp() {
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test-executor-%s"));
        this.scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)"test-scheduledExecutor-%s"));
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.executor.shutdownNow();
        this.scheduledExecutor.shutdownNow();
    }

    @Test
    public void testBlockedPageSink() {
        BlockingPageSink blockingPageSink = new BlockingPageSink();
        Operator operator = this.createTableWriterOperator(blockingPageSink);
        Assert.assertTrue((boolean)operator.isBlocked().isDone());
        Assert.assertFalse((boolean)operator.isFinished());
        Assert.assertTrue((boolean)operator.needsInput());
        operator.addInput(RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT}).row(42).build().get(0));
        Assert.assertFalse((boolean)operator.isBlocked().isDone());
        Assert.assertFalse((boolean)operator.isFinished());
        Assert.assertFalse((boolean)operator.needsInput());
        Assert.assertNull((Object)operator.getOutput());
        blockingPageSink.complete();
        Assert.assertTrue((boolean)operator.isBlocked().isDone());
        Assert.assertFalse((boolean)operator.isFinished());
        Assert.assertTrue((boolean)operator.needsInput());
        operator.addInput(RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT}).row(44).build().get(0));
        Assert.assertFalse((boolean)operator.isBlocked().isDone());
        Assert.assertFalse((boolean)operator.isFinished());
        Assert.assertFalse((boolean)operator.needsInput());
        operator.finish();
        Assert.assertFalse((boolean)operator.isBlocked().isDone());
        Assert.assertFalse((boolean)operator.isFinished());
        Assert.assertFalse((boolean)operator.needsInput());
        blockingPageSink.complete();
        ImmutableList expectedTypes = ImmutableList.of((Object)BigintType.BIGINT, (Object)VarbinaryType.VARBINARY);
        PageAssertions.assertPageEquals((List<? extends Type>)expectedTypes, operator.getOutput(), RowPagesBuilder.rowPagesBuilder((Iterable<Type>)expectedTypes).row(2, null).build().get(0));
        Assert.assertTrue((boolean)operator.isBlocked().isDone());
        Assert.assertTrue((boolean)operator.isFinished());
        Assert.assertFalse((boolean)operator.needsInput());
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void addInputFailsOnBlockedOperator() {
        Operator operator = this.createTableWriterOperator(new BlockingPageSink());
        operator.addInput(RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT}).row(42).build().get(0));
        Assert.assertFalse((boolean)operator.isBlocked().isDone());
        Assert.assertFalse((boolean)operator.needsInput());
        operator.addInput(RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT}).row(42).build().get(0));
    }

    @Test
    public void testTableWriterInfo() {
        PageSinkManager pageSinkManager = new PageSinkManager();
        pageSinkManager.addConnectorPageSinkProvider(CONNECTOR_ID, (ConnectorPageSinkProvider)new ConstantPageSinkProvider(new MemoryAccountingTestPageSink()));
        TableWriterOperator tableWriterOperator = (TableWriterOperator)this.createTableWriterOperator(pageSinkManager, (OperatorFactory)new DevNullOperator.DevNullOperatorFactory(1, new PlanNodeId("test")), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)VarbinaryType.VARBINARY));
        RowPagesBuilder rowPagesBuilder = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT});
        for (int i = 0; i < 100; ++i) {
            rowPagesBuilder.addSequencePage(100, 0);
        }
        List<Page> pages = rowPagesBuilder.build();
        long peakMemoryUsage = 0L;
        for (int i = 0; i < pages.size(); ++i) {
            Page page = pages.get(i);
            tableWriterOperator.addInput(page);
            TableWriterOperator.TableWriterInfo info = tableWriterOperator.getInfo();
            Assert.assertEquals((long)info.getPageSinkPeakMemoryUsage(), (long)(peakMemoryUsage += page.getRetainedSizeInBytes()));
        }
    }

    @Test
    public void testStatisticsAggregation() throws Exception {
        PageSinkManager pageSinkManager = new PageSinkManager();
        pageSinkManager.addConnectorPageSinkProvider(CONNECTOR_ID, (ConnectorPageSinkProvider)new ConstantPageSinkProvider(new MemoryAccountingTestPageSink()));
        ImmutableList outputTypes = ImmutableList.of((Object)BigintType.BIGINT, (Object)VarbinaryType.VARBINARY, (Object)BigintType.BIGINT);
        TableWriterOperator operator = (TableWriterOperator)this.createTableWriterOperator(pageSinkManager, (OperatorFactory)new AggregationOperator.AggregationOperatorFactory(1, new PlanNodeId("test"), AggregationNode.Step.SINGLE, (List)ImmutableList.of((Object)LONG_MAX.bind((List)ImmutableList.of((Object)0), Optional.empty()))), (List<Type>)outputTypes);
        operator.addInput(RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT}).row(42).build().get(0));
        operator.addInput(RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT}).row(43).build().get(0));
        Assert.assertTrue((boolean)operator.isBlocked().isDone());
        Assert.assertTrue((boolean)operator.needsInput());
        operator.finish();
        Assert.assertFalse((boolean)operator.isFinished());
        PageAssertions.assertPageEquals((List<? extends Type>)outputTypes, operator.getOutput(), RowPagesBuilder.rowPagesBuilder((Iterable<Type>)outputTypes).row(null, null, 43).build().get(0));
        PageAssertions.assertPageEquals((List<? extends Type>)outputTypes, operator.getOutput(), RowPagesBuilder.rowPagesBuilder((Iterable<Type>)outputTypes).row(2, null, null).build().get(0));
        Assert.assertTrue((boolean)operator.isBlocked().isDone());
        Assert.assertFalse((boolean)operator.needsInput());
        Assert.assertTrue((boolean)operator.isFinished());
        operator.close();
        this.assertMemoryIsReleased(operator);
    }

    private void assertMemoryIsReleased(TableWriterOperator tableWriterOperator) {
        OperatorContext tableWriterOperatorOperatorContext = tableWriterOperator.getOperatorContext();
        MemoryTrackingContext tableWriterMemoryContext = tableWriterOperatorOperatorContext.getOperatorMemoryContext();
        Assert.assertEquals((long)tableWriterMemoryContext.getSystemMemory(), (long)0L);
        Assert.assertEquals((long)tableWriterMemoryContext.getUserMemory(), (long)0L);
        Assert.assertEquals((long)tableWriterMemoryContext.getRevocableMemory(), (long)0L);
        Operator statisticAggregationOperator = tableWriterOperator.getStatisticAggregationOperator();
        Assert.assertTrue((boolean)(statisticAggregationOperator instanceof AggregationOperator));
        AggregationOperator aggregationOperator = (AggregationOperator)statisticAggregationOperator;
        OperatorContext aggregationOperatorOperatorContext = aggregationOperator.getOperatorContext();
        MemoryTrackingContext aggregationOperatorMemoryContext = aggregationOperatorOperatorContext.getOperatorMemoryContext();
        Assert.assertEquals((long)aggregationOperatorMemoryContext.getSystemMemory(), (long)0L);
        Assert.assertEquals((long)aggregationOperatorMemoryContext.getUserMemory(), (long)0L);
        Assert.assertEquals((long)aggregationOperatorMemoryContext.getRevocableMemory(), (long)0L);
    }

    private Operator createTableWriterOperator(BlockingPageSink blockingPageSink) {
        PageSinkManager pageSinkManager = new PageSinkManager();
        pageSinkManager.addConnectorPageSinkProvider(CONNECTOR_ID, (ConnectorPageSinkProvider)new ConstantPageSinkProvider(blockingPageSink));
        return this.createTableWriterOperator(pageSinkManager, (OperatorFactory)new DevNullOperator.DevNullOperatorFactory(1, new PlanNodeId("test")), (List<Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)VarbinaryType.VARBINARY));
    }

    private Operator createTableWriterOperator(PageSinkManager pageSinkManager, OperatorFactory statisticsAggregation, List<Type> outputTypes) {
        TableWriterOperator.TableWriterOperatorFactory factory = new TableWriterOperator.TableWriterOperatorFactory(0, new PlanNodeId("test"), pageSinkManager, (TableWriterNode.WriterTarget)new TableWriterNode.CreateHandle(new OutputTableHandle(CONNECTOR_ID, new ConnectorTransactionHandle(){}, new ConnectorOutputTableHandle(){}), new SchemaTableName("testSchema", "testTable")), (List)ImmutableList.of((Object)0), SessionTestUtils.TEST_SESSION, statisticsAggregation, outputTypes);
        return factory.createOperator(TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION).addPipelineContext(0, true, true).addDriverContext());
    }

    private static class MemoryAccountingTestPageSink
    implements ConnectorPageSink {
        private final List<Page> pages = new ArrayList<Page>();

        private MemoryAccountingTestPageSink() {
        }

        public CompletableFuture<?> appendPage(Page page) {
            this.pages.add(page);
            return NOT_BLOCKED;
        }

        public CompletableFuture<Collection<Slice>> finish() {
            return CompletableFuture.completedFuture(ImmutableList.of());
        }

        public long getSystemMemoryUsage() {
            long memoryUsage = 0L;
            for (Page page : this.pages) {
                memoryUsage += page.getRetainedSizeInBytes();
            }
            return memoryUsage;
        }

        public void abort() {
        }
    }

    private static class BlockingPageSink
    implements ConnectorPageSink {
        private CompletableFuture<?> future = new CompletableFuture();
        private CompletableFuture<Collection<Slice>> finishFuture = new CompletableFuture();

        private BlockingPageSink() {
        }

        public CompletableFuture<?> appendPage(Page page) {
            this.future = new CompletableFuture();
            return this.future;
        }

        public CompletableFuture<Collection<Slice>> finish() {
            this.finishFuture = new CompletableFuture();
            return this.finishFuture;
        }

        public void abort() {
        }

        void complete() {
            this.future.complete(null);
            this.finishFuture.complete((Collection<Slice>)ImmutableList.of());
        }
    }

    private static class ConstantPageSinkProvider
    implements ConnectorPageSinkProvider {
        private final ConnectorPageSink pageSink;

        private ConstantPageSinkProvider(ConnectorPageSink pageSink) {
            this.pageSink = pageSink;
        }

        public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorOutputTableHandle outputTableHandle) {
            return this.pageSink;
        }

        public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorInsertTableHandle insertTableHandle) {
            return this.pageSink;
        }
    }
}

