/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.PipelineStats;
import com.facebook.presto.operator.TaskStats;
import com.facebook.presto.operator.TestPipelineStats;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.json.JsonCodec;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestTaskStats {
    public static final TaskStats EXPECTED = new TaskStats(new DateTime(1L), new DateTime(2L), new DateTime(100L), new DateTime(101L), new DateTime(3L), new Duration(4.0, TimeUnit.NANOSECONDS), new Duration(5.0, TimeUnit.NANOSECONDS), 6, 7, 5, 8, 6, 24, 10, 11.0, new DataSize(12.0, DataSize.Unit.BYTE), new DataSize(13.0, DataSize.Unit.BYTE), new DataSize(14.0, DataSize.Unit.BYTE), new Duration(15.0, TimeUnit.NANOSECONDS), new Duration(16.0, TimeUnit.NANOSECONDS), new Duration(18.0, TimeUnit.NANOSECONDS), false, (Set)ImmutableSet.of(), new DataSize(19.0, DataSize.Unit.BYTE), 20L, new DataSize(21.0, DataSize.Unit.BYTE), 22L, new DataSize(23.0, DataSize.Unit.BYTE), 24L, new DataSize(25.0, DataSize.Unit.BYTE), 26, new Duration(27.0, TimeUnit.NANOSECONDS), (List)ImmutableList.of((Object)TestPipelineStats.EXPECTED));

    @Test
    public void testJson() {
        JsonCodec codec = JsonCodec.jsonCodec(TaskStats.class);
        String json = codec.toJson((Object)EXPECTED);
        TaskStats actual = (TaskStats)codec.fromJson(json);
        TestTaskStats.assertExpectedTaskStats(actual);
    }

    public static void assertExpectedTaskStats(TaskStats actual) {
        Assert.assertEquals((Object)actual.getCreateTime(), (Object)new DateTime(1L, DateTimeZone.UTC));
        Assert.assertEquals((Object)actual.getFirstStartTime(), (Object)new DateTime(2L, DateTimeZone.UTC));
        Assert.assertEquals((Object)actual.getLastStartTime(), (Object)new DateTime(100L, DateTimeZone.UTC));
        Assert.assertEquals((Object)actual.getLastEndTime(), (Object)new DateTime(101L, DateTimeZone.UTC));
        Assert.assertEquals((Object)actual.getEndTime(), (Object)new DateTime(3L, DateTimeZone.UTC));
        Assert.assertEquals((Object)actual.getElapsedTime(), (Object)new Duration(4.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getQueuedTime(), (Object)new Duration(5.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((int)actual.getTotalDrivers(), (int)6);
        Assert.assertEquals((int)actual.getQueuedDrivers(), (int)7);
        Assert.assertEquals((int)actual.getQueuedPartitionedDrivers(), (int)5);
        Assert.assertEquals((int)actual.getRunningDrivers(), (int)8);
        Assert.assertEquals((int)actual.getRunningPartitionedDrivers(), (int)6);
        Assert.assertEquals((int)actual.getBlockedDrivers(), (int)24);
        Assert.assertEquals((int)actual.getCompletedDrivers(), (int)10);
        Assert.assertEquals((Object)actual.getCumulativeUserMemory(), (Object)11.0);
        Assert.assertEquals((Object)actual.getUserMemoryReservation(), (Object)new DataSize(12.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getRevocableMemoryReservation(), (Object)new DataSize(13.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getSystemMemoryReservation(), (Object)new DataSize(14.0, DataSize.Unit.BYTE));
        Assert.assertEquals((Object)actual.getTotalScheduledTime(), (Object)new Duration(15.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getTotalCpuTime(), (Object)new Duration(16.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getTotalBlockedTime(), (Object)new Duration(18.0, TimeUnit.NANOSECONDS));
        Assert.assertEquals((Object)actual.getRawInputDataSize(), (Object)new DataSize(19.0, DataSize.Unit.BYTE));
        Assert.assertEquals((long)actual.getRawInputPositions(), (long)20L);
        Assert.assertEquals((Object)actual.getProcessedInputDataSize(), (Object)new DataSize(21.0, DataSize.Unit.BYTE));
        Assert.assertEquals((long)actual.getProcessedInputPositions(), (long)22L);
        Assert.assertEquals((Object)actual.getOutputDataSize(), (Object)new DataSize(23.0, DataSize.Unit.BYTE));
        Assert.assertEquals((long)actual.getOutputPositions(), (long)24L);
        Assert.assertEquals((Object)actual.getPhysicalWrittenDataSize(), (Object)new DataSize(25.0, DataSize.Unit.BYTE));
        Assert.assertEquals((int)actual.getPipelines().size(), (int)1);
        TestPipelineStats.assertExpectedPipelineStats((PipelineStats)actual.getPipelines().get(0));
    }
}

