/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.RowPagesBuilder;
import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.OperatorAssertion;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.UnnestOperator;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.type.ArrayType;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.RowType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.TestingTaskContext;
import com.facebook.presto.util.StructuralTestUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.concurrent.Threads;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestUnnestOperator {
    private ExecutorService executor;
    private ScheduledExecutorService scheduledExecutor;
    private DriverContext driverContext;

    @BeforeMethod
    public void setUp() {
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test-executor-%s"));
        this.scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)"test-scheduledExecutor-%s"));
        this.driverContext = TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION).addPipelineContext(0, true, true).addDriverContext();
    }

    @AfterMethod
    public void tearDown() {
        this.executor.shutdownNow();
        this.scheduledExecutor.shutdownNow();
    }

    @Test
    public void testUnnest() {
        MetadataManager metadata = MetadataManager.createTestMetadataManager();
        Type arrayType = metadata.getType(TypeSignature.parseTypeSignature((String)"array(bigint)"));
        Type mapType = metadata.getType(TypeSignature.parseTypeSignature((String)"map(bigint,bigint)"));
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT, arrayType, mapType}).row(1L, StructuralTestUtil.arrayBlockOf((Type)BigintType.BIGINT, 2, 3), StructuralTestUtil.mapBlockOf((Type)BigintType.BIGINT, (Type)BigintType.BIGINT, ImmutableMap.of((Object)4, (Object)5))).row(2L, StructuralTestUtil.arrayBlockOf((Type)BigintType.BIGINT, 99), null).row(3L, null, null).pageBreak().row(6L, StructuralTestUtil.arrayBlockOf((Type)BigintType.BIGINT, 7, 8), StructuralTestUtil.mapBlockOf((Type)BigintType.BIGINT, (Type)BigintType.BIGINT, ImmutableMap.of((Object)9, (Object)10, (Object)11, (Object)12))).build();
        UnnestOperator.UnnestOperatorFactory operatorFactory = new UnnestOperator.UnnestOperatorFactory(0, new PlanNodeId("test"), (List)ImmutableList.of((Object)0), (List)ImmutableList.of((Object)BigintType.BIGINT), (List)ImmutableList.of((Object)1, (Object)2), (List)ImmutableList.of((Object)arrayType, (Object)mapType), false);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT, BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{1L, 2L, 4L, 5L}).row(new Object[]{1L, 3L, null, null}).row(new Object[]{2L, 99L, null, null}).row(new Object[]{6L, 7L, 9L, 10L}).row(new Object[]{6L, 8L, 11L, 12L}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)operatorFactory, this.driverContext, input, expected);
    }

    @Test
    public void testUnnestWithArray() {
        MetadataManager metadata = MetadataManager.createTestMetadataManager();
        Type arrayType = metadata.getType(TypeSignature.parseTypeSignature((String)"array(array(bigint))"));
        Type mapType = metadata.getType(TypeSignature.parseTypeSignature((String)"map(array(bigint),array(bigint))"));
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT, arrayType, mapType}).row(1L, StructuralTestUtil.arrayBlockOf((Type)new ArrayType((Type)BigintType.BIGINT), ImmutableList.of((Object)2, (Object)4), ImmutableList.of((Object)3, (Object)6)), StructuralTestUtil.mapBlockOf((Type)new ArrayType((Type)BigintType.BIGINT), (Type)new ArrayType((Type)BigintType.BIGINT), ImmutableMap.of((Object)ImmutableList.of((Object)4, (Object)8), (Object)ImmutableList.of((Object)5, (Object)10)))).row(2L, StructuralTestUtil.arrayBlockOf((Type)new ArrayType((Type)BigintType.BIGINT), ImmutableList.of((Object)99, (Object)198)), null).row(3L, null, null).pageBreak().row(6, StructuralTestUtil.arrayBlockOf((Type)new ArrayType((Type)BigintType.BIGINT), ImmutableList.of((Object)7, (Object)14), ImmutableList.of((Object)8, (Object)16)), StructuralTestUtil.mapBlockOf((Type)new ArrayType((Type)BigintType.BIGINT), (Type)new ArrayType((Type)BigintType.BIGINT), ImmutableMap.of((Object)ImmutableList.of((Object)9, (Object)18), (Object)ImmutableList.of((Object)10, (Object)20), (Object)ImmutableList.of((Object)11, (Object)22), (Object)ImmutableList.of((Object)12, (Object)24)))).build();
        UnnestOperator.UnnestOperatorFactory operatorFactory = new UnnestOperator.UnnestOperatorFactory(0, new PlanNodeId("test"), (List)ImmutableList.of((Object)0), (List)ImmutableList.of((Object)BigintType.BIGINT), (List)ImmutableList.of((Object)1, (Object)2), (List)ImmutableList.of((Object)arrayType, (Object)mapType), false);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{BigintType.BIGINT, new ArrayType((Type)BigintType.BIGINT), new ArrayType((Type)BigintType.BIGINT), new ArrayType((Type)BigintType.BIGINT)}).row(new Object[]{1L, ImmutableList.of((Object)2L, (Object)4L), ImmutableList.of((Object)4L, (Object)8L), ImmutableList.of((Object)5L, (Object)10L)}).row(new Object[]{1L, ImmutableList.of((Object)3L, (Object)6L), null, null}).row(new Object[]{2L, ImmutableList.of((Object)99L, (Object)198L), null, null}).row(new Object[]{6L, ImmutableList.of((Object)7L, (Object)14L), ImmutableList.of((Object)9L, (Object)18L), ImmutableList.of((Object)10L, (Object)20L)}).row(new Object[]{6L, ImmutableList.of((Object)8L, (Object)16L), ImmutableList.of((Object)11L, (Object)22L), ImmutableList.of((Object)12L, (Object)24L)}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)operatorFactory, this.driverContext, input, expected);
    }

    @Test
    public void testUnnestWithOrdinality() {
        MetadataManager metadata = MetadataManager.createTestMetadataManager();
        Type arrayType = metadata.getType(TypeSignature.parseTypeSignature((String)"array(bigint)"));
        Type mapType = metadata.getType(TypeSignature.parseTypeSignature((String)"map(bigint,bigint)"));
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT, arrayType, mapType}).row(1L, StructuralTestUtil.arrayBlockOf((Type)BigintType.BIGINT, 2, 3), StructuralTestUtil.mapBlockOf((Type)BigintType.BIGINT, (Type)BigintType.BIGINT, ImmutableMap.of((Object)4, (Object)5))).row(2L, StructuralTestUtil.arrayBlockOf((Type)BigintType.BIGINT, 99), null).row(3L, null, null).pageBreak().row(6L, StructuralTestUtil.arrayBlockOf((Type)BigintType.BIGINT, 7, 8), StructuralTestUtil.mapBlockOf((Type)BigintType.BIGINT, (Type)BigintType.BIGINT, ImmutableMap.of((Object)9, (Object)10, (Object)11, (Object)12))).build();
        UnnestOperator.UnnestOperatorFactory operatorFactory = new UnnestOperator.UnnestOperatorFactory(0, new PlanNodeId("test"), (List)ImmutableList.of((Object)0), (List)ImmutableList.of((Object)BigintType.BIGINT), (List)ImmutableList.of((Object)1, (Object)2), (List)ImmutableList.of((Object)arrayType, (Object)mapType), true);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT, BigintType.BIGINT, BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{1L, 2L, 4L, 5L, 1L}).row(new Object[]{1L, 3L, null, null, 2L}).row(new Object[]{2L, 99L, null, null, 1L}).row(new Object[]{6L, 7L, 9L, 10L, 1L}).row(new Object[]{6L, 8L, 11L, 12L, 2L}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)operatorFactory, this.driverContext, input, expected);
    }

    @Test
    public void testUnnestNonNumericDoubles() {
        MetadataManager metadata = MetadataManager.createTestMetadataManager();
        Type arrayType = metadata.getType(TypeSignature.parseTypeSignature((String)"array(double)"));
        Type mapType = metadata.getType(TypeSignature.parseTypeSignature((String)"map(bigint,double)"));
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT, arrayType, mapType}).row(1L, StructuralTestUtil.arrayBlockOf((Type)DoubleType.DOUBLE, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NaN), StructuralTestUtil.mapBlockOf((Type)BigintType.BIGINT, (Type)DoubleType.DOUBLE, ImmutableMap.of((Object)1, (Object)Double.NEGATIVE_INFINITY, (Object)2, (Object)Double.POSITIVE_INFINITY, (Object)3, (Object)Double.NaN))).build();
        UnnestOperator.UnnestOperatorFactory operatorFactory = new UnnestOperator.UnnestOperatorFactory(0, new PlanNodeId("test"), (List)ImmutableList.of((Object)0), (List)ImmutableList.of((Object)BigintType.BIGINT), (List)ImmutableList.of((Object)1, (Object)2), (List)ImmutableList.of((Object)arrayType, (Object)mapType), false);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{BigintType.BIGINT, DoubleType.DOUBLE, BigintType.BIGINT, DoubleType.DOUBLE}).row(new Object[]{1L, Double.NEGATIVE_INFINITY, 1L, Double.NEGATIVE_INFINITY}).row(new Object[]{1L, Double.POSITIVE_INFINITY, 2L, Double.POSITIVE_INFINITY}).row(new Object[]{1L, Double.NaN, 3L, Double.NaN}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)operatorFactory, this.driverContext, input, expected);
    }

    @Test
    public void testUnnestWithArrayOfRows() {
        MetadataManager metadata = MetadataManager.createTestMetadataManager();
        Type arrayOfRowType = metadata.getType(TypeSignature.parseTypeSignature((String)"array(row(bigint, double, varchar))"));
        RowType elementType = RowType.anonymous((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE, (Object)VarcharType.VARCHAR));
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT, arrayOfRowType}).row(1, StructuralTestUtil.arrayBlockOf((Type)elementType, ImmutableList.of((Object)2, (Object)4.2, (Object)"abc"), ImmutableList.of((Object)3, (Object)6.6, (Object)"def"))).row(2, StructuralTestUtil.arrayBlockOf((Type)elementType, ImmutableList.of((Object)99, (Object)3.14, (Object)"pi"), null)).row(3, null).pageBreak().row(6, StructuralTestUtil.arrayBlockOf((Type)elementType, null, ImmutableList.of((Object)8, (Object)1.111, (Object)"tt"))).build();
        UnnestOperator.UnnestOperatorFactory operatorFactory = new UnnestOperator.UnnestOperatorFactory(0, new PlanNodeId("test"), (List)ImmutableList.of((Object)0), (List)ImmutableList.of((Object)BigintType.BIGINT), (List)ImmutableList.of((Object)1), (List)ImmutableList.of((Object)arrayOfRowType), false);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT, DoubleType.DOUBLE, VarcharType.VARCHAR}).row(new Object[]{1L, 2L, 4.2, "abc"}).row(new Object[]{1L, 3L, 6.6, "def"}).row(new Object[]{2L, 99L, 3.14, "pi"}).row(new Object[]{2L, null, null, null}).row(new Object[]{6L, null, null, null}).row(new Object[]{6L, 8L, 1.111, "tt"}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)operatorFactory, this.driverContext, input, expected);
    }
}

