/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.ExceededMemoryLimitException;
import com.facebook.presto.RowPagesBuilder;
import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.OperatorAssertion;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.PagesIndex;
import com.facebook.presto.operator.WindowFunctionDefinition;
import com.facebook.presto.operator.WindowOperator;
import com.facebook.presto.operator.window.FirstValueFunction;
import com.facebook.presto.operator.window.FrameInfo;
import com.facebook.presto.operator.window.LagFunction;
import com.facebook.presto.operator.window.LastValueFunction;
import com.facebook.presto.operator.window.LeadFunction;
import com.facebook.presto.operator.window.NthValueFunction;
import com.facebook.presto.operator.window.ReflectionWindowFunctionSupplier;
import com.facebook.presto.operator.window.RowNumberFunction;
import com.facebook.presto.operator.window.WindowFunctionSupplier;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.SortOrder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.tree.FrameBound;
import com.facebook.presto.sql.tree.WindowFrame;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.TestingTaskContext;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import io.airlift.concurrent.Threads;
import io.airlift.units.DataSize;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestWindowOperator {
    private static final FrameInfo UNBOUNDED_FRAME = new FrameInfo(WindowFrame.Type.RANGE, FrameBound.Type.UNBOUNDED_PRECEDING, Optional.empty(), FrameBound.Type.UNBOUNDED_FOLLOWING, Optional.empty());
    private static final List<WindowFunctionDefinition> ROW_NUMBER = ImmutableList.of((Object)WindowFunctionDefinition.window((WindowFunctionSupplier)new ReflectionWindowFunctionSupplier("row_number", (Type)BigintType.BIGINT, (List)ImmutableList.of(), RowNumberFunction.class), (Type)BigintType.BIGINT, (FrameInfo)UNBOUNDED_FRAME, (Integer[])new Integer[0]));
    private static final List<WindowFunctionDefinition> FIRST_VALUE = ImmutableList.of((Object)WindowFunctionDefinition.window((WindowFunctionSupplier)new ReflectionWindowFunctionSupplier("first_value", (Type)VarcharType.VARCHAR, (List)ImmutableList.of((Object)VarcharType.VARCHAR), FirstValueFunction.class), (Type)VarcharType.VARCHAR, (FrameInfo)UNBOUNDED_FRAME, (Integer[])new Integer[]{1}));
    private static final List<WindowFunctionDefinition> LAST_VALUE = ImmutableList.of((Object)WindowFunctionDefinition.window((WindowFunctionSupplier)new ReflectionWindowFunctionSupplier("last_value", (Type)VarcharType.VARCHAR, (List)ImmutableList.of((Object)VarcharType.VARCHAR), LastValueFunction.class), (Type)VarcharType.VARCHAR, (FrameInfo)UNBOUNDED_FRAME, (Integer[])new Integer[]{1}));
    private static final List<WindowFunctionDefinition> NTH_VALUE = ImmutableList.of((Object)WindowFunctionDefinition.window((WindowFunctionSupplier)new ReflectionWindowFunctionSupplier("nth_value", (Type)VarcharType.VARCHAR, (List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT), NthValueFunction.class), (Type)VarcharType.VARCHAR, (FrameInfo)UNBOUNDED_FRAME, (Integer[])new Integer[]{1, 3}));
    private static final List<WindowFunctionDefinition> LAG = ImmutableList.of((Object)WindowFunctionDefinition.window((WindowFunctionSupplier)new ReflectionWindowFunctionSupplier("lag", (Type)VarcharType.VARCHAR, (List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR), LagFunction.class), (Type)VarcharType.VARCHAR, (FrameInfo)UNBOUNDED_FRAME, (Integer[])new Integer[]{1, 3, 4}));
    private static final List<WindowFunctionDefinition> LEAD = ImmutableList.of((Object)WindowFunctionDefinition.window((WindowFunctionSupplier)new ReflectionWindowFunctionSupplier("lead", (Type)VarcharType.VARCHAR, (List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR), LeadFunction.class), (Type)VarcharType.VARCHAR, (FrameInfo)UNBOUNDED_FRAME, (Integer[])new Integer[]{1, 3, 4}));
    private ExecutorService executor;
    private ScheduledExecutorService scheduledExecutor;
    private DriverContext driverContext;

    @BeforeMethod
    public void setUp() {
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test-executor-%s"));
        this.scheduledExecutor = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)"test-scheduledExecutor-%s"));
        this.driverContext = TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION).addPipelineContext(0, true, true).addDriverContext();
    }

    @AfterMethod
    public void tearDown() {
        this.executor.shutdownNow();
        this.scheduledExecutor.shutdownNow();
    }

    @Test
    public void testRowNumber() {
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT, DoubleType.DOUBLE}).row(2L, 0.3).row(4L, 0.2).row(6L, 0.1).pageBreak().row(-1L, -0.1).row(5L, 0.4).build();
        WindowOperator.WindowOperatorFactory operatorFactory = TestWindowOperator.createFactoryUnbounded((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE), Ints.asList((int[])new int[]{1, 0}), ROW_NUMBER, Ints.asList((int[])new int[0]), Ints.asList((int[])new int[]{0}), (List<SortOrder>)ImmutableList.copyOf((Object[])new SortOrder[]{SortOrder.ASC_NULLS_LAST}));
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{DoubleType.DOUBLE, BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{-0.1, -1L, 1L}).row(new Object[]{0.3, 2L, 2L}).row(new Object[]{0.2, 4L, 3L}).row(new Object[]{0.4, 5L, 4L}).row(new Object[]{0.1, 6L, 5L}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)operatorFactory, this.driverContext, input, expected);
    }

    @Test
    public void testRowNumberPartition() {
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{VarcharType.VARCHAR, BigintType.BIGINT, DoubleType.DOUBLE, BooleanType.BOOLEAN}).row("b", -1L, -0.1, true).row("a", 2L, 0.3, false).row("a", 4L, 0.2, true).pageBreak().row("b", 5L, 0.4, false).row("a", 6L, 0.1, true).build();
        WindowOperator.WindowOperatorFactory operatorFactory = TestWindowOperator.createFactoryUnbounded((List<? extends Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE, (Object)BooleanType.BOOLEAN), Ints.asList((int[])new int[]{0, 1, 2, 3}), ROW_NUMBER, Ints.asList((int[])new int[]{0}), Ints.asList((int[])new int[]{1}), (List<SortOrder>)ImmutableList.copyOf((Object[])new SortOrder[]{SortOrder.ASC_NULLS_LAST}));
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, BigintType.BIGINT, DoubleType.DOUBLE, BooleanType.BOOLEAN, BigintType.BIGINT}).row(new Object[]{"a", 2L, 0.3, false, 1L}).row(new Object[]{"a", 4L, 0.2, true, 2L}).row(new Object[]{"a", 6L, 0.1, true, 3L}).row(new Object[]{"b", -1L, -0.1, true, 1L}).row(new Object[]{"b", 5L, 0.4, false, 2L}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)operatorFactory, this.driverContext, input, expected);
    }

    @Test
    public void testRowNumberArbitrary() {
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT}).row(1L).row(3L).row(5L).row(7L).pageBreak().row(2L).row(4L).row(6L).row(8L).build();
        WindowOperator.WindowOperatorFactory operatorFactory = TestWindowOperator.createFactoryUnbounded((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), Ints.asList((int[])new int[]{0}), ROW_NUMBER, Ints.asList((int[])new int[0]), Ints.asList((int[])new int[0]), (List<SortOrder>)ImmutableList.copyOf((Object[])new SortOrder[0]));
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{BigintType.BIGINT, BigintType.BIGINT}).row(new Object[]{1L, 1L}).row(new Object[]{3L, 2L}).row(new Object[]{5L, 3L}).row(new Object[]{7L, 4L}).row(new Object[]{2L, 5L}).row(new Object[]{4L, 6L}).row(new Object[]{6L, 7L}).row(new Object[]{8L, 8L}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)operatorFactory, this.driverContext, input, expected);
    }

    @Test(expectedExceptions={ExceededMemoryLimitException.class}, expectedExceptionsMessageRegExp="Query exceeded per-node user memory limit of 10B")
    public void testMemoryLimit() {
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT, DoubleType.DOUBLE}).row(1L, 0.1).row(2L, 0.2).pageBreak().row(-1L, -0.1).row(4L, 0.4).build();
        DriverContext driverContext = TestingTaskContext.createTaskContext((Executor)this.executor, (ScheduledExecutorService)this.scheduledExecutor, (Session)SessionTestUtils.TEST_SESSION, (DataSize)new DataSize(10.0, DataSize.Unit.BYTE)).addPipelineContext(0, true, true).addDriverContext();
        WindowOperator.WindowOperatorFactory operatorFactory = TestWindowOperator.createFactoryUnbounded((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE), Ints.asList((int[])new int[]{1}), ROW_NUMBER, Ints.asList((int[])new int[0]), Ints.asList((int[])new int[]{0}), (List<SortOrder>)ImmutableList.copyOf((Object[])new SortOrder[]{SortOrder.ASC_NULLS_LAST}));
        OperatorAssertion.toPages((OperatorFactory)operatorFactory, driverContext, input);
    }

    @Test
    public void testFirstValuePartition() {
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, BigintType.BIGINT, BooleanType.BOOLEAN, VarcharType.VARCHAR}).row("b", "A1", 1L, true, "").row("a", "A2", 1L, false, "").row("a", "B1", 2L, true, "").pageBreak().row("b", "C1", 2L, false, "").row("a", "C2", 3L, true, "").row("c", "A3", 1L, true, "").build();
        WindowOperator.WindowOperatorFactory operatorFactory = TestWindowOperator.createFactoryUnbounded((List<? extends Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BooleanType.BOOLEAN, (Object)VarcharType.VARCHAR), Ints.asList((int[])new int[]{0, 1, 2, 3}), FIRST_VALUE, Ints.asList((int[])new int[]{0}), Ints.asList((int[])new int[]{2}), (List<SortOrder>)ImmutableList.copyOf((Object[])new SortOrder[]{SortOrder.ASC_NULLS_LAST}));
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, BigintType.BIGINT, BooleanType.BOOLEAN, VarcharType.VARCHAR}).row(new Object[]{"a", "A2", 1L, false, "A2"}).row(new Object[]{"a", "B1", 2L, true, "A2"}).row(new Object[]{"a", "C2", 3L, true, "A2"}).row(new Object[]{"b", "A1", 1L, true, "A1"}).row(new Object[]{"b", "C1", 2L, false, "A1"}).row(new Object[]{"c", "A3", 1L, true, "A3"}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)operatorFactory, this.driverContext, input, expected);
    }

    @Test
    public void testLastValuePartition() {
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, BigintType.BIGINT, BooleanType.BOOLEAN, VarcharType.VARCHAR}).row("b", "A1", 1L, true, "").row("a", "A2", 1L, false, "").row("a", "B1", 2L, true, "").pageBreak().row("b", "C1", 2L, false, "").row("a", "C2", 3L, true, "").row("c", "A3", 1L, true, "").build();
        WindowOperator.WindowOperatorFactory operatorFactory = TestWindowOperator.createFactoryUnbounded((List<? extends Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BooleanType.BOOLEAN, (Object)VarcharType.VARCHAR), Ints.asList((int[])new int[]{0, 1, 2, 3}), LAST_VALUE, Ints.asList((int[])new int[]{0}), Ints.asList((int[])new int[]{2}), (List<SortOrder>)ImmutableList.copyOf((Object[])new SortOrder[]{SortOrder.ASC_NULLS_LAST}));
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, BigintType.BIGINT, BooleanType.BOOLEAN, VarcharType.VARCHAR}).row(new Object[]{"a", "A2", 1L, false, "C2"}).row(new Object[]{"a", "B1", 2L, true, "C2"}).row(new Object[]{"a", "C2", 3L, true, "C2"}).row(new Object[]{"b", "A1", 1L, true, "C1"}).row(new Object[]{"b", "C1", 2L, false, "C1"}).row(new Object[]{"c", "A3", 1L, true, "A3"}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)operatorFactory, this.driverContext, input, expected);
    }

    @Test
    public void testNthValuePartition() {
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, BigintType.BIGINT, BigintType.BIGINT, BooleanType.BOOLEAN, VarcharType.VARCHAR}).row("b", "A1", 1L, 2L, true, "").row("a", "A2", 1L, 3L, false, "").row("a", "B1", 2L, 2L, true, "").pageBreak().row("b", "C1", 2L, 3L, false, "").row("a", "C2", 3L, 1L, true, "").row("c", "A3", 1L, null, true, "").build();
        WindowOperator.WindowOperatorFactory operatorFactory = TestWindowOperator.createFactoryUnbounded((List<? extends Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT, (Object)BooleanType.BOOLEAN, (Object)VarcharType.VARCHAR), Ints.asList((int[])new int[]{0, 1, 2, 4}), NTH_VALUE, Ints.asList((int[])new int[]{0}), Ints.asList((int[])new int[]{2}), (List<SortOrder>)ImmutableList.copyOf((Object[])new SortOrder[]{SortOrder.ASC_NULLS_LAST}));
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, BigintType.BIGINT, BooleanType.BOOLEAN, VarcharType.VARCHAR}).row(new Object[]{"a", "A2", 1L, false, "C2"}).row(new Object[]{"a", "B1", 2L, true, "B1"}).row(new Object[]{"a", "C2", 3L, true, "A2"}).row(new Object[]{"b", "A1", 1L, true, "C1"}).row(new Object[]{"b", "C1", 2L, false, null}).row(new Object[]{"c", "A3", 1L, true, null}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)operatorFactory, this.driverContext, input, expected);
    }

    @Test
    public void testLagPartition() {
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, BigintType.BIGINT, BigintType.BIGINT, VarcharType.VARCHAR, BooleanType.BOOLEAN, VarcharType.VARCHAR}).row("b", "A1", 1L, 1L, "D", true, "").row("a", "A2", 1L, 2L, "D", false, "").row("a", "B1", 2L, 2L, "D", true, "").pageBreak().row("b", "C1", 2L, 1L, "D", false, "").row("a", "C2", 3L, 2L, "D", true, "").row("c", "A3", 1L, 1L, "D", true, "").build();
        WindowOperator.WindowOperatorFactory operatorFactory = TestWindowOperator.createFactoryUnbounded((List<? extends Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR, (Object)BooleanType.BOOLEAN, (Object)VarcharType.VARCHAR), Ints.asList((int[])new int[]{0, 1, 2, 5}), LAG, Ints.asList((int[])new int[]{0}), Ints.asList((int[])new int[]{2}), (List<SortOrder>)ImmutableList.copyOf((Object[])new SortOrder[]{SortOrder.ASC_NULLS_LAST}));
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, BigintType.BIGINT, BooleanType.BOOLEAN, VarcharType.VARCHAR}).row(new Object[]{"a", "A2", 1L, false, "D"}).row(new Object[]{"a", "B1", 2L, true, "D"}).row(new Object[]{"a", "C2", 3L, true, "A2"}).row(new Object[]{"b", "A1", 1L, true, "D"}).row(new Object[]{"b", "C1", 2L, false, "A1"}).row(new Object[]{"c", "A3", 1L, true, "D"}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)operatorFactory, this.driverContext, input, expected);
    }

    @Test
    public void testLeadPartition() {
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, BigintType.BIGINT, BigintType.BIGINT, VarcharType.VARCHAR, BooleanType.BOOLEAN, VarcharType.VARCHAR}).row("b", "A1", 1L, 1L, "D", true, "").row("a", "A2", 1L, 2L, "D", false, "").row("a", "B1", 2L, 2L, "D", true, "").pageBreak().row("b", "C1", 2L, 1L, "D", false, "").row("a", "C2", 3L, 2L, "D", true, "").row("c", "A3", 1L, 1L, "D", true, "").build();
        WindowOperator.WindowOperatorFactory operatorFactory = TestWindowOperator.createFactoryUnbounded((List<? extends Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR, (Object)BooleanType.BOOLEAN, (Object)VarcharType.VARCHAR), Ints.asList((int[])new int[]{0, 1, 2, 5}), LEAD, Ints.asList((int[])new int[]{0}), Ints.asList((int[])new int[]{2}), (List<SortOrder>)ImmutableList.copyOf((Object[])new SortOrder[]{SortOrder.ASC_NULLS_LAST}));
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{VarcharType.VARCHAR, VarcharType.VARCHAR, BigintType.BIGINT, BooleanType.BOOLEAN, VarcharType.VARCHAR}).row(new Object[]{"a", "A2", 1L, false, "C2"}).row(new Object[]{"a", "B1", 2L, true, "D"}).row(new Object[]{"a", "C2", 3L, true, "D"}).row(new Object[]{"b", "A1", 1L, true, "C1"}).row(new Object[]{"b", "C1", 2L, false, "D"}).row(new Object[]{"c", "A3", 1L, true, "D"}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)operatorFactory, this.driverContext, input, expected);
    }

    @Test
    public void testPartiallyPreGroupedPartitionWithEmptyInput() {
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT, VarcharType.VARCHAR}).pageBreak().pageBreak().build();
        WindowOperator.WindowOperatorFactory operatorFactory = TestWindowOperator.createFactoryUnbounded((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR), Ints.asList((int[])new int[]{0, 1, 2, 3}), ROW_NUMBER, Ints.asList((int[])new int[]{0, 1}), Ints.asList((int[])new int[]{1}), Ints.asList((int[])new int[]{3}), (List<SortOrder>)ImmutableList.of((Object)SortOrder.ASC_NULLS_LAST), 0);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)operatorFactory, this.driverContext, input, expected);
    }

    @Test
    public void testPartiallyPreGroupedPartition() {
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT, VarcharType.VARCHAR}).pageBreak().row(1L, "a", 100L, "A").row(2L, "a", 101L, "B").pageBreak().row(3L, "b", 102L, "E").row(1L, "b", 103L, "D").pageBreak().row(3L, "b", 104L, "C").row(1L, "c", 105L, "F").pageBreak().build();
        WindowOperator.WindowOperatorFactory operatorFactory = TestWindowOperator.createFactoryUnbounded((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR), Ints.asList((int[])new int[]{0, 1, 2, 3}), ROW_NUMBER, Ints.asList((int[])new int[]{0, 1}), Ints.asList((int[])new int[]{1}), Ints.asList((int[])new int[]{3}), (List<SortOrder>)ImmutableList.of((Object)SortOrder.ASC_NULLS_LAST), 0);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{1L, "a", 100L, "A", 1L}).row(new Object[]{2L, "a", 101L, "B", 1L}).row(new Object[]{3L, "b", 104L, "C", 1L}).row(new Object[]{3L, "b", 102L, "E", 2L}).row(new Object[]{1L, "b", 103L, "D", 1L}).row(new Object[]{1L, "c", 105L, "F", 1L}).build();
        OperatorAssertion.assertOperatorEqualsIgnoreOrder((OperatorFactory)operatorFactory, this.driverContext, input, expected);
    }

    @Test
    public void testFullyPreGroupedPartition() {
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT, VarcharType.VARCHAR}).pageBreak().row(1L, "a", 100L, "A").pageBreak().row(2L, "a", 101L, "B").pageBreak().row(2L, "b", 102L, "D").row(2L, "b", 103L, "C").row(1L, "b", 104L, "E").pageBreak().row(1L, "b", 105L, "F").row(3L, "c", 106L, "G").build();
        WindowOperator.WindowOperatorFactory operatorFactory = TestWindowOperator.createFactoryUnbounded((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR), Ints.asList((int[])new int[]{0, 1, 2, 3}), ROW_NUMBER, Ints.asList((int[])new int[]{1, 0}), Ints.asList((int[])new int[]{0, 1}), Ints.asList((int[])new int[]{3}), (List<SortOrder>)ImmutableList.of((Object)SortOrder.ASC_NULLS_LAST), 0);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{1L, "a", 100L, "A", 1L}).row(new Object[]{2L, "a", 101L, "B", 1L}).row(new Object[]{2L, "b", 103L, "C", 1L}).row(new Object[]{2L, "b", 102L, "D", 2L}).row(new Object[]{1L, "b", 104L, "E", 1L}).row(new Object[]{1L, "b", 105L, "F", 2L}).row(new Object[]{3L, "c", 106L, "G", 1L}).build();
        OperatorAssertion.assertOperatorEqualsIgnoreOrder((OperatorFactory)operatorFactory, this.driverContext, input, expected);
    }

    @Test
    public void testFullyPreGroupedAndPartiallySortedPartition() {
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT, VarcharType.VARCHAR}).pageBreak().row(1L, "a", 100L, "A").pageBreak().row(2L, "a", 100L, "A").pageBreak().row(2L, "b", 102L, "A").row(2L, "b", 101L, "A").row(2L, "b", 100L, "B").row(1L, "b", 101L, "A").pageBreak().row(1L, "b", 100L, "A").row(3L, "c", 100L, "A").build();
        WindowOperator.WindowOperatorFactory operatorFactory = TestWindowOperator.createFactoryUnbounded((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR), Ints.asList((int[])new int[]{0, 1, 2, 3}), ROW_NUMBER, Ints.asList((int[])new int[]{1, 0}), Ints.asList((int[])new int[]{0, 1}), Ints.asList((int[])new int[]{3, 2}), (List<SortOrder>)ImmutableList.of((Object)SortOrder.ASC_NULLS_LAST, (Object)SortOrder.ASC_NULLS_LAST), 1);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{1L, "a", 100L, "A", 1L}).row(new Object[]{2L, "a", 100L, "A", 1L}).row(new Object[]{2L, "b", 101L, "A", 1L}).row(new Object[]{2L, "b", 102L, "A", 2L}).row(new Object[]{2L, "b", 100L, "B", 3L}).row(new Object[]{1L, "b", 100L, "A", 1L}).row(new Object[]{1L, "b", 101L, "A", 2L}).row(new Object[]{3L, "c", 100L, "A", 1L}).build();
        OperatorAssertion.assertOperatorEqualsIgnoreOrder((OperatorFactory)operatorFactory, this.driverContext, input, expected);
    }

    @Test
    public void testFullyPreGroupedAndFullySortedPartition() {
        List<Page> input = RowPagesBuilder.rowPagesBuilder(new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT, VarcharType.VARCHAR}).pageBreak().row(1L, "a", 100L, "A").pageBreak().row(2L, "a", 101L, "A").pageBreak().row(2L, "b", 102L, "A").row(2L, "b", 103L, "A").row(2L, "b", 104L, "B").row(1L, "b", 105L, "A").pageBreak().row(1L, "b", 106L, "A").row(3L, "c", 107L, "A").build();
        WindowOperator.WindowOperatorFactory operatorFactory = TestWindowOperator.createFactoryUnbounded((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR), Ints.asList((int[])new int[]{0, 1, 2, 3}), ROW_NUMBER, Ints.asList((int[])new int[]{1, 0}), Ints.asList((int[])new int[]{0, 1}), Ints.asList((int[])new int[]{3}), (List<SortOrder>)ImmutableList.of((Object)SortOrder.ASC_NULLS_LAST), 1);
        MaterializedResult expected = MaterializedResult.resultBuilder((Session)this.driverContext.getSession(), (Type[])new Type[]{BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT, VarcharType.VARCHAR, BigintType.BIGINT}).row(new Object[]{1L, "a", 100L, "A", 1L}).row(new Object[]{2L, "a", 101L, "A", 1L}).row(new Object[]{2L, "b", 102L, "A", 1L}).row(new Object[]{2L, "b", 103L, "A", 2L}).row(new Object[]{2L, "b", 104L, "B", 3L}).row(new Object[]{1L, "b", 105L, "A", 1L}).row(new Object[]{1L, "b", 106L, "A", 2L}).row(new Object[]{3L, "c", 107L, "A", 1L}).build();
        OperatorAssertion.assertOperatorEquals((OperatorFactory)operatorFactory, this.driverContext, input, expected);
    }

    @Test
    public void testFindEndPosition() {
        TestWindowOperator.assertFindEndPosition("0", 1);
        TestWindowOperator.assertFindEndPosition("11", 2);
        TestWindowOperator.assertFindEndPosition("1111111111", 10);
        TestWindowOperator.assertFindEndPosition("01", 1);
        TestWindowOperator.assertFindEndPosition("011", 1);
        TestWindowOperator.assertFindEndPosition("0111", 1);
        TestWindowOperator.assertFindEndPosition("0111111111", 1);
        TestWindowOperator.assertFindEndPosition("012", 1);
        TestWindowOperator.assertFindEndPosition("01234", 1);
        TestWindowOperator.assertFindEndPosition("0123456789", 1);
        TestWindowOperator.assertFindEndPosition("001", 2);
        TestWindowOperator.assertFindEndPosition("0001", 3);
        TestWindowOperator.assertFindEndPosition("0000000001", 9);
        TestWindowOperator.assertFindEndPosition("00100", 2);
        TestWindowOperator.assertFindEndPosition("000111", 3);
        TestWindowOperator.assertFindEndPosition("0001111", 3);
        TestWindowOperator.assertFindEndPosition("0000111", 4);
        TestWindowOperator.assertFindEndPosition("000000000000001111111111", 14);
    }

    private static void assertFindEndPosition(String values, int expected) {
        char[] array = values.toCharArray();
        Assert.assertEquals((int)WindowOperator.findEndPosition((int)0, (int)array.length, (first, second) -> array[first] == array[second]), (int)expected);
    }

    private static WindowOperator.WindowOperatorFactory createFactoryUnbounded(List<? extends Type> sourceTypes, List<Integer> outputChannels, List<WindowFunctionDefinition> functions, List<Integer> partitionChannels, List<Integer> sortChannels, List<SortOrder> sortOrder) {
        return TestWindowOperator.createFactoryUnbounded(sourceTypes, outputChannels, functions, partitionChannels, (List<Integer>)ImmutableList.of(), sortChannels, sortOrder, 0);
    }

    private static WindowOperator.WindowOperatorFactory createFactoryUnbounded(List<? extends Type> sourceTypes, List<Integer> outputChannels, List<WindowFunctionDefinition> functions, List<Integer> partitionChannels, List<Integer> preGroupedChannels, List<Integer> sortChannels, List<SortOrder> sortOrder, int preSortedChannelPrefix) {
        return new WindowOperator.WindowOperatorFactory(0, new PlanNodeId("test"), sourceTypes, outputChannels, functions, partitionChannels, preGroupedChannels, sortChannels, sortOrder, preSortedChannelPrefix, 10, (PagesIndex.Factory)new PagesIndex.TestingFactory(false));
    }
}

