/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.AbstractTestAggregationFunction;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.DecimalType;
import com.facebook.presto.spi.type.SqlDecimal;
import java.math.BigDecimal;

public abstract class AbstractTestDecimalAverageAggregation
extends AbstractTestAggregationFunction {
    protected abstract DecimalType getDecimalType();

    @Override
    public Block[] getSequenceBlocks(int start, int length) {
        BlockBuilder blockBuilder = this.getDecimalType().createBlockBuilder(null, length);
        for (int i = start; i < start + length; ++i) {
            this.writeDecimalToBlock(AbstractTestDecimalAverageAggregation.getBigDecimalForCounter(i), blockBuilder);
        }
        return new Block[]{blockBuilder.build()};
    }

    protected abstract void writeDecimalToBlock(BigDecimal var1, BlockBuilder var2);

    private static BigDecimal getBigDecimalForCounter(int i) {
        String iAsString = String.valueOf(Math.abs(i));
        return new BigDecimal(String.valueOf(i) + "." + iAsString + iAsString).setScale(2, 1);
    }

    public SqlDecimal getExpectedValue(int start, int length) {
        if (length == 0) {
            return null;
        }
        BigDecimal avg = BigDecimal.ZERO;
        for (int i = start; i < start + length; ++i) {
            avg = avg.add(AbstractTestDecimalAverageAggregation.getBigDecimalForCounter(i));
        }
        avg = avg.divide(BigDecimal.valueOf(length), 4);
        return new SqlDecimal(avg.unscaledValue(), avg.precision(), avg.scale());
    }

    @Override
    protected String getFunctionName() {
        return "avg";
    }
}

