/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.operator.aggregation.AggregationTestUtils;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeSignature;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestArbitraryAggregation {
    private static final MetadataManager metadata = MetadataManager.createTestMetadataManager();

    @Test
    public void testAllRegistered() {
        Set allTypes = (Set)metadata.getTypeManager().getTypes().stream().collect(ImmutableSet.toImmutableSet());
        for (Type valueType : allTypes) {
            Assert.assertNotNull((Object)metadata.getFunctionRegistry().getAggregateFunctionImplementation(new Signature("arbitrary", FunctionKind.AGGREGATE, valueType.getTypeSignature(), new TypeSignature[]{valueType.getTypeSignature()})));
        }
    }

    @Test
    public void testNullBoolean() {
        InternalAggregationFunction booleanAgg = metadata.getFunctionRegistry().getAggregateFunctionImplementation(new Signature("arbitrary", FunctionKind.AGGREGATE, TypeSignature.parseTypeSignature((String)"boolean"), new TypeSignature[]{TypeSignature.parseTypeSignature((String)"boolean")}));
        AggregationTestUtils.assertAggregation(booleanAgg, null, BlockAssertions.createBooleansBlock(new Boolean[]{null}));
    }

    @Test
    public void testValidBoolean() {
        InternalAggregationFunction booleanAgg = metadata.getFunctionRegistry().getAggregateFunctionImplementation(new Signature("arbitrary", FunctionKind.AGGREGATE, TypeSignature.parseTypeSignature((String)"boolean"), new TypeSignature[]{TypeSignature.parseTypeSignature((String)"boolean")}));
        AggregationTestUtils.assertAggregation(booleanAgg, (Object)true, BlockAssertions.createBooleansBlock(true, true));
    }

    @Test
    public void testNullLong() {
        InternalAggregationFunction longAgg = metadata.getFunctionRegistry().getAggregateFunctionImplementation(new Signature("arbitrary", FunctionKind.AGGREGATE, TypeSignature.parseTypeSignature((String)"bigint"), new TypeSignature[]{TypeSignature.parseTypeSignature((String)"bigint")}));
        AggregationTestUtils.assertAggregation(longAgg, null, BlockAssertions.createLongsBlock(null, null));
    }

    @Test
    public void testValidLong() {
        InternalAggregationFunction longAgg = metadata.getFunctionRegistry().getAggregateFunctionImplementation(new Signature("arbitrary", FunctionKind.AGGREGATE, TypeSignature.parseTypeSignature((String)"bigint"), new TypeSignature[]{TypeSignature.parseTypeSignature((String)"bigint")}));
        AggregationTestUtils.assertAggregation(longAgg, (Object)1L, BlockAssertions.createLongsBlock(1L, null));
    }

    @Test
    public void testNullDouble() {
        InternalAggregationFunction doubleAgg = metadata.getFunctionRegistry().getAggregateFunctionImplementation(new Signature("arbitrary", FunctionKind.AGGREGATE, TypeSignature.parseTypeSignature((String)"double"), new TypeSignature[]{TypeSignature.parseTypeSignature((String)"double")}));
        AggregationTestUtils.assertAggregation(doubleAgg, null, BlockAssertions.createDoublesBlock(null, null));
    }

    @Test
    public void testValidDouble() {
        InternalAggregationFunction doubleAgg = metadata.getFunctionRegistry().getAggregateFunctionImplementation(new Signature("arbitrary", FunctionKind.AGGREGATE, TypeSignature.parseTypeSignature((String)"double"), new TypeSignature[]{TypeSignature.parseTypeSignature((String)"double")}));
        AggregationTestUtils.assertAggregation(doubleAgg, (Object)2.0, BlockAssertions.createDoublesBlock(null, 2.0));
    }

    @Test
    public void testNullString() {
        InternalAggregationFunction stringAgg = metadata.getFunctionRegistry().getAggregateFunctionImplementation(new Signature("arbitrary", FunctionKind.AGGREGATE, TypeSignature.parseTypeSignature((String)"varchar"), new TypeSignature[]{TypeSignature.parseTypeSignature((String)"varchar")}));
        AggregationTestUtils.assertAggregation(stringAgg, null, BlockAssertions.createStringsBlock(null, null));
    }

    @Test
    public void testValidString() {
        InternalAggregationFunction stringAgg = metadata.getFunctionRegistry().getAggregateFunctionImplementation(new Signature("arbitrary", FunctionKind.AGGREGATE, TypeSignature.parseTypeSignature((String)"varchar"), new TypeSignature[]{TypeSignature.parseTypeSignature((String)"varchar")}));
        AggregationTestUtils.assertAggregation(stringAgg, (Object)"a", BlockAssertions.createStringsBlock("a", "a"));
    }

    @Test
    public void testNullArray() {
        InternalAggregationFunction arrayAgg = metadata.getFunctionRegistry().getAggregateFunctionImplementation(new Signature("arbitrary", FunctionKind.AGGREGATE, TypeSignature.parseTypeSignature((String)"array(bigint)"), new TypeSignature[]{TypeSignature.parseTypeSignature((String)"array(bigint)")}));
        AggregationTestUtils.assertAggregation(arrayAgg, null, BlockAssertions.createArrayBigintBlock(Arrays.asList(null, null, null, null)));
    }

    @Test
    public void testValidArray() {
        InternalAggregationFunction arrayAgg = metadata.getFunctionRegistry().getAggregateFunctionImplementation(new Signature("arbitrary", FunctionKind.AGGREGATE, TypeSignature.parseTypeSignature((String)"array(bigint)"), new TypeSignature[]{TypeSignature.parseTypeSignature((String)"array(bigint)")}));
        AggregationTestUtils.assertAggregation(arrayAgg, (Object)ImmutableList.of((Object)23L, (Object)45L), BlockAssertions.createArrayBigintBlock((Iterable<? extends Iterable<Long>>)ImmutableList.of((Object)ImmutableList.of((Object)23L, (Object)45L), (Object)ImmutableList.of((Object)23L, (Object)45L), (Object)ImmutableList.of((Object)23L, (Object)45L), (Object)ImmutableList.of((Object)23L, (Object)45L))));
    }

    @Test
    public void testValidInt() {
        InternalAggregationFunction arrayAgg = metadata.getFunctionRegistry().getAggregateFunctionImplementation(new Signature("arbitrary", FunctionKind.AGGREGATE, TypeSignature.parseTypeSignature((String)"integer"), new TypeSignature[]{TypeSignature.parseTypeSignature((String)"integer")}));
        AggregationTestUtils.assertAggregation(arrayAgg, (Object)3, BlockAssertions.createIntsBlock(3, 3, null));
    }
}

