/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.operator.aggregation.AbstractTestAggregationFunction;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.ArrayType;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.PriorityQueue;
import java.util.stream.LongStream;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestArrayMaxNAggregation
extends AbstractTestAggregationFunction {
    public static Block createLongArraysBlock(Long[] values) {
        ArrayType arrayType = new ArrayType((Type)BigintType.BIGINT);
        BlockBuilder blockBuilder = arrayType.createBlockBuilder(null, values.length);
        for (Long value : values) {
            if (value == null) {
                blockBuilder.appendNull();
                continue;
            }
            BlockBuilder elementBlockBuilder = blockBuilder.beginBlockEntry();
            BigintType.BIGINT.writeLong(elementBlockBuilder, value.longValue());
            blockBuilder.closeEntry();
        }
        return blockBuilder.build();
    }

    public static Block createLongArraySequenceBlock(int start, int length) {
        return TestArrayMaxNAggregation.createLongArraysBlock((Long[])LongStream.range(start, length).boxed().toArray(Long[]::new));
    }

    @Override
    public Block[] getSequenceBlocks(int start, int length) {
        return new Block[]{TestArrayMaxNAggregation.createLongArraySequenceBlock(start, start + length), BlockAssertions.createLongRepeatBlock(2, length)};
    }

    @Override
    protected String getFunctionName() {
        return "max";
    }

    @Override
    protected List<String> getFunctionParameterTypes() {
        return ImmutableList.of((Object)"array(bigint)", (Object)"bigint");
    }

    @Override
    public Object getExpectedValue(int start, int length) {
        if (length == 0) {
            return null;
        }
        if (length == 1) {
            return ImmutableList.of((Object)ImmutableList.of((Object)start));
        }
        return ImmutableList.of((Object)ImmutableList.of((Object)((long)start + (long)length - 1L)), (Object)ImmutableList.of((Object)((long)start + (long)length - 2L)));
    }

    @Test
    public void testMoreCornerCases() {
        this.testCustomAggregation(new Long[]{1L, 2L, null, 3L}, 5);
        this.testInvalidAggregation(new Long[]{1L, 2L, 3L}, 0);
        this.testInvalidAggregation(new Long[]{1L, 2L, 3L}, -1);
        this.testInvalidAggregation(new Long[]{1L, 2L, 3L}, 10001);
    }

    private void testInvalidAggregation(Long[] x, int n) {
        try {
            this.testAggregation(null, TestArrayMaxNAggregation.createLongArraysBlock(x), BlockAssertions.createLongRepeatBlock(n, x.length));
        }
        catch (PrestoException e) {
            Assert.assertEquals((String)e.getErrorCode().getName(), (String)StandardErrorCode.INVALID_FUNCTION_ARGUMENT.name());
        }
    }

    private void testCustomAggregation(Long[] values, int n) {
        PriorityQueue heap = new PriorityQueue(n);
        Arrays.stream(values).filter(x -> x != null).forEach(heap::add);
        ImmutableList.Builder expected = new ImmutableList.Builder();
        for (int i = heap.size() - 1; i >= 0; --i) {
            expected.add((Object)ImmutableList.of(heap.remove()));
        }
        this.testAggregation(Lists.reverse((List)expected.build()), TestArrayMaxNAggregation.createLongArraysBlock(values), BlockAssertions.createLongRepeatBlock(n, values.length));
    }
}

