/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.AbstractTestAggregationFunction;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.ArrayType;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.util.StructuralTestUtil;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class TestArrayMinAggregation
extends AbstractTestAggregationFunction {
    @Override
    public Block[] getSequenceBlocks(int start, int length) {
        ArrayType arrayType = new ArrayType((Type)BigintType.BIGINT);
        BlockBuilder blockBuilder = arrayType.createBlockBuilder(null, length);
        for (int i = start; i < start + length; ++i) {
            arrayType.writeObject(blockBuilder, (Object)StructuralTestUtil.arrayBlockOf((Type)BigintType.BIGINT, i));
        }
        return new Block[]{blockBuilder.build()};
    }

    @Override
    public List<Long> getExpectedValue(int start, int length) {
        if (length == 0) {
            return null;
        }
        return ImmutableList.of((Object)start);
    }

    @Override
    protected String getFunctionName() {
        return "min";
    }

    @Override
    protected List<String> getFunctionParameterTypes() {
        return ImmutableList.of((Object)"array(bigint)");
    }
}

