/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.operator.aggregation.AggregationTestUtils;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.ArrayType;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DecimalType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.SqlVarbinary;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.spi.type.VarcharType;
import io.airlift.slice.Slices;
import java.util.Arrays;
import org.testng.annotations.Test;

public class TestChecksumAggregation {
    private static final MetadataManager metadata = MetadataManager.createTestMetadataManager();

    @Test
    public void testEmpty() {
        InternalAggregationFunction booleanAgg = metadata.getFunctionRegistry().getAggregateFunctionImplementation(new Signature("checksum", FunctionKind.AGGREGATE, TypeSignature.parseTypeSignature((String)"varbinary"), new TypeSignature[]{TypeSignature.parseTypeSignature((String)"boolean")}));
        AggregationTestUtils.assertAggregation(booleanAgg, null, BlockAssertions.createBooleansBlock(new Boolean[0]));
    }

    @Test
    public void testBoolean() {
        InternalAggregationFunction booleanAgg = metadata.getFunctionRegistry().getAggregateFunctionImplementation(new Signature("checksum", FunctionKind.AGGREGATE, TypeSignature.parseTypeSignature((String)"varbinary"), new TypeSignature[]{TypeSignature.parseTypeSignature((String)"boolean")}));
        Block block = BlockAssertions.createBooleansBlock(null, null, true, false, false);
        AggregationTestUtils.assertAggregation(booleanAgg, (Object)TestChecksumAggregation.expectedChecksum((Type)BooleanType.BOOLEAN, block), block);
    }

    @Test
    public void testLong() {
        InternalAggregationFunction longAgg = metadata.getFunctionRegistry().getAggregateFunctionImplementation(new Signature("checksum", FunctionKind.AGGREGATE, TypeSignature.parseTypeSignature((String)"varbinary"), new TypeSignature[]{TypeSignature.parseTypeSignature((String)"bigint")}));
        Block block = BlockAssertions.createLongsBlock(null, 1L, 2L, 100L, null, Long.MAX_VALUE, Long.MIN_VALUE);
        AggregationTestUtils.assertAggregation(longAgg, (Object)TestChecksumAggregation.expectedChecksum((Type)BigintType.BIGINT, block), block);
    }

    @Test
    public void testDouble() {
        InternalAggregationFunction doubleAgg = metadata.getFunctionRegistry().getAggregateFunctionImplementation(new Signature("checksum", FunctionKind.AGGREGATE, TypeSignature.parseTypeSignature((String)"varbinary"), new TypeSignature[]{TypeSignature.parseTypeSignature((String)"double")}));
        Block block = BlockAssertions.createDoublesBlock(null, 2.0, null, 3.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NaN);
        AggregationTestUtils.assertAggregation(doubleAgg, (Object)TestChecksumAggregation.expectedChecksum((Type)DoubleType.DOUBLE, block), block);
    }

    @Test
    public void testString() {
        InternalAggregationFunction stringAgg = metadata.getFunctionRegistry().getAggregateFunctionImplementation(new Signature("checksum", FunctionKind.AGGREGATE, TypeSignature.parseTypeSignature((String)"varbinary"), new TypeSignature[]{TypeSignature.parseTypeSignature((String)"varchar")}));
        Block block = BlockAssertions.createStringsBlock("a", "a", null, "b", "c");
        AggregationTestUtils.assertAggregation(stringAgg, (Object)TestChecksumAggregation.expectedChecksum((Type)VarcharType.VARCHAR, block), block);
    }

    @Test
    public void testShortDecimal() {
        InternalAggregationFunction decimalAgg = metadata.getFunctionRegistry().getAggregateFunctionImplementation(new Signature("checksum", FunctionKind.AGGREGATE, TypeSignature.parseTypeSignature((String)"varbinary"), new TypeSignature[]{TypeSignature.parseTypeSignature((String)"decimal(10,2)")}));
        Block block = BlockAssertions.createShortDecimalsBlock("11.11", "22.22", null, "33.33", "44.44");
        DecimalType shortDecimalType = DecimalType.createDecimalType((int)1);
        AggregationTestUtils.assertAggregation(decimalAgg, (Object)TestChecksumAggregation.expectedChecksum((Type)shortDecimalType, block), block);
    }

    @Test
    public void testLongDecimal() {
        InternalAggregationFunction decimalAgg = metadata.getFunctionRegistry().getAggregateFunctionImplementation(new Signature("checksum", FunctionKind.AGGREGATE, TypeSignature.parseTypeSignature((String)"varbinary"), new TypeSignature[]{TypeSignature.parseTypeSignature((String)"decimal(19,2)")}));
        Block block = BlockAssertions.createLongDecimalsBlock("11.11", "22.22", null, "33.33", "44.44");
        DecimalType longDecimalType = DecimalType.createDecimalType((int)19);
        AggregationTestUtils.assertAggregation(decimalAgg, (Object)TestChecksumAggregation.expectedChecksum((Type)longDecimalType, block), block);
    }

    @Test
    public void testArray() {
        ArrayType arrayType = new ArrayType((Type)BigintType.BIGINT);
        InternalAggregationFunction stringAgg = metadata.getFunctionRegistry().getAggregateFunctionImplementation(new Signature("checksum", FunctionKind.AGGREGATE, VarbinaryType.VARBINARY.getTypeSignature(), new TypeSignature[]{arrayType.getTypeSignature()}));
        Block block = BlockAssertions.createArrayBigintBlock(Arrays.asList(null, Arrays.asList(1L, 2L), Arrays.asList(3L, 4L), Arrays.asList(5L, 6L)));
        AggregationTestUtils.assertAggregation(stringAgg, (Object)TestChecksumAggregation.expectedChecksum((Type)arrayType, block), block);
    }

    private static SqlVarbinary expectedChecksum(Type type, Block block) {
        long result = 0L;
        for (int i = 0; i < block.getPositionCount(); ++i) {
            if (block.isNull(i)) {
                result += -7046029288634856825L;
                continue;
            }
            result += type.hash(block, i) * -7046029288634856825L;
        }
        return new SqlVarbinary(Slices.wrappedLongArray((long[])new long[]{result}).getBytes());
    }
}

