/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.AbstractTestAggregationFunction;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.DoubleType;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class TestDoubleMaxAggregation
extends AbstractTestAggregationFunction {
    @Override
    public Block[] getSequenceBlocks(int start, int length) {
        BlockBuilder blockBuilder = DoubleType.DOUBLE.createBlockBuilder(null, length);
        for (int i = start; i < start + length; ++i) {
            DoubleType.DOUBLE.writeDouble(blockBuilder, (double)i);
        }
        return new Block[]{blockBuilder.build()};
    }

    @Override
    public Number getExpectedValue(int start, int length) {
        if (length == 0) {
            return null;
        }
        return (double)(start + length - 1);
    }

    @Override
    protected String getFunctionName() {
        return "max";
    }

    @Override
    protected List<String> getFunctionParameterTypes() {
        return ImmutableList.of((Object)"double");
    }
}

