/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.AbstractTestAggregationFunction;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.type.IntervalDayTimeType;
import com.facebook.presto.type.SqlIntervalDayTime;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class TestIntervalDayToSecondAverageAggregation
extends AbstractTestAggregationFunction {
    @Override
    public Block[] getSequenceBlocks(int start, int length) {
        BlockBuilder blockBuilder = IntervalDayTimeType.INTERVAL_DAY_TIME.createBlockBuilder(null, length);
        for (int i = start; i < start + length; ++i) {
            IntervalDayTimeType.INTERVAL_DAY_TIME.writeLong(blockBuilder, (long)(i * 250));
        }
        return new Block[]{blockBuilder.build()};
    }

    public SqlIntervalDayTime getExpectedValue(int start, int length) {
        if (length == 0) {
            return null;
        }
        double sum = 0.0;
        for (int i = start; i < start + length; ++i) {
            sum += (double)(i * 250);
        }
        return new SqlIntervalDayTime(Math.round(sum / (double)length));
    }

    @Override
    protected String getFunctionName() {
        return "avg";
    }

    @Override
    protected List<String> getFunctionParameterTypes() {
        return ImmutableList.of((Object)"interval day to second");
    }
}

