/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.AbstractTestAggregationFunction;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.type.IntervalDayTimeType;
import com.facebook.presto.type.SqlIntervalDayTime;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class TestIntervalDayToSecondSumAggregation
extends AbstractTestAggregationFunction {
    @Override
    public Block[] getSequenceBlocks(int start, int length) {
        BlockBuilder blockBuilder = IntervalDayTimeType.INTERVAL_DAY_TIME.createBlockBuilder(null, length);
        for (int i = start; i < start + length; ++i) {
            IntervalDayTimeType.INTERVAL_DAY_TIME.writeLong(blockBuilder, (long)(i * 1000));
        }
        return new Block[]{blockBuilder.build()};
    }

    public SqlIntervalDayTime getExpectedValue(int start, int length) {
        if (length == 0) {
            return null;
        }
        long sum = 0L;
        for (int i = start; i < start + length; ++i) {
            sum += (long)(i * 1000);
        }
        return new SqlIntervalDayTime(sum);
    }

    @Override
    protected String getFunctionName() {
        return "sum";
    }

    @Override
    protected List<String> getFunctionParameterTypes() {
        return ImmutableList.of((Object)"interval day to second");
    }
}

