/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.AbstractTestAggregationFunction;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.BigintType;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.commons.math3.stat.descriptive.moment.Variance;

public class TestLongVarianceAggregation
extends AbstractTestAggregationFunction {
    @Override
    public Block[] getSequenceBlocks(int start, int length) {
        BlockBuilder blockBuilder = BigintType.BIGINT.createBlockBuilder(null, length);
        for (int i = start; i < start + length; ++i) {
            BigintType.BIGINT.writeLong(blockBuilder, (long)i);
        }
        return new Block[]{blockBuilder.build()};
    }

    @Override
    public Number getExpectedValue(int start, int length) {
        if (length < 2) {
            return null;
        }
        double[] values = new double[length];
        for (int i = 0; i < length; ++i) {
            values[i] = start + i;
        }
        Variance variance = new Variance();
        return variance.evaluate(values);
    }

    @Override
    protected String getFunctionName() {
        return "variance";
    }

    @Override
    protected List<String> getFunctionParameterTypes() {
        return ImmutableList.of((Object)"bigint");
    }
}

