/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.RowPageBuilder;
import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.operator.aggregation.AggregationTestUtils;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.spi.type.ArrayType;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.MapType;
import com.facebook.presto.spi.type.RowType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.util.StructuralTestUtil;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.testng.annotations.Test;

public class TestMultimapAggAggregation {
    private static final MetadataManager metadata = MetadataManager.createTestMetadataManager();

    @Test
    public void testSingleValueMap() {
        TestMultimapAggAggregation.testMultimapAgg((Type)DoubleType.DOUBLE, ImmutableList.of((Object)1.0), (Type)VarcharType.VARCHAR, ImmutableList.of((Object)"a"));
        TestMultimapAggAggregation.testMultimapAgg((Type)VarcharType.VARCHAR, ImmutableList.of((Object)"a"), (Type)BigintType.BIGINT, ImmutableList.of((Object)1L));
    }

    @Test
    public void testMultiValueMap() {
        TestMultimapAggAggregation.testMultimapAgg((Type)DoubleType.DOUBLE, ImmutableList.of((Object)1.0, (Object)1.0, (Object)1.0), (Type)VarcharType.VARCHAR, ImmutableList.of((Object)"a", (Object)"b", (Object)"c"));
        TestMultimapAggAggregation.testMultimapAgg((Type)DoubleType.DOUBLE, ImmutableList.of((Object)1.0, (Object)1.0, (Object)2.0), (Type)VarcharType.VARCHAR, ImmutableList.of((Object)"a", (Object)"b", (Object)"c"));
    }

    @Test
    public void testOrderValueMap() {
        TestMultimapAggAggregation.testMultimapAgg((Type)VarcharType.VARCHAR, ImmutableList.of((Object)"a", (Object)"a", (Object)"a"), (Type)BigintType.BIGINT, ImmutableList.of((Object)1L, (Object)2L, (Object)3L));
        TestMultimapAggAggregation.testMultimapAgg((Type)VarcharType.VARCHAR, ImmutableList.of((Object)"a", (Object)"a", (Object)"a"), (Type)BigintType.BIGINT, ImmutableList.of((Object)2L, (Object)1L, (Object)3L));
        TestMultimapAggAggregation.testMultimapAgg((Type)VarcharType.VARCHAR, ImmutableList.of((Object)"a", (Object)"a", (Object)"a"), (Type)BigintType.BIGINT, ImmutableList.of((Object)3L, (Object)2L, (Object)1L));
    }

    @Test
    public void testDuplicateValueMap() {
        TestMultimapAggAggregation.testMultimapAgg((Type)VarcharType.VARCHAR, ImmutableList.of((Object)"a", (Object)"a", (Object)"a"), (Type)BigintType.BIGINT, ImmutableList.of((Object)1L, (Object)1L, (Object)1L));
        TestMultimapAggAggregation.testMultimapAgg((Type)VarcharType.VARCHAR, ImmutableList.of((Object)"a", (Object)"b", (Object)"a", (Object)"b", (Object)"c"), (Type)BigintType.BIGINT, ImmutableList.of((Object)1L, (Object)1L, (Object)1L, (Object)1L, (Object)1L));
    }

    @Test
    public void testNullMap() {
        TestMultimapAggAggregation.testMultimapAgg((Type)DoubleType.DOUBLE, ImmutableList.of(), (Type)VarcharType.VARCHAR, ImmutableList.of());
    }

    @Test
    public void testDoubleMapMultimap() {
        MapType mapType = StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)BigintType.BIGINT);
        ImmutableList expectedKeys = ImmutableList.of((Object)1.0, (Object)2.0, (Object)3.0);
        ImmutableList expectedValues = ImmutableList.of((Object)ImmutableMap.of((Object)"a", (Object)1L), (Object)ImmutableMap.of((Object)"b", (Object)2L, (Object)"c", (Object)3L, (Object)"d", (Object)4L), (Object)ImmutableMap.of((Object)"a", (Object)1L));
        TestMultimapAggAggregation.testMultimapAgg((Type)DoubleType.DOUBLE, expectedKeys, (Type)mapType, expectedValues);
    }

    @Test
    public void testDoubleArrayMultimap() {
        ArrayType arrayType = new ArrayType((Type)VarcharType.VARCHAR);
        ImmutableList expectedKeys = ImmutableList.of((Object)1.0, (Object)2.0, (Object)3.0);
        ImmutableList expectedValues = ImmutableList.of((Object)ImmutableList.of((Object)"a", (Object)"b"), (Object)ImmutableList.of((Object)"c"), (Object)ImmutableList.of((Object)"d", (Object)"e", (Object)"f"));
        TestMultimapAggAggregation.testMultimapAgg((Type)DoubleType.DOUBLE, expectedKeys, (Type)arrayType, expectedValues);
    }

    @Test
    public void testDoubleRowMap() {
        RowType innerRowType = RowType.from((List)ImmutableList.of((Object)RowType.field((String)"f1", (Type)BigintType.BIGINT), (Object)RowType.field((String)"f2", (Type)DoubleType.DOUBLE)));
        TestMultimapAggAggregation.testMultimapAgg((Type)DoubleType.DOUBLE, ImmutableList.of((Object)1.0, (Object)2.0, (Object)3.0), (Type)innerRowType, ImmutableList.of((Object)ImmutableList.of((Object)1L, (Object)1.0), (Object)ImmutableList.of((Object)2L, (Object)2.0), (Object)ImmutableList.of((Object)3L, (Object)3.0)));
    }

    private static <K, V> void testMultimapAgg(Type keyType, List<K> expectedKeys, Type valueType, List<V> expectedValues) {
        Preconditions.checkState((expectedKeys.size() == expectedValues.size() ? 1 : 0) != 0, (Object)"expectedKeys and expectedValues should have equal size");
        MapType mapType = StructuralTestUtil.mapType(keyType, (Type)new ArrayType(valueType));
        Signature signature = new Signature("multimap_agg", FunctionKind.AGGREGATE, mapType.getTypeSignature(), new TypeSignature[]{keyType.getTypeSignature(), valueType.getTypeSignature()});
        InternalAggregationFunction aggFunc = metadata.getFunctionRegistry().getAggregateFunctionImplementation(signature);
        HashMap map = new HashMap();
        for (int i = 0; i < expectedKeys.size(); ++i) {
            if (!map.containsKey(expectedKeys.get(i))) {
                map.put(expectedKeys.get(i), new ArrayList());
            }
            ((List)map.get(expectedKeys.get(i))).add(expectedValues.get(i));
        }
        RowPageBuilder builder = RowPageBuilder.rowPageBuilder(keyType, valueType);
        for (int i = 0; i < expectedKeys.size(); ++i) {
            builder.row(expectedKeys.get(i), expectedValues.get(i));
        }
        AggregationTestUtils.assertAggregation(aggFunc, map.isEmpty() ? null : map, builder.build());
    }
}

