/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.operator.aggregation.AbstractTestAggregationFunction;
import com.facebook.presto.operator.aggregation.AggregationTestUtils;
import com.facebook.presto.spi.block.Block;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.commons.math3.stat.correlation.PearsonsCorrelation;

public class TestRealCorrelationAggregation
extends AbstractTestAggregationFunction {
    @Override
    public Block[] getSequenceBlocks(int start, int length) {
        return new Block[]{BlockAssertions.createSequenceBlockOfReal(start, start + length), BlockAssertions.createSequenceBlockOfReal(start + 2, start + 2 + length)};
    }

    @Override
    protected String getFunctionName() {
        return "corr";
    }

    @Override
    protected List<String> getFunctionParameterTypes() {
        return ImmutableList.of((Object)"real", (Object)"real");
    }

    @Override
    public Object getExpectedValue(int start, int length) {
        if (length <= 1) {
            return null;
        }
        PearsonsCorrelation corr = new PearsonsCorrelation();
        return Float.valueOf((float)corr.correlation(AggregationTestUtils.constructDoublePrimitiveArray(start + 2, length), AggregationTestUtils.constructDoublePrimitiveArray(start, length)));
    }
}

