/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.block.BlockEncodingManager;
import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.operator.aggregation.Accumulator;
import com.facebook.presto.operator.aggregation.AccumulatorFactory;
import com.facebook.presto.operator.aggregation.AggregationTestUtils;
import com.facebook.presto.operator.aggregation.InternalAggregationFunction;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockEncoding;
import com.facebook.presto.spi.block.BlockEncodingSerde;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.MapType;
import com.facebook.presto.spi.type.RealType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.type.TypeRegistry;
import com.facebook.presto.util.StructuralTestUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestRealHistogramAggregation {
    private final AccumulatorFactory factory;
    private final Page input;

    public TestRealHistogramAggregation() {
        TypeRegistry typeRegistry = new TypeRegistry();
        FunctionRegistry functionRegistry = new FunctionRegistry((TypeManager)typeRegistry, (BlockEncodingSerde)new BlockEncodingManager((TypeManager)typeRegistry, new BlockEncoding[0]), new FeaturesConfig());
        InternalAggregationFunction function = functionRegistry.getAggregateFunctionImplementation(new Signature("numeric_histogram", FunctionKind.AGGREGATE, TypeSignature.parseTypeSignature((String)"map(real, real)"), new TypeSignature[]{TypeSignature.parseTypeSignature((String)"bigint"), TypeSignature.parseTypeSignature((String)"real"), TypeSignature.parseTypeSignature((String)"double")}));
        this.factory = function.bind((List)ImmutableList.of((Object)0, (Object)1, (Object)2), Optional.empty());
        this.input = TestRealHistogramAggregation.makeInput(10);
    }

    @Test
    public void test() {
        Accumulator singleStep = this.factory.createAccumulator();
        singleStep.addInput(this.input);
        Block expected = AggregationTestUtils.getFinalBlock(singleStep);
        Accumulator partialStep = this.factory.createAccumulator();
        partialStep.addInput(this.input);
        Block partialBlock = AggregationTestUtils.getIntermediateBlock(partialStep);
        Accumulator finalStep = this.factory.createAccumulator();
        finalStep.addIntermediate(partialBlock);
        Block actual = AggregationTestUtils.getFinalBlock(finalStep);
        Assert.assertEquals(TestRealHistogramAggregation.extractSingleValue(actual), TestRealHistogramAggregation.extractSingleValue(expected));
    }

    @Test
    public void testMerge() {
        Accumulator singleStep = this.factory.createAccumulator();
        singleStep.addInput(this.input);
        Block singleStepResult = AggregationTestUtils.getFinalBlock(singleStep);
        Accumulator partialStep = this.factory.createAccumulator();
        partialStep.addInput(this.input);
        Block intermediate = AggregationTestUtils.getIntermediateBlock(partialStep);
        Accumulator finalStep = this.factory.createAccumulator();
        finalStep.addIntermediate(intermediate);
        finalStep.addIntermediate(intermediate);
        Block actual = AggregationTestUtils.getFinalBlock(finalStep);
        Map expected = Maps.transformValues(TestRealHistogramAggregation.extractSingleValue(singleStepResult), value -> Float.valueOf(value.floatValue() * 2.0f));
        Assert.assertEquals(TestRealHistogramAggregation.extractSingleValue(actual), (Map)expected);
    }

    @Test
    public void testNull() {
        Accumulator accumulator = this.factory.createAccumulator();
        Block result = AggregationTestUtils.getFinalBlock(accumulator);
        Assert.assertTrue((result.getPositionCount() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)result.isNull(0));
    }

    @Test(expectedExceptions={PrestoException.class})
    public void testBadNumberOfBuckets() {
        Accumulator singleStep = this.factory.createAccumulator();
        singleStep.addInput(TestRealHistogramAggregation.makeInput(0));
        AggregationTestUtils.getFinalBlock(singleStep);
    }

    private static Map<Float, Float> extractSingleValue(Block block) {
        MapType mapType = StructuralTestUtil.mapType((Type)RealType.REAL, (Type)RealType.REAL);
        return (Map)mapType.getObjectValue(null, block, 0);
    }

    private static Page makeInput(int numberOfBuckets) {
        PageBuilder builder = new PageBuilder((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)RealType.REAL, (Object)DoubleType.DOUBLE));
        for (int i = 0; i < 100; ++i) {
            builder.declarePosition();
            BigintType.BIGINT.writeLong(builder.getBlockBuilder(0), (long)numberOfBuckets);
            RealType.REAL.writeLong(builder.getBlockBuilder(1), (long)i);
            DoubleType.DOUBLE.writeDouble(builder.getBlockBuilder(2), 1.0);
        }
        return builder.build();
    }
}

