/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.AbstractTestDecimalAverageAggregation;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.DecimalType;
import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import java.util.List;

public class TestShortDecimalAverageAggregation
extends AbstractTestDecimalAverageAggregation {
    private static final DecimalType SHORT_DECIMAL_TYPE = DecimalType.createDecimalType((int)17);

    @Override
    protected DecimalType getDecimalType() {
        return SHORT_DECIMAL_TYPE;
    }

    @Override
    protected void writeDecimalToBlock(BigDecimal decimal, BlockBuilder blockBuilder) {
        SHORT_DECIMAL_TYPE.writeLong(blockBuilder, decimal.unscaledValue().longValue());
    }

    @Override
    protected List<String> getFunctionParameterTypes() {
        return ImmutableList.of((Object)"decimal(16,2)");
    }
}

