/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.operator.aggregation.AbstractTestAggregationFunction;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.DecimalType;
import com.facebook.presto.spi.type.SqlDecimal;
import com.google.common.collect.ImmutableList;
import java.util.List;

public class TestShortDecimalMaxAggregation
extends AbstractTestAggregationFunction {
    public static final DecimalType SHORT_DECIMAL = DecimalType.createDecimalType((int)10, (int)5);

    @Override
    public Block[] getSequenceBlocks(int start, int length) {
        BlockBuilder blockBuilder = SHORT_DECIMAL.createBlockBuilder(null, length);
        for (int i = start; i < start + length; ++i) {
            SHORT_DECIMAL.writeLong(blockBuilder, (long)i);
        }
        return new Block[]{blockBuilder.build()};
    }

    public SqlDecimal getExpectedValue(int start, int length) {
        if (length == 0) {
            return null;
        }
        return SqlDecimal.of((long)(start + length - 1), (int)10, (int)5);
    }

    @Override
    protected String getFunctionName() {
        return "max";
    }

    @Override
    protected List<String> getFunctionParameterTypes() {
        return ImmutableList.of((Object)SHORT_DECIMAL.getTypeSignature().toString());
    }
}

