/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.array.BlockBigArray;
import com.facebook.presto.array.BooleanBigArray;
import com.facebook.presto.array.ByteBigArray;
import com.facebook.presto.array.DoubleBigArray;
import com.facebook.presto.array.IntBigArray;
import com.facebook.presto.array.LongBigArray;
import com.facebook.presto.array.ReferenceCountMap;
import com.facebook.presto.array.SliceBigArray;
import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.operator.aggregation.state.LongState;
import com.facebook.presto.operator.aggregation.state.NullableLongState;
import com.facebook.presto.operator.aggregation.state.StateCompiler;
import com.facebook.presto.operator.aggregation.state.VarianceState;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.function.AccumulatorState;
import com.facebook.presto.spi.function.AccumulatorStateFactory;
import com.facebook.presto.spi.function.AccumulatorStateSerializer;
import com.facebook.presto.spi.function.GroupedAccumulatorState;
import com.facebook.presto.spi.type.ArrayType;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.MapType;
import com.facebook.presto.spi.type.RowType;
import com.facebook.presto.spi.type.TinyintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.util.Reflection;
import com.facebook.presto.util.StructuralTestUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.bytecode.DynamicClassLoader;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import org.openjdk.jol.info.ClassLayout;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestStateCompiler {
    @Test
    public void testPrimitiveNullableLongSerialization() {
        AccumulatorStateFactory factory = StateCompiler.generateStateFactory(NullableLongState.class);
        AccumulatorStateSerializer serializer = StateCompiler.generateStateSerializer(NullableLongState.class);
        NullableLongState state = (NullableLongState)factory.createSingleState();
        NullableLongState deserializedState = (NullableLongState)factory.createSingleState();
        state.setLong(2L);
        state.setNull(false);
        BlockBuilder builder = BigintType.BIGINT.createBlockBuilder(null, 2);
        serializer.serialize((Object)state, builder);
        state.setNull(true);
        serializer.serialize((Object)state, builder);
        Block block = builder.build();
        Assert.assertEquals((boolean)block.isNull(0), (boolean)false);
        Assert.assertEquals((long)BigintType.BIGINT.getLong(block, 0), (long)state.getLong());
        serializer.deserialize(block, 0, (Object)deserializedState);
        Assert.assertEquals((long)deserializedState.getLong(), (long)state.getLong());
        Assert.assertEquals((boolean)block.isNull(1), (boolean)true);
    }

    @Test
    public void testPrimitiveLongSerialization() {
        AccumulatorStateFactory factory = StateCompiler.generateStateFactory(LongState.class);
        AccumulatorStateSerializer serializer = StateCompiler.generateStateSerializer(LongState.class);
        LongState state = (LongState)factory.createSingleState();
        LongState deserializedState = (LongState)factory.createSingleState();
        state.setLong(2L);
        BlockBuilder builder = BigintType.BIGINT.createBlockBuilder(null, 1);
        serializer.serialize((Object)state, builder);
        Block block = builder.build();
        Assert.assertEquals((long)BigintType.BIGINT.getLong(block, 0), (long)state.getLong());
        serializer.deserialize(block, 0, (Object)deserializedState);
        Assert.assertEquals((long)deserializedState.getLong(), (long)state.getLong());
    }

    @Test
    public void testGetSerializedType() {
        AccumulatorStateSerializer serializer = StateCompiler.generateStateSerializer(LongState.class);
        Assert.assertEquals((Object)serializer.getSerializedType(), (Object)BigintType.BIGINT);
    }

    @Test
    public void testPrimitiveBooleanSerialization() {
        AccumulatorStateFactory factory = StateCompiler.generateStateFactory(BooleanState.class);
        AccumulatorStateSerializer serializer = StateCompiler.generateStateSerializer(BooleanState.class);
        BooleanState state = (BooleanState)factory.createSingleState();
        BooleanState deserializedState = (BooleanState)factory.createSingleState();
        state.setBoolean(true);
        BlockBuilder builder = BooleanType.BOOLEAN.createBlockBuilder(null, 1);
        serializer.serialize((Object)state, builder);
        Block block = builder.build();
        serializer.deserialize(block, 0, (Object)deserializedState);
        Assert.assertEquals((boolean)deserializedState.isBoolean(), (boolean)state.isBoolean());
    }

    @Test
    public void testPrimitiveByteSerialization() {
        AccumulatorStateFactory factory = StateCompiler.generateStateFactory(ByteState.class);
        AccumulatorStateSerializer serializer = StateCompiler.generateStateSerializer(ByteState.class);
        ByteState state = (ByteState)factory.createSingleState();
        ByteState deserializedState = (ByteState)factory.createSingleState();
        state.setByte((byte)3);
        BlockBuilder builder = TinyintType.TINYINT.createBlockBuilder(null, 1);
        serializer.serialize((Object)state, builder);
        Block block = builder.build();
        serializer.deserialize(block, 0, (Object)deserializedState);
        Assert.assertEquals((byte)deserializedState.getByte(), (byte)state.getByte());
    }

    @Test
    public void testNonPrimitiveSerialization() {
        AccumulatorStateFactory factory = StateCompiler.generateStateFactory(SliceState.class);
        AccumulatorStateSerializer serializer = StateCompiler.generateStateSerializer(SliceState.class);
        SliceState state = (SliceState)factory.createSingleState();
        SliceState deserializedState = (SliceState)factory.createSingleState();
        state.setSlice(null);
        BlockBuilder nullBlockBuilder = VarcharType.VARCHAR.createBlockBuilder(null, 1);
        serializer.serialize((Object)state, nullBlockBuilder);
        Block nullBlock = nullBlockBuilder.build();
        serializer.deserialize(nullBlock, 0, (Object)deserializedState);
        Assert.assertEquals((Object)deserializedState.getSlice(), (Object)state.getSlice());
        state.setSlice(Slices.utf8Slice((String)"test"));
        BlockBuilder builder = VarcharType.VARCHAR.createBlockBuilder(null, 1);
        serializer.serialize((Object)state, builder);
        Block block = builder.build();
        serializer.deserialize(block, 0, (Object)deserializedState);
        Assert.assertEquals((Object)deserializedState.getSlice(), (Object)state.getSlice());
    }

    @Test
    public void testVarianceStateSerialization() {
        AccumulatorStateFactory factory = StateCompiler.generateStateFactory(VarianceState.class);
        AccumulatorStateSerializer serializer = StateCompiler.generateStateSerializer(VarianceState.class);
        VarianceState singleState = (VarianceState)factory.createSingleState();
        VarianceState deserializedState = (VarianceState)factory.createSingleState();
        singleState.setMean(1.0);
        singleState.setCount(2L);
        singleState.setM2(3.0);
        BlockBuilder builder = RowType.anonymous((List)ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE)).createBlockBuilder(null, 1);
        serializer.serialize((Object)singleState, builder);
        Block block = builder.build();
        serializer.deserialize(block, 0, (Object)deserializedState);
        Assert.assertEquals((long)deserializedState.getCount(), (long)singleState.getCount());
        Assert.assertEquals((Object)deserializedState.getMean(), (Object)singleState.getMean());
        Assert.assertEquals((Object)deserializedState.getM2(), (Object)singleState.getM2());
    }

    @Test
    public void testComplexSerialization() {
        ArrayType arrayType = new ArrayType((Type)BigintType.BIGINT);
        MapType mapType = StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)VarcharType.VARCHAR);
        ImmutableMap fieldMap = ImmutableMap.of((Object)"Block", (Object)arrayType, (Object)"AnotherBlock", (Object)mapType);
        AccumulatorStateFactory factory = StateCompiler.generateStateFactory(TestComplexState.class, (Map)fieldMap, (DynamicClassLoader)new DynamicClassLoader(TestComplexState.class.getClassLoader()));
        AccumulatorStateSerializer serializer = StateCompiler.generateStateSerializer(TestComplexState.class, (Map)fieldMap, (DynamicClassLoader)new DynamicClassLoader(TestComplexState.class.getClassLoader()));
        TestComplexState singleState = (TestComplexState)factory.createSingleState();
        TestComplexState deserializedState = (TestComplexState)factory.createSingleState();
        singleState.setBoolean(true);
        singleState.setLong(1L);
        singleState.setDouble(2.0);
        singleState.setByte((byte)3);
        singleState.setInt(4);
        singleState.setSlice(Slices.utf8Slice((String)"test"));
        singleState.setAnotherSlice(Slices.wrappedDoubleArray((double[])new double[]{1.0, 2.0, 3.0}));
        singleState.setYetAnotherSlice(null);
        Block array = BlockAssertions.createLongsBlock(45);
        singleState.setBlock(array);
        singleState.setAnotherBlock(StructuralTestUtil.mapBlockOf((Type)BigintType.BIGINT, (Type)VarcharType.VARCHAR, ImmutableMap.of((Object)123L, (Object)"testBlock")));
        BlockBuilder builder = RowType.anonymous((List)ImmutableList.of((Object)BooleanType.BOOLEAN, (Object)TinyintType.TINYINT, (Object)DoubleType.DOUBLE, (Object)IntegerType.INTEGER, (Object)BigintType.BIGINT, (Object)mapType, (Object)VarbinaryType.VARBINARY, (Object)arrayType, (Object)VarbinaryType.VARBINARY, (Object)VarbinaryType.VARBINARY)).createBlockBuilder(null, 1);
        serializer.serialize((Object)singleState, builder);
        Block block = builder.build();
        serializer.deserialize(block, 0, (Object)deserializedState);
        Assert.assertEquals((boolean)deserializedState.getBoolean(), (boolean)singleState.getBoolean());
        Assert.assertEquals((long)deserializedState.getLong(), (long)singleState.getLong());
        Assert.assertEquals((Object)deserializedState.getDouble(), (Object)singleState.getDouble());
        Assert.assertEquals((byte)deserializedState.getByte(), (byte)singleState.getByte());
        Assert.assertEquals((int)deserializedState.getInt(), (int)singleState.getInt());
        Assert.assertEquals((Object)deserializedState.getSlice(), (Object)singleState.getSlice());
        Assert.assertEquals((Object)deserializedState.getAnotherSlice(), (Object)singleState.getAnotherSlice());
        Assert.assertEquals((Object)deserializedState.getYetAnotherSlice(), (Object)singleState.getYetAnotherSlice());
        Assert.assertEquals((long)deserializedState.getBlock().getLong(0, 0), (long)singleState.getBlock().getLong(0, 0));
        Assert.assertEquals((long)deserializedState.getAnotherBlock().getLong(0, 0), (long)singleState.getAnotherBlock().getLong(0, 0));
        Assert.assertEquals((Object)deserializedState.getAnotherBlock().getSlice(1, 0, 9), (Object)singleState.getAnotherBlock().getSlice(1, 0, 9));
    }

    private long getComplexStateRetainedSize(TestComplexState state) {
        long retainedSize = ClassLayout.parseClass(state.getClass()).instanceSize();
        Field[] fields = state.getClass().getDeclaredFields();
        try {
            for (Field field : fields) {
                Class<?> type = field.getType();
                field.setAccessible(true);
                if (type != BlockBigArray.class && type != BooleanBigArray.class && type != SliceBigArray.class && type != ByteBigArray.class && type != DoubleBigArray.class && type != LongBigArray.class && type != IntBigArray.class) continue;
                MethodHandle sizeOf = Reflection.methodHandle(type, (String)"sizeOf", (Class[])new Class[0]);
                retainedSize += ((Long)sizeOf.invokeWithArguments(field.get(state))).longValue();
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        return retainedSize;
    }

    private static long getReferenceCountMapOverhead(TestComplexState state) {
        long overhead = 0L;
        Field[] stateFields = state.getClass().getDeclaredFields();
        try {
            for (Field stateField : stateFields) {
                Field[] bigArrayFields;
                if (stateField.getType() != BlockBigArray.class && stateField.getType() != SliceBigArray.class) continue;
                stateField.setAccessible(true);
                for (Field bigArrayField : bigArrayFields = stateField.getType().getDeclaredFields()) {
                    if (bigArrayField.getType() != ReferenceCountMap.class) continue;
                    bigArrayField.setAccessible(true);
                    MethodHandle sizeOf = Reflection.methodHandle(bigArrayField.getType(), (String)"sizeOf", (Class[])new Class[0]);
                    overhead += ((Long)sizeOf.invokeWithArguments(bigArrayField.get(stateField.get(state)))).longValue();
                }
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        return overhead;
    }

    @Test
    public void testComplexStateEstimatedSize() {
        Block map;
        BlockBuilder singleMapBlockWriter;
        BlockBuilder mapBlockBuilder;
        Block array;
        Slice slice;
        long retainedSize;
        int i;
        ImmutableMap fieldMap = ImmutableMap.of((Object)"Block", (Object)new ArrayType((Type)BigintType.BIGINT), (Object)"AnotherBlock", (Object)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)VarcharType.VARCHAR));
        AccumulatorStateFactory factory = StateCompiler.generateStateFactory(TestComplexState.class, (Map)fieldMap, (DynamicClassLoader)new DynamicClassLoader(TestComplexState.class.getClassLoader()));
        TestComplexState groupedState = (TestComplexState)factory.createGroupedState();
        long initialRetainedSize = this.getComplexStateRetainedSize(groupedState);
        Assert.assertEquals((long)groupedState.getEstimatedSize(), (long)initialRetainedSize);
        initialRetainedSize -= TestStateCompiler.getReferenceCountMapOverhead(groupedState);
        for (i = 0; i < 1000; ++i) {
            retainedSize = 0L;
            ((GroupedAccumulatorState)groupedState).setGroupId((long)i);
            groupedState.setBoolean(true);
            groupedState.setLong(1L);
            groupedState.setDouble(2.0);
            groupedState.setByte((byte)3);
            groupedState.setInt(4);
            slice = Slices.utf8Slice((String)"test");
            retainedSize += slice.getRetainedSize();
            groupedState.setSlice(slice);
            slice = Slices.wrappedDoubleArray((double[])new double[]{1.0, 2.0, 3.0});
            retainedSize += slice.getRetainedSize();
            groupedState.setAnotherSlice(slice);
            groupedState.setYetAnotherSlice(null);
            array = BlockAssertions.createLongsBlock(45);
            retainedSize += array.getRetainedSizeInBytes();
            groupedState.setBlock(array);
            mapBlockBuilder = StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)VarcharType.VARCHAR).createBlockBuilder(null, 1);
            singleMapBlockWriter = mapBlockBuilder.beginBlockEntry();
            BigintType.BIGINT.writeLong(singleMapBlockWriter, 123L);
            VarcharType.VARCHAR.writeSlice(singleMapBlockWriter, Slices.utf8Slice((String)"testBlock"));
            mapBlockBuilder.closeEntry();
            map = mapBlockBuilder.build();
            groupedState.setAnotherBlock(map);
            Assert.assertEquals((long)groupedState.getEstimatedSize(), (long)(initialRetainedSize + (retainedSize += map.getRetainedSizeInBytes()) * (long)(i + 1) + TestStateCompiler.getReferenceCountMapOverhead(groupedState)));
        }
        for (i = 0; i < 1000; ++i) {
            retainedSize = 0L;
            ((GroupedAccumulatorState)groupedState).setGroupId((long)i);
            groupedState.setBoolean(true);
            groupedState.setLong(1L);
            groupedState.setDouble(2.0);
            groupedState.setByte((byte)3);
            groupedState.setInt(4);
            slice = Slices.utf8Slice((String)"test");
            retainedSize += slice.getRetainedSize();
            groupedState.setSlice(slice);
            slice = Slices.wrappedDoubleArray((double[])new double[]{1.0, 2.0, 3.0});
            retainedSize += slice.getRetainedSize();
            groupedState.setAnotherSlice(slice);
            groupedState.setYetAnotherSlice(null);
            array = BlockAssertions.createLongsBlock(45);
            retainedSize += array.getRetainedSizeInBytes();
            groupedState.setBlock(array);
            mapBlockBuilder = StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)VarcharType.VARCHAR).createBlockBuilder(null, 1);
            singleMapBlockWriter = mapBlockBuilder.beginBlockEntry();
            BigintType.BIGINT.writeLong(singleMapBlockWriter, 123L);
            VarcharType.VARCHAR.writeSlice(singleMapBlockWriter, Slices.utf8Slice((String)"testBlock"));
            mapBlockBuilder.closeEntry();
            map = mapBlockBuilder.build();
            groupedState.setAnotherBlock(map);
            Assert.assertEquals((long)groupedState.getEstimatedSize(), (long)(initialRetainedSize + (retainedSize += map.getRetainedSizeInBytes()) * 1000L + TestStateCompiler.getReferenceCountMapOverhead(groupedState)));
        }
    }

    public static interface SliceState
    extends AccumulatorState {
        public Slice getSlice();

        public void setSlice(Slice var1);
    }

    public static interface ByteState
    extends AccumulatorState {
        public byte getByte();

        public void setByte(byte var1);
    }

    public static interface BooleanState
    extends AccumulatorState {
        public boolean isBoolean();

        public void setBoolean(boolean var1);
    }

    public static interface TestComplexState
    extends AccumulatorState {
        public double getDouble();

        public void setDouble(double var1);

        public boolean getBoolean();

        public void setBoolean(boolean var1);

        public long getLong();

        public void setLong(long var1);

        public byte getByte();

        public void setByte(byte var1);

        public int getInt();

        public void setInt(int var1);

        public Slice getSlice();

        public void setSlice(Slice var1);

        public Slice getAnotherSlice();

        public void setAnotherSlice(Slice var1);

        public Slice getYetAnotherSlice();

        public void setYetAnotherSlice(Slice var1);

        public Block getBlock();

        public void setBlock(Block var1);

        public Block getAnotherBlock();

        public void setAnotherBlock(Block var1);
    }
}

