/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation;

import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.operator.aggregation.TypedSet;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestTypedSet {
    private static final String FUNCTION_NAME = "typed_set_test";

    @Test
    public void testConstructor() {
        for (int i = -2; i <= -1; ++i) {
            try {
                new TypedSet((Type)BigintType.BIGINT, i, FUNCTION_NAME);
                Assert.fail((String)"Should throw exception if expectedSize < 0");
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        try {
            new TypedSet(null, 1, FUNCTION_NAME);
            Assert.fail((String)"Should throw exception if type is null");
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testGetElementPosition() {
        int elementCount = 100;
        TypedSet typedSet = new TypedSet((Type)BigintType.BIGINT, elementCount, FUNCTION_NAME);
        BlockBuilder blockBuilder = BigintType.BIGINT.createFixedSizeBlockBuilder(elementCount);
        for (int i = 0; i < elementCount; ++i) {
            BigintType.BIGINT.writeLong(blockBuilder, (long)i);
            typedSet.add((Block)blockBuilder, i);
        }
        for (int j = 0; j < blockBuilder.getPositionCount(); ++j) {
            Assert.assertEquals((int)typedSet.positionOf((Block)blockBuilder, j), (int)j);
        }
    }

    @Test
    public void testGetElementPositionRandom() {
        BlockBuilder keys = VarcharType.VARCHAR.createBlockBuilder(null, 5);
        VarcharType.VARCHAR.writeSlice(keys, Slices.utf8Slice((String)"hello"));
        VarcharType.VARCHAR.writeSlice(keys, Slices.utf8Slice((String)"bye"));
        VarcharType.VARCHAR.writeSlice(keys, Slices.utf8Slice((String)"abc"));
        TypedSet set = new TypedSet((Type)VarcharType.VARCHAR, keys.getPositionCount(), FUNCTION_NAME);
        for (int i = 0; i < keys.getPositionCount(); ++i) {
            set.add((Block)keys, i);
        }
        BlockBuilder values = VarcharType.VARCHAR.createBlockBuilder(null, 5);
        VarcharType.VARCHAR.writeSlice(values, Slices.utf8Slice((String)"bye"));
        VarcharType.VARCHAR.writeSlice(values, Slices.utf8Slice((String)"abc"));
        VarcharType.VARCHAR.writeSlice(values, Slices.utf8Slice((String)"hello"));
        VarcharType.VARCHAR.writeSlice(values, Slices.utf8Slice((String)"bad"));
        Assert.assertEquals((int)set.positionOf((Block)values, 2), (int)0);
        Assert.assertEquals((int)set.positionOf((Block)values, 1), (int)2);
        Assert.assertEquals((int)set.positionOf((Block)values, 0), (int)1);
        Assert.assertFalse((boolean)set.contains((Block)values, 3));
    }

    @Test
    public void testBigintSimpleTypedSet() {
        ImmutableList expectedSetSizes = ImmutableList.of((Object)1, (Object)10, (Object)100, (Object)1000);
        ImmutableList longBlocks = ImmutableList.of((Object)BlockAssertions.createEmptyLongsBlock(), (Object)BlockAssertions.createLongsBlock(1L), (Object)BlockAssertions.createLongsBlock(1L, 2L, 3L), (Object)BlockAssertions.createLongsBlock(1L, 2L, 3L, 1L, 2L, 3L), (Object)BlockAssertions.createLongsBlock(1L, null, 3L), (Object)BlockAssertions.createLongsBlock(null, null, null), (Object)BlockAssertions.createLongSequenceBlock(0, 100), (Object)BlockAssertions.createLongSequenceBlock(-100, 100), (Object)BlockAssertions.createLongsBlock(Collections.nCopies(1, null)), (Object)BlockAssertions.createLongsBlock(Collections.nCopies(100, null)), (Object)BlockAssertions.createLongsBlock(Collections.nCopies((Integer)expectedSetSizes.get(expectedSetSizes.size() - 1) * 2, null)), (Object)BlockAssertions.createLongsBlock(Collections.nCopies((Integer)expectedSetSizes.get(expectedSetSizes.size() - 1) * 2, 0L)), (Object[])new Block[0]);
        Iterator iterator = expectedSetSizes.iterator();
        while (iterator.hasNext()) {
            int expectedSetSize = (Integer)iterator.next();
            for (Block block : longBlocks) {
                TestTypedSet.testBigint(block, expectedSetSize);
            }
        }
    }

    @Test
    public void testMemoryExceeded() {
        try {
            TypedSet typedSet = new TypedSet((Type)BigintType.BIGINT, 10, FUNCTION_NAME);
            int i = 0;
            while ((long)i <= TypedSet.FOUR_MEGABYTES + 1L) {
                Block block = BlockAssertions.createLongsBlock(Collections.nCopies(1, Long.valueOf(i)));
                typedSet.add(block, 0);
                ++i;
            }
            Assert.fail((String)"expected exception");
        }
        catch (PrestoException e) {
            Assert.assertEquals((Object)e.getErrorCode(), (Object)StandardErrorCode.EXCEEDED_FUNCTION_MEMORY_LIMIT.toErrorCode());
        }
    }

    private static void testBigint(Block longBlock, int expectedSetSize) {
        TypedSet typedSet = new TypedSet((Type)BigintType.BIGINT, expectedSetSize, FUNCTION_NAME);
        HashSet<Long> set = new HashSet<Long>();
        for (int blockPosition = 0; blockPosition < longBlock.getPositionCount(); ++blockPosition) {
            long number = BigintType.BIGINT.getLong(longBlock, blockPosition);
            Assert.assertEquals((boolean)typedSet.contains(longBlock, blockPosition), (boolean)set.contains(number));
            Assert.assertEquals((int)typedSet.size(), (int)set.size());
            set.add(number);
            typedSet.add(longBlock, blockPosition);
            Assert.assertEquals((boolean)typedSet.contains(longBlock, blockPosition), (boolean)set.contains(number));
            Assert.assertEquals((int)typedSet.size(), (int)set.size());
        }
    }
}

