/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.histogram;

import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.operator.aggregation.histogram.ValueStore;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.type.TypeUtils;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestValueStore {
    private ValueStore valueStore;
    private Block block;
    private VarcharType type;
    private ValueStore valueStoreSmall;

    @BeforeMethod(alwaysRun=true)
    public void setUp() throws Exception {
        this.type = VarcharType.createVarcharType((int)100);
        BlockBuilder blockBuilder = this.type.createBlockBuilder(null, 100, 10);
        this.valueStore = new ValueStore(100, blockBuilder);
        this.valueStoreSmall = new ValueStore(1, blockBuilder);
        this.block = BlockAssertions.createStringsBlock("a", "b", "c", "d");
    }

    @Test
    public void testUniqueness() {
        Assert.assertEquals((int)this.valueStore.addAndGetPosition((Type)this.type, this.block, 0, TypeUtils.hashPosition((Type)this.type, (Block)this.block, (int)0)), (int)0);
        Assert.assertEquals((int)this.valueStore.addAndGetPosition((Type)this.type, this.block, 1, TypeUtils.hashPosition((Type)this.type, (Block)this.block, (int)1)), (int)1);
        Assert.assertEquals((int)this.valueStore.addAndGetPosition((Type)this.type, this.block, 2, TypeUtils.hashPosition((Type)this.type, (Block)this.block, (int)2)), (int)2);
        Assert.assertEquals((int)this.valueStore.addAndGetPosition((Type)this.type, this.block, 1, TypeUtils.hashPosition((Type)this.type, (Block)this.block, (int)1)), (int)1);
        Assert.assertEquals((int)this.valueStore.addAndGetPosition((Type)this.type, this.block, 3, TypeUtils.hashPosition((Type)this.type, (Block)this.block, (int)1)), (int)3);
    }

    @Test
    public void testTriggerRehash() {
        long hash0 = TypeUtils.hashPosition((Type)this.type, (Block)this.block, (int)0);
        long hash1 = TypeUtils.hashPosition((Type)this.type, (Block)this.block, (int)1);
        long hash2 = TypeUtils.hashPosition((Type)this.type, (Block)this.block, (int)2);
        Assert.assertEquals((int)this.valueStoreSmall.addAndGetPosition((Type)this.type, this.block, 0, hash0), (int)0);
        Assert.assertEquals((int)this.valueStoreSmall.addAndGetPosition((Type)this.type, this.block, 1, hash1), (int)1);
        Assert.assertEquals((int)this.valueStoreSmall.addAndGetPosition((Type)this.type, this.block, 2, hash2), (int)2);
        Assert.assertTrue((this.valueStoreSmall.getRehashCount() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((int)this.valueStoreSmall.addAndGetPosition((Type)this.type, this.block, 0, hash0), (int)0);
        Assert.assertEquals((int)this.valueStoreSmall.addAndGetPosition((Type)this.type, this.block, 1, hash1), (int)1);
        Assert.assertEquals((int)this.valueStoreSmall.addAndGetPosition((Type)this.type, this.block, 2, hash2), (int)2);
    }
}

