/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.exchange;

import com.facebook.presto.SequencePageBuilder;
import com.facebook.presto.execution.Lifespan;
import com.facebook.presto.operator.HashGenerator;
import com.facebook.presto.operator.InterpretedHashGenerator;
import com.facebook.presto.operator.PageAssertions;
import com.facebook.presto.operator.PipelineExecutionStrategy;
import com.facebook.presto.operator.exchange.LocalExchange;
import com.facebook.presto.operator.exchange.LocalExchangeBufferInfo;
import com.facebook.presto.operator.exchange.LocalExchangeSink;
import com.facebook.presto.operator.exchange.LocalExchangeSource;
import com.facebook.presto.operator.exchange.LocalPartitionGenerator;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.SystemPartitioningHandle;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.testing.Assertions;
import io.airlift.units.DataSize;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestLocalExchange {
    private static final List<Type> TYPES = ImmutableList.of((Object)BigintType.BIGINT);
    private static final DataSize RETAINED_PAGE_SIZE = new DataSize((double)TestLocalExchange.createPage(42).getRetainedSizeInBytes(), DataSize.Unit.BYTE);
    private static final DataSize LOCAL_EXCHANGE_MAX_BUFFERED_BYTES = new DataSize(32.0, DataSize.Unit.MEGABYTE);

    @DataProvider
    public static Object[][] executionStrategy() {
        return new Object[][]{{PipelineExecutionStrategy.UNGROUPED_EXECUTION}, {PipelineExecutionStrategy.GROUPED_EXECUTION}};
    }

    @Test(dataProvider="executionStrategy")
    public void testGatherSingleWriter(PipelineExecutionStrategy executionStrategy) {
        LocalExchange.LocalExchangeFactory localExchangeFactory = new LocalExchange.LocalExchangeFactory(SystemPartitioningHandle.SINGLE_DISTRIBUTION, 8, TYPES, (List)ImmutableList.of(), Optional.empty(), executionStrategy, new DataSize((double)TestLocalExchange.retainedSizeOfPages(99), DataSize.Unit.BYTE));
        LocalExchange.LocalExchangeSinkFactoryId localExchangeSinkFactoryId = localExchangeFactory.newSinkFactoryId();
        localExchangeFactory.noMoreSinkFactories();
        this.run(localExchangeFactory, executionStrategy, exchange -> {
            Assert.assertEquals((int)exchange.getBufferCount(), (int)1);
            TestLocalExchange.assertExchangeTotalBufferedBytes(exchange, 0);
            LocalExchange.LocalExchangeSinkFactory sinkFactory = exchange.getSinkFactory(localExchangeSinkFactoryId);
            LocalExchangeSource source = exchange.getSource(0);
            TestLocalExchange.assertSource(source, 0);
            LocalExchangeSink sink = sinkFactory.createSink();
            sinkFactory.close();
            sinkFactory.noMoreSinkFactories();
            TestLocalExchange.assertSinkCanWrite(sink);
            TestLocalExchange.assertSource(source, 0);
            ListenableFuture readFuture = source.waitForReading();
            Assert.assertFalse((boolean)readFuture.isDone());
            sink.addPage(TestLocalExchange.createPage(0));
            Assert.assertTrue((boolean)readFuture.isDone());
            TestLocalExchange.assertExchangeTotalBufferedBytes(exchange, 1);
            TestLocalExchange.assertSource(source, 1);
            sink.addPage(TestLocalExchange.createPage(1));
            TestLocalExchange.assertSource(source, 2);
            TestLocalExchange.assertExchangeTotalBufferedBytes(exchange, 2);
            TestLocalExchange.assertRemovePage(source, TestLocalExchange.createPage(0));
            TestLocalExchange.assertSource(source, 1);
            TestLocalExchange.assertExchangeTotalBufferedBytes(exchange, 1);
            TestLocalExchange.assertRemovePage(source, TestLocalExchange.createPage(1));
            TestLocalExchange.assertSource(source, 0);
            TestLocalExchange.assertExchangeTotalBufferedBytes(exchange, 0);
            sink.addPage(TestLocalExchange.createPage(2));
            sink.addPage(TestLocalExchange.createPage(3));
            TestLocalExchange.assertSource(source, 2);
            TestLocalExchange.assertExchangeTotalBufferedBytes(exchange, 2);
            sink.finish();
            TestLocalExchange.assertSinkFinished(sink);
            TestLocalExchange.assertSource(source, 2);
            TestLocalExchange.assertRemovePage(source, TestLocalExchange.createPage(2));
            TestLocalExchange.assertSource(source, 1);
            TestLocalExchange.assertSinkFinished(sink);
            TestLocalExchange.assertExchangeTotalBufferedBytes(exchange, 1);
            TestLocalExchange.assertRemovePage(source, TestLocalExchange.createPage(3));
            TestLocalExchange.assertSourceFinished(source);
            TestLocalExchange.assertExchangeTotalBufferedBytes(exchange, 0);
        });
    }

    @Test(dataProvider="executionStrategy")
    public void testBroadcast(PipelineExecutionStrategy executionStrategy) {
        LocalExchange.LocalExchangeFactory localExchangeFactory = new LocalExchange.LocalExchangeFactory(SystemPartitioningHandle.FIXED_BROADCAST_DISTRIBUTION, 2, TYPES, (List)ImmutableList.of(), Optional.empty(), executionStrategy, LOCAL_EXCHANGE_MAX_BUFFERED_BYTES);
        LocalExchange.LocalExchangeSinkFactoryId localExchangeSinkFactoryId = localExchangeFactory.newSinkFactoryId();
        localExchangeFactory.noMoreSinkFactories();
        this.run(localExchangeFactory, executionStrategy, exchange -> {
            Assert.assertEquals((int)exchange.getBufferCount(), (int)2);
            TestLocalExchange.assertExchangeTotalBufferedBytes(exchange, 0);
            LocalExchange.LocalExchangeSinkFactory sinkFactory = exchange.getSinkFactory(localExchangeSinkFactoryId);
            LocalExchangeSink sinkA = sinkFactory.createSink();
            TestLocalExchange.assertSinkCanWrite(sinkA);
            LocalExchangeSink sinkB = sinkFactory.createSink();
            TestLocalExchange.assertSinkCanWrite(sinkB);
            sinkFactory.close();
            sinkFactory.noMoreSinkFactories();
            LocalExchangeSource sourceA = exchange.getSource(0);
            TestLocalExchange.assertSource(sourceA, 0);
            LocalExchangeSource sourceB = exchange.getSource(1);
            TestLocalExchange.assertSource(sourceB, 0);
            sinkA.addPage(TestLocalExchange.createPage(0));
            TestLocalExchange.assertSource(sourceA, 1);
            TestLocalExchange.assertSource(sourceB, 1);
            TestLocalExchange.assertExchangeTotalBufferedBytes(exchange, 1);
            sinkA.addPage(TestLocalExchange.createPage(0));
            TestLocalExchange.assertSource(sourceA, 2);
            TestLocalExchange.assertSource(sourceB, 2);
            TestLocalExchange.assertExchangeTotalBufferedBytes(exchange, 2);
            TestLocalExchange.assertRemovePage(sourceA, TestLocalExchange.createPage(0));
            TestLocalExchange.assertSource(sourceA, 1);
            TestLocalExchange.assertSource(sourceB, 2);
            TestLocalExchange.assertExchangeTotalBufferedBytes(exchange, 2);
            TestLocalExchange.assertRemovePage(sourceA, TestLocalExchange.createPage(0));
            TestLocalExchange.assertSource(sourceA, 0);
            TestLocalExchange.assertSource(sourceB, 2);
            TestLocalExchange.assertExchangeTotalBufferedBytes(exchange, 2);
            sinkA.finish();
            TestLocalExchange.assertSinkFinished(sinkA);
            TestLocalExchange.assertExchangeTotalBufferedBytes(exchange, 2);
            sinkB.addPage(TestLocalExchange.createPage(0));
            TestLocalExchange.assertSource(sourceA, 1);
            TestLocalExchange.assertSource(sourceB, 3);
            TestLocalExchange.assertExchangeTotalBufferedBytes(exchange, 3);
            sinkB.finish();
            TestLocalExchange.assertSinkFinished(sinkB);
            TestLocalExchange.assertSource(sourceA, 1);
            TestLocalExchange.assertSource(sourceB, 3);
            TestLocalExchange.assertExchangeTotalBufferedBytes(exchange, 3);
            TestLocalExchange.assertRemovePage(sourceA, TestLocalExchange.createPage(0));
            TestLocalExchange.assertSourceFinished(sourceA);
            TestLocalExchange.assertSource(sourceB, 3);
            TestLocalExchange.assertExchangeTotalBufferedBytes(exchange, 3);
            TestLocalExchange.assertRemovePage(sourceB, TestLocalExchange.createPage(0));
            TestLocalExchange.assertRemovePage(sourceB, TestLocalExchange.createPage(0));
            TestLocalExchange.assertSourceFinished(sourceA);
            TestLocalExchange.assertSource(sourceB, 1);
            TestLocalExchange.assertExchangeTotalBufferedBytes(exchange, 1);
            TestLocalExchange.assertRemovePage(sourceB, TestLocalExchange.createPage(0));
            TestLocalExchange.assertSourceFinished(sourceA);
            TestLocalExchange.assertSourceFinished(sourceB);
            TestLocalExchange.assertExchangeTotalBufferedBytes(exchange, 0);
        });
    }

    @Test(dataProvider="executionStrategy")
    public void testRandom(PipelineExecutionStrategy executionStrategy) {
        LocalExchange.LocalExchangeFactory localExchangeFactory = new LocalExchange.LocalExchangeFactory(SystemPartitioningHandle.FIXED_ARBITRARY_DISTRIBUTION, 2, TYPES, (List)ImmutableList.of(), Optional.empty(), executionStrategy, LOCAL_EXCHANGE_MAX_BUFFERED_BYTES);
        LocalExchange.LocalExchangeSinkFactoryId localExchangeSinkFactoryId = localExchangeFactory.newSinkFactoryId();
        localExchangeFactory.noMoreSinkFactories();
        this.run(localExchangeFactory, executionStrategy, exchange -> {
            Assert.assertEquals((int)exchange.getBufferCount(), (int)2);
            TestLocalExchange.assertExchangeTotalBufferedBytes(exchange, 0);
            LocalExchange.LocalExchangeSinkFactory sinkFactory = exchange.getSinkFactory(localExchangeSinkFactoryId);
            LocalExchangeSink sink = sinkFactory.createSink();
            TestLocalExchange.assertSinkCanWrite(sink);
            sinkFactory.close();
            sinkFactory.noMoreSinkFactories();
            LocalExchangeSource sourceA = exchange.getSource(0);
            TestLocalExchange.assertSource(sourceA, 0);
            LocalExchangeSource sourceB = exchange.getSource(1);
            TestLocalExchange.assertSource(sourceB, 0);
            for (int i = 0; i < 100; ++i) {
                Page page = TestLocalExchange.createPage(0);
                sink.addPage(page);
                TestLocalExchange.assertExchangeTotalBufferedBytes(exchange, i + 1);
                LocalExchangeBufferInfo bufferInfoA = sourceA.getBufferInfo();
                LocalExchangeBufferInfo bufferInfoB = sourceB.getBufferInfo();
                Assert.assertEquals((long)(bufferInfoA.getBufferedBytes() + bufferInfoB.getBufferedBytes()), (long)TestLocalExchange.retainedSizeOfPages(i + 1));
                Assert.assertEquals((int)(bufferInfoA.getBufferedPages() + bufferInfoB.getBufferedPages()), (int)(i + 1));
            }
            Assert.assertTrue((sourceA.getBufferInfo().getBufferedPages() > 0 ? 1 : 0) != 0);
            Assert.assertTrue((sourceB.getBufferInfo().getBufferedPages() > 0 ? 1 : 0) != 0);
            TestLocalExchange.assertExchangeTotalBufferedBytes(exchange, 100);
        });
    }

    @Test(dataProvider="executionStrategy")
    public void testPassthrough(PipelineExecutionStrategy executionStrategy) {
        LocalExchange.LocalExchangeFactory localExchangeFactory = new LocalExchange.LocalExchangeFactory(SystemPartitioningHandle.FIXED_PASSTHROUGH_DISTRIBUTION, 2, TYPES, (List)ImmutableList.of(), Optional.empty(), executionStrategy, new DataSize((double)TestLocalExchange.retainedSizeOfPages(1), DataSize.Unit.BYTE));
        LocalExchange.LocalExchangeSinkFactoryId localExchangeSinkFactoryId = localExchangeFactory.newSinkFactoryId();
        localExchangeFactory.noMoreSinkFactories();
        this.run(localExchangeFactory, executionStrategy, exchange -> {
            Assert.assertEquals((int)exchange.getBufferCount(), (int)2);
            TestLocalExchange.assertExchangeTotalBufferedBytes(exchange, 0);
            LocalExchange.LocalExchangeSinkFactory sinkFactory = exchange.getSinkFactory(localExchangeSinkFactoryId);
            LocalExchangeSink sinkA = sinkFactory.createSink();
            LocalExchangeSink sinkB = sinkFactory.createSink();
            TestLocalExchange.assertSinkCanWrite(sinkA);
            TestLocalExchange.assertSinkCanWrite(sinkB);
            sinkFactory.close();
            sinkFactory.noMoreSinkFactories();
            LocalExchangeSource sourceA = exchange.getSource(0);
            TestLocalExchange.assertSource(sourceA, 0);
            LocalExchangeSource sourceB = exchange.getSource(1);
            TestLocalExchange.assertSource(sourceB, 0);
            sinkA.addPage(TestLocalExchange.createPage(0));
            TestLocalExchange.assertSource(sourceA, 1);
            TestLocalExchange.assertSource(sourceB, 0);
            TestLocalExchange.assertSinkWriteBlocked(sinkA);
            TestLocalExchange.assertSinkCanWrite(sinkB);
            sinkB.addPage(TestLocalExchange.createPage(1));
            TestLocalExchange.assertSource(sourceA, 1);
            TestLocalExchange.assertSource(sourceB, 1);
            TestLocalExchange.assertSinkWriteBlocked(sinkA);
            TestLocalExchange.assertExchangeTotalBufferedBytes(exchange, 2);
            TestLocalExchange.assertRemovePage(sourceA, TestLocalExchange.createPage(0));
            TestLocalExchange.assertSource(sourceA, 0);
            TestLocalExchange.assertSinkCanWrite(sinkA);
            TestLocalExchange.assertSinkWriteBlocked(sinkB);
            TestLocalExchange.assertExchangeTotalBufferedBytes(exchange, 1);
            sinkA.finish();
            TestLocalExchange.assertSinkFinished(sinkA);
            TestLocalExchange.assertSource(sourceB, 1);
            sourceA.finish();
            sourceB.finish();
            TestLocalExchange.assertRemovePage(sourceB, TestLocalExchange.createPage(1));
            TestLocalExchange.assertSourceFinished(sourceA);
            TestLocalExchange.assertSourceFinished(sourceB);
            TestLocalExchange.assertSinkFinished(sinkB);
            TestLocalExchange.assertExchangeTotalBufferedBytes(exchange, 0);
        });
    }

    @Test(dataProvider="executionStrategy")
    public void testPartition(PipelineExecutionStrategy executionStrategy) {
        LocalExchange.LocalExchangeFactory localExchangeFactory = new LocalExchange.LocalExchangeFactory(SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION, 2, TYPES, (List)ImmutableList.of((Object)0), Optional.empty(), executionStrategy, LOCAL_EXCHANGE_MAX_BUFFERED_BYTES);
        LocalExchange.LocalExchangeSinkFactoryId localExchangeSinkFactoryId = localExchangeFactory.newSinkFactoryId();
        localExchangeFactory.noMoreSinkFactories();
        this.run(localExchangeFactory, executionStrategy, exchange -> {
            Assert.assertEquals((int)exchange.getBufferCount(), (int)2);
            TestLocalExchange.assertExchangeTotalBufferedBytes(exchange, 0);
            LocalExchange.LocalExchangeSinkFactory sinkFactory = exchange.getSinkFactory(localExchangeSinkFactoryId);
            LocalExchangeSink sink = sinkFactory.createSink();
            TestLocalExchange.assertSinkCanWrite(sink);
            sinkFactory.close();
            sinkFactory.noMoreSinkFactories();
            LocalExchangeSource sourceA = exchange.getSource(0);
            TestLocalExchange.assertSource(sourceA, 0);
            LocalExchangeSource sourceB = exchange.getSource(1);
            TestLocalExchange.assertSource(sourceB, 0);
            sink.addPage(TestLocalExchange.createPage(0));
            TestLocalExchange.assertSource(sourceA, 1);
            TestLocalExchange.assertSource(sourceB, 1);
            Assert.assertTrue((exchange.getBufferedBytes() >= TestLocalExchange.retainedSizeOfPages(1) ? 1 : 0) != 0);
            sink.addPage(TestLocalExchange.createPage(0));
            TestLocalExchange.assertSource(sourceA, 2);
            TestLocalExchange.assertSource(sourceB, 2);
            Assert.assertTrue((exchange.getBufferedBytes() >= TestLocalExchange.retainedSizeOfPages(2) ? 1 : 0) != 0);
            TestLocalExchange.assertPartitionedRemovePage(sourceA, 0, 2);
            TestLocalExchange.assertSource(sourceA, 1);
            TestLocalExchange.assertSource(sourceB, 2);
            TestLocalExchange.assertPartitionedRemovePage(sourceA, 0, 2);
            TestLocalExchange.assertSource(sourceA, 0);
            TestLocalExchange.assertSource(sourceB, 2);
            sink.finish();
            TestLocalExchange.assertSinkFinished(sink);
            TestLocalExchange.assertSourceFinished(sourceA);
            TestLocalExchange.assertSource(sourceB, 2);
            TestLocalExchange.assertPartitionedRemovePage(sourceB, 1, 2);
            TestLocalExchange.assertSourceFinished(sourceA);
            TestLocalExchange.assertSource(sourceB, 1);
            TestLocalExchange.assertPartitionedRemovePage(sourceB, 1, 2);
            TestLocalExchange.assertSourceFinished(sourceA);
            TestLocalExchange.assertSourceFinished(sourceB);
            TestLocalExchange.assertExchangeTotalBufferedBytes(exchange, 0);
        });
    }

    @Test(dataProvider="executionStrategy")
    public void writeUnblockWhenAllReadersFinish(PipelineExecutionStrategy executionStrategy) {
        ImmutableList types = ImmutableList.of((Object)BigintType.BIGINT);
        LocalExchange.LocalExchangeFactory localExchangeFactory = new LocalExchange.LocalExchangeFactory(SystemPartitioningHandle.FIXED_BROADCAST_DISTRIBUTION, 2, (List)types, (List)ImmutableList.of(), Optional.empty(), executionStrategy, LOCAL_EXCHANGE_MAX_BUFFERED_BYTES);
        LocalExchange.LocalExchangeSinkFactoryId localExchangeSinkFactoryId = localExchangeFactory.newSinkFactoryId();
        localExchangeFactory.noMoreSinkFactories();
        this.run(localExchangeFactory, executionStrategy, exchange -> {
            Assert.assertEquals((int)exchange.getBufferCount(), (int)2);
            TestLocalExchange.assertExchangeTotalBufferedBytes(exchange, 0);
            LocalExchange.LocalExchangeSinkFactory sinkFactory = exchange.getSinkFactory(localExchangeSinkFactoryId);
            LocalExchangeSink sinkA = sinkFactory.createSink();
            TestLocalExchange.assertSinkCanWrite(sinkA);
            LocalExchangeSink sinkB = sinkFactory.createSink();
            TestLocalExchange.assertSinkCanWrite(sinkB);
            sinkFactory.close();
            sinkFactory.noMoreSinkFactories();
            LocalExchangeSource sourceA = exchange.getSource(0);
            TestLocalExchange.assertSource(sourceA, 0);
            LocalExchangeSource sourceB = exchange.getSource(1);
            TestLocalExchange.assertSource(sourceB, 0);
            sourceA.finish();
            TestLocalExchange.assertSourceFinished(sourceA);
            TestLocalExchange.assertSinkCanWrite(sinkA);
            TestLocalExchange.assertSinkCanWrite(sinkB);
            sourceB.finish();
            TestLocalExchange.assertSourceFinished(sourceB);
            TestLocalExchange.assertSinkFinished(sinkA);
            TestLocalExchange.assertSinkFinished(sinkB);
        });
    }

    @Test(dataProvider="executionStrategy")
    public void writeUnblockWhenAllReadersFinishAndPagesConsumed(PipelineExecutionStrategy executionStrategy) {
        LocalExchange.LocalExchangeFactory localExchangeFactory = new LocalExchange.LocalExchangeFactory(SystemPartitioningHandle.FIXED_BROADCAST_DISTRIBUTION, 2, TYPES, (List)ImmutableList.of(), Optional.empty(), executionStrategy, new DataSize(1.0, DataSize.Unit.BYTE));
        LocalExchange.LocalExchangeSinkFactoryId localExchangeSinkFactoryId = localExchangeFactory.newSinkFactoryId();
        localExchangeFactory.noMoreSinkFactories();
        this.run(localExchangeFactory, executionStrategy, exchange -> {
            Assert.assertEquals((int)exchange.getBufferCount(), (int)2);
            TestLocalExchange.assertExchangeTotalBufferedBytes(exchange, 0);
            LocalExchange.LocalExchangeSinkFactory sinkFactory = exchange.getSinkFactory(localExchangeSinkFactoryId);
            LocalExchangeSink sinkA = sinkFactory.createSink();
            TestLocalExchange.assertSinkCanWrite(sinkA);
            LocalExchangeSink sinkB = sinkFactory.createSink();
            TestLocalExchange.assertSinkCanWrite(sinkB);
            sinkFactory.close();
            sinkFactory.noMoreSinkFactories();
            LocalExchangeSource sourceA = exchange.getSource(0);
            TestLocalExchange.assertSource(sourceA, 0);
            LocalExchangeSource sourceB = exchange.getSource(1);
            TestLocalExchange.assertSource(sourceB, 0);
            sinkA.addPage(TestLocalExchange.createPage(0));
            ListenableFuture<?> sinkAFuture = TestLocalExchange.assertSinkWriteBlocked(sinkA);
            ListenableFuture<?> sinkBFuture = TestLocalExchange.assertSinkWriteBlocked(sinkB);
            TestLocalExchange.assertSource(sourceA, 1);
            TestLocalExchange.assertSource(sourceB, 1);
            TestLocalExchange.assertExchangeTotalBufferedBytes(exchange, 1);
            sourceA.finish();
            TestLocalExchange.assertSource(sourceA, 1);
            TestLocalExchange.assertRemovePage(sourceA, TestLocalExchange.createPage(0));
            TestLocalExchange.assertSourceFinished(sourceA);
            TestLocalExchange.assertExchangeTotalBufferedBytes(exchange, 1);
            TestLocalExchange.assertSource(sourceB, 1);
            TestLocalExchange.assertSinkWriteBlocked(sinkA);
            TestLocalExchange.assertSinkWriteBlocked(sinkB);
            sourceB.finish();
            TestLocalExchange.assertSource(sourceB, 1);
            TestLocalExchange.assertRemovePage(sourceB, TestLocalExchange.createPage(0));
            TestLocalExchange.assertSourceFinished(sourceB);
            TestLocalExchange.assertExchangeTotalBufferedBytes(exchange, 0);
            Assert.assertTrue((boolean)sinkAFuture.isDone());
            Assert.assertTrue((boolean)sinkBFuture.isDone());
            TestLocalExchange.assertSinkFinished(sinkA);
            TestLocalExchange.assertSinkFinished(sinkB);
        });
    }

    @Test
    public void testMismatchedExecutionStrategy() {
        LocalExchange.LocalExchangeFactory ungroupedLocalExchangeFactory = new LocalExchange.LocalExchangeFactory(SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION, 2, TYPES, (List)ImmutableList.of((Object)0), Optional.empty(), PipelineExecutionStrategy.UNGROUPED_EXECUTION, LOCAL_EXCHANGE_MAX_BUFFERED_BYTES);
        try {
            ungroupedLocalExchangeFactory.getLocalExchange(Lifespan.driverGroup((int)3));
            Assert.fail((String)"expected failure");
        }
        catch (IllegalArgumentException e) {
            Assertions.assertContains((String)e.getMessage(), (String)"Driver-group exchange cannot be created.");
        }
        LocalExchange.LocalExchangeFactory groupedLocalExchangeFactory = new LocalExchange.LocalExchangeFactory(SystemPartitioningHandle.FIXED_HASH_DISTRIBUTION, 2, TYPES, (List)ImmutableList.of((Object)0), Optional.empty(), PipelineExecutionStrategy.GROUPED_EXECUTION, LOCAL_EXCHANGE_MAX_BUFFERED_BYTES);
        try {
            groupedLocalExchangeFactory.getLocalExchange(Lifespan.taskWide());
            Assert.fail((String)"expected failure");
        }
        catch (IllegalArgumentException e) {
            Assertions.assertContains((String)e.getMessage(), (String)"Task-wide exchange cannot be created.");
        }
    }

    private void run(LocalExchange.LocalExchangeFactory localExchangeFactory, PipelineExecutionStrategy pipelineExecutionStrategy, Consumer<LocalExchange> test) {
        switch (pipelineExecutionStrategy) {
            case UNGROUPED_EXECUTION: {
                test.accept(localExchangeFactory.getLocalExchange(Lifespan.taskWide()));
                break;
            }
            case GROUPED_EXECUTION: {
                test.accept(localExchangeFactory.getLocalExchange(Lifespan.driverGroup((int)1)));
                test.accept(localExchangeFactory.getLocalExchange(Lifespan.driverGroup((int)12)));
                test.accept(localExchangeFactory.getLocalExchange(Lifespan.driverGroup((int)23)));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown pipelineExecutionStrategy");
            }
        }
    }

    private static void assertSource(LocalExchangeSource source, int pageCount) {
        LocalExchangeBufferInfo bufferInfo = source.getBufferInfo();
        Assert.assertEquals((int)bufferInfo.getBufferedPages(), (int)pageCount);
        Assert.assertFalse((boolean)source.isFinished());
        if (pageCount == 0) {
            Assert.assertFalse((boolean)source.waitForReading().isDone());
            Assert.assertNull((Object)source.removePage());
            Assert.assertFalse((boolean)source.waitForReading().isDone());
            Assert.assertFalse((boolean)source.isFinished());
            Assert.assertEquals((long)bufferInfo.getBufferedBytes(), (long)0L);
        } else {
            Assert.assertTrue((boolean)source.waitForReading().isDone());
            Assert.assertTrue((bufferInfo.getBufferedBytes() > 0L ? 1 : 0) != 0);
        }
    }

    private static void assertSourceFinished(LocalExchangeSource source) {
        Assert.assertTrue((boolean)source.isFinished());
        LocalExchangeBufferInfo bufferInfo = source.getBufferInfo();
        Assert.assertEquals((int)bufferInfo.getBufferedPages(), (int)0);
        Assert.assertEquals((long)bufferInfo.getBufferedBytes(), (long)0L);
        Assert.assertTrue((boolean)source.waitForReading().isDone());
        Assert.assertNull((Object)source.removePage());
        Assert.assertTrue((boolean)source.waitForReading().isDone());
        Assert.assertTrue((boolean)source.isFinished());
    }

    private static void assertRemovePage(LocalExchangeSource source, Page expectedPage) {
        Assert.assertTrue((boolean)source.waitForReading().isDone());
        Page actualPage = source.removePage();
        Assert.assertNotNull((Object)actualPage);
        Assert.assertEquals((int)actualPage.getChannelCount(), (int)expectedPage.getChannelCount());
        PageAssertions.assertPageEquals(TYPES, actualPage, expectedPage);
    }

    private static void assertPartitionedRemovePage(LocalExchangeSource source, int partition, int partitionCount) {
        Assert.assertTrue((boolean)source.waitForReading().isDone());
        Page page = source.removePage();
        Assert.assertNotNull((Object)page);
        LocalPartitionGenerator partitionGenerator = new LocalPartitionGenerator((HashGenerator)new InterpretedHashGenerator(TYPES, new int[]{0}), partitionCount);
        for (int position = 0; position < page.getPositionCount(); ++position) {
            Assert.assertEquals((int)partitionGenerator.getPartition(page, position), (int)partition);
        }
    }

    private static void assertSinkCanWrite(LocalExchangeSink sink) {
        Assert.assertFalse((boolean)sink.isFinished());
        Assert.assertTrue((boolean)sink.waitForWriting().isDone());
    }

    private static ListenableFuture<?> assertSinkWriteBlocked(LocalExchangeSink sink) {
        Assert.assertFalse((boolean)sink.isFinished());
        ListenableFuture writeFuture = sink.waitForWriting();
        Assert.assertFalse((boolean)writeFuture.isDone());
        return writeFuture;
    }

    private static void assertSinkFinished(LocalExchangeSink sink) {
        Assert.assertTrue((boolean)sink.isFinished());
        Assert.assertTrue((boolean)sink.waitForWriting().isDone());
        sink.addPage(TestLocalExchange.createPage(0));
        Assert.assertTrue((boolean)sink.isFinished());
        Assert.assertTrue((boolean)sink.waitForWriting().isDone());
    }

    private static void assertExchangeTotalBufferedBytes(LocalExchange exchange, int pageCount) {
        Assert.assertEquals((long)exchange.getBufferedBytes(), (long)TestLocalExchange.retainedSizeOfPages(pageCount));
    }

    private static Page createPage(int i) {
        return SequencePageBuilder.createSequencePage(TYPES, 100, i);
    }

    public static long retainedSizeOfPages(int count) {
        return RETAINED_PAGE_SIZE.toBytes() * (long)count;
    }
}

