/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.project;

import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.operator.DriverYieldSignal;
import com.facebook.presto.operator.Work;
import com.facebook.presto.operator.project.DictionaryAwarePageProjection;
import com.facebook.presto.operator.project.InputChannels;
import com.facebook.presto.operator.project.PageProjection;
import com.facebook.presto.operator.project.SelectedPositions;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.DictionaryBlock;
import com.facebook.presto.spi.block.DictionaryId;
import com.facebook.presto.spi.block.LazyBlock;
import com.facebook.presto.spi.block.LongArrayBlock;
import com.facebook.presto.spi.block.RunLengthEncodedBlock;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.google.common.collect.ImmutableList;
import io.airlift.concurrent.Threads;
import io.airlift.testing.Assertions;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestDictionaryAwarePageProjection {
    private static final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(Threads.daemonThreadsNamed((String)"test-%s"));

    @DataProvider(name="forceYield")
    public static Object[][] forceYield() {
        return new Object[][]{{true}, {false}};
    }

    @Test
    public void testDelegateMethods() {
        DictionaryAwarePageProjection projection = TestDictionaryAwarePageProjection.createProjection();
        Assert.assertEquals((boolean)projection.isDeterministic(), (boolean)true);
        Assert.assertEquals((Collection)projection.getInputChannels().getInputChannels(), (Collection)ImmutableList.of((Object)3));
        Assert.assertEquals((Object)projection.getType(), (Object)BigintType.BIGINT);
    }

    @Test(dataProvider="forceYield")
    public void testSimpleBlock(boolean forceYield) {
        Block block = BlockAssertions.createLongSequenceBlock(0, 100);
        TestDictionaryAwarePageProjection.testProject(block, block.getClass(), forceYield);
    }

    @Test(dataProvider="forceYield")
    public void testRleBlock(boolean forceYield) {
        Block value = BlockAssertions.createLongSequenceBlock(42, 43);
        RunLengthEncodedBlock block = new RunLengthEncodedBlock(value, 100);
        TestDictionaryAwarePageProjection.testProject((Block)block, RunLengthEncodedBlock.class, forceYield);
    }

    @Test(dataProvider="forceYield")
    public void testRleBlockWithFailure(boolean forceYield) {
        Block value = BlockAssertions.createLongSequenceBlock(-43, -42);
        RunLengthEncodedBlock block = new RunLengthEncodedBlock(value, 100);
        TestDictionaryAwarePageProjection.testProjectFails((Block)block, RunLengthEncodedBlock.class, forceYield);
    }

    @Test(dataProvider="forceYield")
    public void testDictionaryBlock(boolean forceYield) {
        DictionaryBlock block = TestDictionaryAwarePageProjection.createDictionaryBlock(10, 100);
        TestDictionaryAwarePageProjection.testProject((Block)block, DictionaryBlock.class, forceYield);
    }

    @Test(dataProvider="forceYield")
    public void testDictionaryBlockWithFailure(boolean forceYield) {
        DictionaryBlock block = TestDictionaryAwarePageProjection.createDictionaryBlockWithFailure(10, 100);
        TestDictionaryAwarePageProjection.testProjectFails((Block)block, DictionaryBlock.class, forceYield);
    }

    @Test(dataProvider="forceYield")
    public void testDictionaryBlockProcessingWithUnusedFailure(boolean forceYield) {
        DictionaryBlock block = TestDictionaryAwarePageProjection.createDictionaryBlockWithUnusedEntries(10, 100);
        TestDictionaryAwarePageProjection.testProject((Block)block, LongArrayBlock.class, forceYield);
    }

    @Test
    public void testDictionaryProcessingIgnoreYield() {
        DictionaryAwarePageProjection projection = TestDictionaryAwarePageProjection.createProjection();
        DictionaryBlock block = TestDictionaryAwarePageProjection.createDictionaryBlock(10, 100);
        TestDictionaryAwarePageProjection.testProjectRange((Block)block, DictionaryBlock.class, projection, true);
        TestDictionaryAwarePageProjection.testProjectFastReturnIgnoreYield((Block)block, projection);
        TestDictionaryAwarePageProjection.testProjectFastReturnIgnoreYield((Block)block, projection);
        TestDictionaryAwarePageProjection.testProjectFastReturnIgnoreYield((Block)block, projection);
    }

    @Test(dataProvider="forceYield")
    public void testDictionaryProcessingEnableDisable(boolean forceYield) {
        DictionaryAwarePageProjection projection = TestDictionaryAwarePageProjection.createProjection();
        DictionaryBlock ineffectiveBlock = TestDictionaryAwarePageProjection.createDictionaryBlock(100, 20);
        TestDictionaryAwarePageProjection.testProjectRange((Block)ineffectiveBlock, DictionaryBlock.class, projection, forceYield);
        TestDictionaryAwarePageProjection.testProjectFastReturnIgnoreYield((Block)ineffectiveBlock, projection);
        TestDictionaryAwarePageProjection.testProjectList((Block)ineffectiveBlock, DictionaryBlock.class, projection, false);
        DictionaryBlock effectiveBlock = TestDictionaryAwarePageProjection.createDictionaryBlock(10, 100);
        TestDictionaryAwarePageProjection.testProjectRange((Block)effectiveBlock, LongArrayBlock.class, projection, forceYield);
        TestDictionaryAwarePageProjection.testProjectList((Block)effectiveBlock, LongArrayBlock.class, projection, forceYield);
        TestDictionaryAwarePageProjection.testProjectRange((Block)ineffectiveBlock, DictionaryBlock.class, projection, forceYield);
        TestDictionaryAwarePageProjection.testProjectFastReturnIgnoreYield((Block)ineffectiveBlock, projection);
        TestDictionaryAwarePageProjection.testProjectList((Block)ineffectiveBlock, DictionaryBlock.class, projection, false);
        TestDictionaryAwarePageProjection.testProjectRange((Block)effectiveBlock, LongArrayBlock.class, projection, forceYield);
        TestDictionaryAwarePageProjection.testProjectList((Block)effectiveBlock, LongArrayBlock.class, projection, forceYield);
    }

    private static DictionaryBlock createDictionaryBlock(int dictionarySize, int blockSize) {
        Block dictionary = BlockAssertions.createLongSequenceBlock(0, dictionarySize);
        int[] ids = new int[blockSize];
        Arrays.setAll(ids, index -> index % dictionarySize);
        return new DictionaryBlock(dictionary, ids);
    }

    private static DictionaryBlock createDictionaryBlockWithFailure(int dictionarySize, int blockSize) {
        Block dictionary = BlockAssertions.createLongSequenceBlock(-10, dictionarySize - 10);
        int[] ids = new int[blockSize];
        Arrays.setAll(ids, index -> index % dictionarySize);
        return new DictionaryBlock(dictionary, ids);
    }

    private static DictionaryBlock createDictionaryBlockWithUnusedEntries(int dictionarySize, int blockSize) {
        Block dictionary = BlockAssertions.createLongSequenceBlock(-10, dictionarySize);
        int[] ids = new int[blockSize];
        Arrays.setAll(ids, index -> index % dictionarySize + 10);
        return new DictionaryBlock(dictionary, ids);
    }

    private static Block projectWithYield(Work<Block> work, DriverYieldSignal yieldSignal) {
        int yieldCount = 0;
        while (true) {
            yieldSignal.setWithDelay(1L, executor);
            yieldSignal.forceYieldForTesting();
            if (work.process()) {
                Assertions.assertGreaterThan((Comparable)Integer.valueOf(yieldCount), (Comparable)Integer.valueOf(0));
                return (Block)work.getResult();
            }
            if (++yieldCount > 1000000) {
                Assert.fail((String)"projection is not making progress");
            }
            yieldSignal.reset();
        }
    }

    private static void testProject(Block block, Class<? extends Block> expectedResultType, boolean forceYield) {
        TestDictionaryAwarePageProjection.testProjectRange(block, expectedResultType, TestDictionaryAwarePageProjection.createProjection(), forceYield);
        TestDictionaryAwarePageProjection.testProjectList(block, expectedResultType, TestDictionaryAwarePageProjection.createProjection(), forceYield);
        TestDictionaryAwarePageProjection.testProjectRange((Block)TestDictionaryAwarePageProjection.lazyWrapper(block), expectedResultType, TestDictionaryAwarePageProjection.createProjection(), forceYield);
        TestDictionaryAwarePageProjection.testProjectList((Block)TestDictionaryAwarePageProjection.lazyWrapper(block), expectedResultType, TestDictionaryAwarePageProjection.createProjection(), forceYield);
    }

    private static void testProjectFails(Block block, Class<? extends Block> expectedResultType, boolean forceYield) {
        Assert.assertThrows(NegativeValueException.class, () -> TestDictionaryAwarePageProjection.testProjectRange(block, expectedResultType, TestDictionaryAwarePageProjection.createProjection(), forceYield));
        Assert.assertThrows(NegativeValueException.class, () -> TestDictionaryAwarePageProjection.testProjectList(block, expectedResultType, TestDictionaryAwarePageProjection.createProjection(), forceYield));
        Assert.assertThrows(NegativeValueException.class, () -> TestDictionaryAwarePageProjection.testProjectRange((Block)TestDictionaryAwarePageProjection.lazyWrapper(block), expectedResultType, TestDictionaryAwarePageProjection.createProjection(), forceYield));
        Assert.assertThrows(NegativeValueException.class, () -> TestDictionaryAwarePageProjection.testProjectList((Block)TestDictionaryAwarePageProjection.lazyWrapper(block), expectedResultType, TestDictionaryAwarePageProjection.createProjection(), forceYield));
    }

    private static void testProjectRange(Block block, Class<? extends Block> expectedResultType, DictionaryAwarePageProjection projection, boolean forceYield) {
        Block result;
        DriverYieldSignal yieldSignal = new DriverYieldSignal();
        Work work = projection.project(null, yieldSignal, new Page(new Block[]{block}), SelectedPositions.positionsRange((int)5, (int)10));
        if (forceYield) {
            result = TestDictionaryAwarePageProjection.projectWithYield((Work<Block>)work, yieldSignal);
        } else {
            Assert.assertTrue((boolean)work.process());
            result = (Block)work.getResult();
        }
        BlockAssertions.assertBlockEquals((Type)BigintType.BIGINT, result, block.getRegion(5, 10));
        Assertions.assertInstanceOf((Object)result, expectedResultType);
    }

    private static void testProjectList(Block block, Class<? extends Block> expectedResultType, DictionaryAwarePageProjection projection, boolean forceYield) {
        Block result;
        DriverYieldSignal yieldSignal = new DriverYieldSignal();
        int[] positions = new int[]{0, 2, 4, 6, 8, 10};
        Work work = projection.project(null, yieldSignal, new Page(new Block[]{block}), SelectedPositions.positionsList((int[])positions, (int)0, (int)positions.length));
        if (forceYield) {
            result = TestDictionaryAwarePageProjection.projectWithYield((Work<Block>)work, yieldSignal);
        } else {
            Assert.assertTrue((boolean)work.process());
            result = (Block)work.getResult();
        }
        BlockAssertions.assertBlockEquals((Type)BigintType.BIGINT, result, block.copyPositions(positions, 0, positions.length));
        Assertions.assertInstanceOf((Object)result, expectedResultType);
    }

    private static void testProjectFastReturnIgnoreYield(Block block, DictionaryAwarePageProjection projection) {
        DriverYieldSignal yieldSignal = new DriverYieldSignal();
        Work work = projection.project(null, yieldSignal, new Page(new Block[]{block}), SelectedPositions.positionsRange((int)5, (int)10));
        yieldSignal.setWithDelay(1L, executor);
        yieldSignal.forceYieldForTesting();
        Assert.assertTrue((boolean)work.process());
        Block result = (Block)work.getResult();
        yieldSignal.reset();
        BlockAssertions.assertBlockEquals((Type)BigintType.BIGINT, result, block.getRegion(5, 10));
        Assertions.assertInstanceOf((Object)result, DictionaryBlock.class);
    }

    private static DictionaryAwarePageProjection createProjection() {
        return new DictionaryAwarePageProjection((PageProjection)new TestPageProjection(), block -> DictionaryId.randomDictionaryId());
    }

    private static LazyBlock lazyWrapper(Block block) {
        return new LazyBlock(block.getPositionCount(), lazyBlock -> lazyBlock.setBlock(block));
    }

    private static class NegativeValueException
    extends RuntimeException {
        public NegativeValueException(long value) {
            super("value is negative: " + value);
        }
    }

    private static class TestPageProjection
    implements PageProjection {
        private TestPageProjection() {
        }

        public Type getType() {
            return BigintType.BIGINT;
        }

        public boolean isDeterministic() {
            return true;
        }

        public InputChannels getInputChannels() {
            return new InputChannels(new int[]{3});
        }

        public Work<Block> project(ConnectorSession session, DriverYieldSignal yieldSignal, Page page, SelectedPositions selectedPositions) {
            return new TestPageProjectionWork(yieldSignal, page, selectedPositions);
        }

        private static long verifyPositive(long value) {
            if (value < 0L) {
                throw new NegativeValueException(value);
            }
            return value;
        }

        private class TestPageProjectionWork
        implements Work<Block> {
            private final DriverYieldSignal yieldSignal;
            private final Block block;
            private final SelectedPositions selectedPositions;
            private BlockBuilder blockBuilder;
            private int nextIndexOrPosition;
            private Block result;

            public TestPageProjectionWork(DriverYieldSignal yieldSignal, Page page, SelectedPositions selectedPositions) {
                this.yieldSignal = yieldSignal;
                this.block = page.getBlock(0);
                this.selectedPositions = selectedPositions;
                this.blockBuilder = BigintType.BIGINT.createBlockBuilder(null, selectedPositions.size());
            }

            public boolean process() {
                Assert.assertNull((Object)this.result);
                if (this.selectedPositions.isList()) {
                    int offset = this.selectedPositions.getOffset();
                    int[] positions = this.selectedPositions.getPositions();
                    for (int index = this.nextIndexOrPosition + offset; index < offset + this.selectedPositions.size(); ++index) {
                        this.blockBuilder.writeLong(TestPageProjection.verifyPositive(this.block.getLong(positions[index], 0)));
                        if (!this.yieldSignal.isSet()) continue;
                        this.nextIndexOrPosition = index + 1 - offset;
                        return false;
                    }
                } else {
                    int offset = this.selectedPositions.getOffset();
                    for (int position = this.nextIndexOrPosition + offset; position < offset + this.selectedPositions.size(); ++position) {
                        this.blockBuilder.writeLong(TestPageProjection.verifyPositive(this.block.getLong(position, 0)));
                        if (!this.yieldSignal.isSet()) continue;
                        this.nextIndexOrPosition = position + 1 - offset;
                        return false;
                    }
                }
                this.result = this.blockBuilder.build();
                this.blockBuilder = this.blockBuilder.newBlockBuilderLike(null);
                return true;
            }

            public Block getResult() {
                Assert.assertNotNull((Object)this.result);
                return this.result;
            }
        }
    }
}

