/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.project;

import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.operator.CompletedWork;
import com.facebook.presto.operator.DriverYieldSignal;
import com.facebook.presto.operator.PageAssertions;
import com.facebook.presto.operator.Work;
import com.facebook.presto.operator.project.InputChannels;
import com.facebook.presto.operator.project.InputPageProjection;
import com.facebook.presto.operator.project.PageFilter;
import com.facebook.presto.operator.project.PageProcessor;
import com.facebook.presto.operator.project.PageProcessorOutput;
import com.facebook.presto.operator.project.PageProjection;
import com.facebook.presto.operator.project.SelectedPositions;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.LazyBlock;
import com.facebook.presto.spi.block.VariableWidthBlock;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.testing.TestingConnectorSession;
import com.google.common.collect.ImmutableList;
import io.airlift.concurrent.Threads;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.openjdk.jol.info.ClassLayout;
import org.testng.Assert;
import org.testng.annotations.Test;
import sun.misc.Unsafe;

public class TestPageProcessor {
    private final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(Threads.daemonThreadsNamed((String)"test-%s"));

    @Test
    public void testProjectNoColumns() {
        PageProcessor pageProcessor = new PageProcessor(Optional.empty(), (List)ImmutableList.of());
        Page inputPage = new Page(new Block[]{BlockAssertions.createLongSequenceBlock(0, 100)});
        PageProcessorOutput output = pageProcessor.process(TestingConnectorSession.SESSION, new DriverYieldSignal(), inputPage);
        Assert.assertEquals((long)output.getRetainedSizeInBytes(), (long)inputPage.getRetainedSizeInBytes());
        ImmutableList outputPages = ImmutableList.copyOf((Iterator)output);
        Assert.assertEquals((int)outputPages.size(), (int)1);
        Page outputPage = ((Optional)outputPages.get(0)).orElse(null);
        Assert.assertEquals((int)outputPage.getChannelCount(), (int)0);
        Assert.assertEquals((int)outputPage.getPositionCount(), (int)inputPage.getPositionCount());
    }

    @Test
    public void testFilterNoColumns() {
        PageProcessor pageProcessor = new PageProcessor(Optional.of(new TestingPageFilter(SelectedPositions.positionsRange((int)0, (int)50))), (List)ImmutableList.of());
        Page inputPage = new Page(new Block[]{BlockAssertions.createLongSequenceBlock(0, 100)});
        PageProcessorOutput output = pageProcessor.process(TestingConnectorSession.SESSION, new DriverYieldSignal(), inputPage);
        Assert.assertEquals((long)output.getRetainedSizeInBytes(), (long)inputPage.getRetainedSizeInBytes());
        ImmutableList outputPages = ImmutableList.copyOf((Iterator)output);
        Assert.assertEquals((int)outputPages.size(), (int)1);
        Page outputPage = ((Optional)outputPages.get(0)).orElse(null);
        Assert.assertEquals((int)outputPage.getChannelCount(), (int)0);
        Assert.assertEquals((int)outputPage.getPositionCount(), (int)50);
    }

    @Test
    public void testPartialFilter() {
        PageProcessor pageProcessor = new PageProcessor(Optional.of(new TestingPageFilter(SelectedPositions.positionsRange((int)25, (int)50))), (List)ImmutableList.of((Object)new InputPageProjection(0, (Type)BigintType.BIGINT)));
        Page inputPage = new Page(new Block[]{BlockAssertions.createLongSequenceBlock(0, 100)});
        PageProcessorOutput output = pageProcessor.process(TestingConnectorSession.SESSION, new DriverYieldSignal(), inputPage);
        Assert.assertEquals((long)output.getRetainedSizeInBytes(), (long)inputPage.getRetainedSizeInBytes());
        ImmutableList outputPages = ImmutableList.copyOf((Iterator)output);
        Assert.assertEquals((int)outputPages.size(), (int)1);
        PageAssertions.assertPageEquals((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), ((Optional)outputPages.get(0)).orElse(null), new Page(new Block[]{BlockAssertions.createLongSequenceBlock(25, 75)}));
    }

    @Test
    public void testSelectAllFilter() {
        PageProcessor pageProcessor = new PageProcessor(Optional.of(new SelectAllFilter()), (List)ImmutableList.of((Object)new InputPageProjection(0, (Type)BigintType.BIGINT)));
        Page inputPage = new Page(new Block[]{BlockAssertions.createLongSequenceBlock(0, 100)});
        PageProcessorOutput output = pageProcessor.process(TestingConnectorSession.SESSION, new DriverYieldSignal(), inputPage);
        Assert.assertEquals((long)output.getRetainedSizeInBytes(), (long)inputPage.getRetainedSizeInBytes());
        ImmutableList outputPages = ImmutableList.copyOf((Iterator)output);
        Assert.assertEquals((int)outputPages.size(), (int)1);
        PageAssertions.assertPageEquals((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), ((Optional)outputPages.get(0)).orElse(null), new Page(new Block[]{BlockAssertions.createLongSequenceBlock(0, 100)}));
    }

    @Test
    public void testSelectNoneFilter() {
        PageProcessor pageProcessor = new PageProcessor(Optional.of(new SelectNoneFilter()), (List)ImmutableList.of((Object)new InputPageProjection(0, (Type)BigintType.BIGINT)));
        Page inputPage = new Page(new Block[]{BlockAssertions.createLongSequenceBlock(0, 100)});
        PageProcessorOutput output = pageProcessor.process(TestingConnectorSession.SESSION, new DriverYieldSignal(), inputPage);
        Assert.assertEquals((long)output.getRetainedSizeInBytes(), (long)0L);
        ImmutableList outputPages = ImmutableList.copyOf((Iterator)output);
        Assert.assertEquals((int)outputPages.size(), (int)0);
    }

    @Test
    public void testProjectEmptyPage() {
        PageProcessor pageProcessor = new PageProcessor(Optional.of(new SelectAllFilter()), (List)ImmutableList.of((Object)new InputPageProjection(0, (Type)BigintType.BIGINT)));
        Page inputPage = new Page(new Block[]{BlockAssertions.createLongSequenceBlock(0, 0)});
        PageProcessorOutput output = pageProcessor.process(TestingConnectorSession.SESSION, new DriverYieldSignal(), inputPage);
        Assert.assertEquals((long)output.getRetainedSizeInBytes(), (long)0L);
        ImmutableList outputPages = ImmutableList.copyOf((Iterator)output);
        Assert.assertEquals((int)outputPages.size(), (int)0);
    }

    @Test
    public void testSelectNoneFilterLazyLoad() {
        PageProcessor pageProcessor = new PageProcessor(Optional.of(new SelectNoneFilter()), (List)ImmutableList.of((Object)new InputPageProjection(1, (Type)BigintType.BIGINT)));
        Page inputPage = new Page(new Block[]{BlockAssertions.createLongSequenceBlock(0, 100), new LazyBlock(100, lazyBlock -> {
            throw new AssertionError((Object)"Lazy block should not be loaded");
        })});
        PageProcessorOutput output = pageProcessor.process(TestingConnectorSession.SESSION, new DriverYieldSignal(), inputPage);
        Assert.assertEquals((long)output.getRetainedSizeInBytes(), (long)0L);
        ImmutableList outputPages = ImmutableList.copyOf((Iterator)output);
        Assert.assertEquals((int)outputPages.size(), (int)0);
    }

    @Test
    public void testProjectLazyLoad() {
        PageProcessor pageProcessor = new PageProcessor(Optional.of(new SelectAllFilter()), (List)ImmutableList.of((Object)new LazyPagePageProjection()));
        Page inputPage = new Page(new Block[]{BlockAssertions.createLongSequenceBlock(0, 100), new LazyBlock(100, lazyBlock -> {
            throw new AssertionError((Object)"Lazy block should not be loaded");
        })});
        PageProcessorOutput output = pageProcessor.process(TestingConnectorSession.SESSION, new DriverYieldSignal(), inputPage);
        Assert.assertEquals((long)output.getRetainedSizeInBytes(), (long)(new Page(new Block[]{BlockAssertions.createLongSequenceBlock(0, 100)}).getRetainedSizeInBytes() + (long)Unsafe.ARRAY_OBJECT_INDEX_SCALE));
        ImmutableList outputPages = ImmutableList.copyOf((Iterator)output);
        Assert.assertEquals((int)outputPages.size(), (int)1);
        PageAssertions.assertPageEquals((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), ((Optional)outputPages.get(0)).orElse(null), new Page(new Block[]{BlockAssertions.createLongSequenceBlock(0, 100)}));
    }

    @Test
    public void testBatchedOutput() {
        PageProcessor pageProcessor = new PageProcessor(Optional.empty(), (List)ImmutableList.of((Object)new InputPageProjection(0, (Type)BigintType.BIGINT)));
        Page inputPage = new Page(new Block[]{BlockAssertions.createLongSequenceBlock(0, 20480)});
        PageProcessorOutput output = pageProcessor.process(TestingConnectorSession.SESSION, new DriverYieldSignal(), inputPage);
        Assert.assertEquals((long)output.getRetainedSizeInBytes(), (long)inputPage.getRetainedSizeInBytes());
        ImmutableList outputPages = ImmutableList.copyOf((Iterator)output);
        Assert.assertEquals((int)outputPages.size(), (int)3);
        for (int i = 0; i < outputPages.size(); ++i) {
            Page actualPage = ((Optional)outputPages.get(i)).orElse(null);
            int offset = i * 8192;
            Page expectedPage = new Page(new Block[]{BlockAssertions.createLongSequenceBlock(offset, offset + Math.min(inputPage.getPositionCount() - offset, 8192))});
            PageAssertions.assertPageEquals((List<? extends Type>)ImmutableList.of((Object)BigintType.BIGINT), actualPage, expectedPage);
        }
    }

    @Test
    public void testAdaptiveBatchSize() {
        PageProcessor pageProcessor = new PageProcessor(Optional.empty(), (List)ImmutableList.of((Object)new InputPageProjection(0, (Type)VarcharType.VARCHAR)));
        Object[] slices = new Slice[20480];
        Arrays.fill(slices, Slices.allocate((int)1024));
        Page inputPage = new Page(new Block[]{BlockAssertions.createSlicesBlock((Slice[])slices)});
        PageProcessorOutput output = pageProcessor.process(TestingConnectorSession.SESSION, new DriverYieldSignal(), inputPage);
        Assert.assertEquals((long)output.getRetainedSizeInBytes(), (long)inputPage.getRetainedSizeInBytes());
        ImmutableList outputPages = ImmutableList.copyOf((Iterator)output);
        int batchSize = 8192;
        for (Optional actualPage : outputPages) {
            Page expectedPage = new Page(new Block[]{BlockAssertions.createSlicesBlock((Slice[])Arrays.copyOfRange(slices, 0, batchSize))});
            PageAssertions.assertPageEquals((List<? extends Type>)ImmutableList.of((Object)VarcharType.VARCHAR), actualPage.orElse(null), expectedPage);
            if (((Page)actualPage.orElseThrow(() -> new AssertionError((Object)"page is not present"))).getSizeInBytes() <= 0x400000L) continue;
            batchSize /= 2;
        }
        Arrays.fill(slices, Slices.allocate((int)128));
        inputPage = new Page(new Block[]{BlockAssertions.createSlicesBlock((Slice[])slices)});
        output = pageProcessor.process(TestingConnectorSession.SESSION, new DriverYieldSignal(), inputPage);
        Assert.assertEquals((long)output.getRetainedSizeInBytes(), (long)inputPage.getRetainedSizeInBytes());
        outputPages = ImmutableList.copyOf((Iterator)output);
        int offset = 0;
        for (Optional actualPage : outputPages) {
            Page expectedPage = new Page(new Block[]{BlockAssertions.createSlicesBlock((Slice[])Arrays.copyOfRange(slices, 0, Math.min(inputPage.getPositionCount() - offset, batchSize)))});
            PageAssertions.assertPageEquals((List<? extends Type>)ImmutableList.of((Object)VarcharType.VARCHAR), actualPage.orElse(null), expectedPage);
            offset += ((Page)actualPage.orElseThrow(() -> new AssertionError((Object)"page is not present"))).getPositionCount();
            if (((Page)actualPage.orElseThrow(() -> new AssertionError((Object)"page is not present"))).getSizeInBytes() >= 0x100000L) continue;
            batchSize *= 2;
        }
    }

    @Test
    public void testOptimisticProcessing() {
        InvocationCountPageProjection firstProjection = new InvocationCountPageProjection((PageProjection)new InputPageProjection(0, (Type)VarcharType.VARCHAR));
        InvocationCountPageProjection secondProjection = new InvocationCountPageProjection((PageProjection)new InputPageProjection(0, (Type)VarcharType.VARCHAR));
        PageProcessor pageProcessor = new PageProcessor(Optional.empty(), (List)ImmutableList.of((Object)firstProjection, (Object)secondProjection));
        Object[] slices = new Slice[20480];
        Arrays.fill(slices, Slices.allocate((int)1024));
        Page inputPage = new Page(new Block[]{BlockAssertions.createSlicesBlock((Slice[])slices)});
        PageProcessorOutput output = pageProcessor.process(TestingConnectorSession.SESSION, new DriverYieldSignal(), inputPage);
        Assert.assertEquals((long)output.getRetainedSizeInBytes(), (long)inputPage.getRetainedSizeInBytes());
        int batchSize = 8192;
        while (inputPage.getBlock(0).getRegionSizeInBytes(0, batchSize) > 0x400000L) {
            batchSize /= 2;
        }
        int pageCount = 0;
        while (output.hasNext()) {
            Page actualPage = output.next().orElse(null);
            Block sliceBlock = BlockAssertions.createSlicesBlock((Slice[])Arrays.copyOfRange(slices, 0, batchSize));
            Page expectedPage = new Page(new Block[]{sliceBlock, sliceBlock});
            PageAssertions.assertPageEquals((List<? extends Type>)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR), actualPage, expectedPage);
            ++pageCount;
            if (actualPage.getSizeInBytes() <= 0x400000L) continue;
            batchSize /= 2;
        }
        Assert.assertEquals((int)secondProjection.getInvocationCount(), (int)pageCount);
        Assert.assertTrue((firstProjection.getInvocationCount() < secondProjection.getInvocationCount() ? 1 : 0) != 0);
    }

    @Test
    public void testRetainedSize() {
        PageProcessor pageProcessor = new PageProcessor(Optional.of(new SelectAllFilter()), (List)ImmutableList.of((Object)new InputPageProjection(0, (Type)VarcharType.VARCHAR), (Object)new InputPageProjection(1, (Type)VarcharType.VARCHAR)));
        String value = String.join((CharSequence)"", Collections.nCopies(10000, "a"));
        List<String> values = Collections.nCopies(800, value);
        Page inputPage = new Page(new Block[]{BlockAssertions.createStringsBlock(values), BlockAssertions.createStringsBlock(values)});
        PageProcessorOutput output = pageProcessor.process(TestingConnectorSession.SESSION, new DriverYieldSignal(), inputPage);
        output.hasNext();
        Assert.assertEquals((long)(output.getRetainedSizeInBytes() - (long)ClassLayout.parseClass(VariableWidthBlock.class).instanceSize()), (long)inputPage.getRetainedSizeInBytes());
    }

    @Test
    public void testYieldProjection() {
        int rows = 128;
        int columns = 20;
        DriverYieldSignal yieldSignal = new DriverYieldSignal();
        PageProcessor pageProcessor = new PageProcessor(Optional.empty(), Collections.nCopies(columns, new YieldPageProjection((PageProjection)new InputPageProjection(0, (Type)VarcharType.VARCHAR))));
        Object[] slices = new Slice[rows];
        Arrays.fill(slices, Slices.allocate((int)rows));
        Page inputPage = new Page(new Block[]{BlockAssertions.createSlicesBlock((Slice[])slices)});
        PageProcessorOutput output = pageProcessor.process(TestingConnectorSession.SESSION, yieldSignal, inputPage);
        for (int i = 0; i < columns - 1; ++i) {
            Assert.assertTrue((boolean)output.hasNext());
            Assert.assertNull(output.next().orElse(null));
            Assert.assertTrue((boolean)yieldSignal.isSet());
            yieldSignal.reset();
        }
        Assert.assertTrue((boolean)output.hasNext());
        Page actualPage = output.next().orElse(null);
        Assert.assertNotNull((Object)actualPage);
        Assert.assertTrue((boolean)yieldSignal.isSet());
        yieldSignal.reset();
        Object[] blocks = new Block[columns];
        Arrays.fill(blocks, BlockAssertions.createSlicesBlock((Slice[])Arrays.copyOfRange(slices, 0, rows)));
        Page expectedPage = new Page((Block[])blocks);
        PageAssertions.assertPageEquals(Collections.nCopies(columns, VarcharType.VARCHAR), actualPage, expectedPage);
        Assert.assertFalse((boolean)output.hasNext());
    }

    private static class SelectNoneFilter
    implements PageFilter {
        private SelectNoneFilter() {
        }

        public boolean isDeterministic() {
            return true;
        }

        public InputChannels getInputChannels() {
            return new InputChannels(new int[]{0});
        }

        public SelectedPositions filter(ConnectorSession session, Page page) {
            return SelectedPositions.positionsRange((int)0, (int)0);
        }
    }

    public static class SelectAllFilter
    implements PageFilter {
        public boolean isDeterministic() {
            return true;
        }

        public InputChannels getInputChannels() {
            return new InputChannels(new int[]{0});
        }

        public SelectedPositions filter(ConnectorSession session, Page page) {
            return SelectedPositions.positionsRange((int)0, (int)page.getPositionCount());
        }
    }

    private static class TestingPageFilter
    implements PageFilter {
        private final SelectedPositions selectedPositions;

        public TestingPageFilter(SelectedPositions selectedPositions) {
            this.selectedPositions = selectedPositions;
        }

        public boolean isDeterministic() {
            return true;
        }

        public InputChannels getInputChannels() {
            return new InputChannels(new int[]{0});
        }

        public SelectedPositions filter(ConnectorSession session, Page page) {
            return this.selectedPositions;
        }
    }

    public static class LazyPagePageProjection
    implements PageProjection {
        public Type getType() {
            return BigintType.BIGINT;
        }

        public boolean isDeterministic() {
            return true;
        }

        public InputChannels getInputChannels() {
            return new InputChannels(new int[]{0, 1});
        }

        public Work<Block> project(ConnectorSession session, DriverYieldSignal yieldSignal, Page page, SelectedPositions selectedPositions) {
            return new CompletedWork((Object)page.getBlock(0).getLoadedBlock());
        }
    }

    private class YieldPageProjection
    extends InvocationCountPageProjection {
        public YieldPageProjection(PageProjection delegate) {
            super(delegate);
        }

        @Override
        public Work<Block> project(ConnectorSession session, DriverYieldSignal yieldSignal, Page page, SelectedPositions selectedPositions) {
            return new YieldPageProjectionWork(session, yieldSignal, page, selectedPositions);
        }

        private class YieldPageProjectionWork
        implements Work<Block> {
            private final DriverYieldSignal yieldSignal;
            private final Work<Block> work;

            public YieldPageProjectionWork(ConnectorSession session, DriverYieldSignal yieldSignal, Page page, SelectedPositions selectedPositions) {
                this.yieldSignal = yieldSignal;
                this.work = YieldPageProjection.this.delegate.project(session, yieldSignal, page, selectedPositions);
            }

            public boolean process() {
                Assert.assertTrue((boolean)this.work.process());
                this.yieldSignal.setWithDelay(1L, TestPageProcessor.this.executor);
                this.yieldSignal.forceYieldForTesting();
                return true;
            }

            public Block getResult() {
                return (Block)this.work.getResult();
            }
        }
    }

    private static class InvocationCountPageProjection
    implements PageProjection {
        protected final PageProjection delegate;
        private int invocationCount;

        public InvocationCountPageProjection(PageProjection delegate) {
            this.delegate = delegate;
        }

        public Type getType() {
            return this.delegate.getType();
        }

        public boolean isDeterministic() {
            return this.delegate.isDeterministic();
        }

        public InputChannels getInputChannels() {
            return this.delegate.getInputChannels();
        }

        public Work<Block> project(ConnectorSession session, DriverYieldSignal yieldSignal, Page page, SelectedPositions selectedPositions) {
            this.setInvocationCount(this.getInvocationCount() + 1);
            return this.delegate.project(session, yieldSignal, page, selectedPositions);
        }

        public int getInvocationCount() {
            return this.invocationCount;
        }

        public void setInvocationCount(int invocationCount) {
            this.invocationCount = invocationCount;
        }
    }
}

