/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.FunctionListBuilder;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SqlFunction;
import com.facebook.presto.metadata.SqlScalarFunction;
import com.facebook.presto.operator.DriverYieldSignal;
import com.facebook.presto.operator.project.PageProcessor;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.type.ArrayType;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.TypeUtils;
import com.facebook.presto.sql.gen.ExpressionCompiler;
import com.facebook.presto.sql.gen.PageFunctionCompiler;
import com.facebook.presto.sql.relational.CallExpression;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.LambdaDefinitionExpression;
import com.facebook.presto.sql.relational.RowExpression;
import com.facebook.presto.sql.relational.VariableReferenceExpression;
import com.facebook.presto.testing.TestingConnectorSession;
import com.facebook.presto.util.Reflection;
import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Fork(value=2)
@Warmup(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkArrayFilter {
    private static final int POSITIONS = 100000;
    private static final int ARRAY_SIZE = 4;
    private static final int NUM_TYPES = 1;
    private static final List<Type> TYPES = ImmutableList.of((Object)BigintType.BIGINT);

    @Benchmark
    @OperationsPerInvocation(value=400000)
    public List<Optional<Page>> benchmark(BenchmarkData data) {
        return ImmutableList.copyOf((Iterator)data.getPageProcessor().process(TestingConnectorSession.SESSION, new DriverYieldSignal(), data.getPage()));
    }

    public static void main(String[] args) throws Throwable {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        new BenchmarkArrayFilter().benchmark(data);
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + BenchmarkArrayFilter.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }

    static {
        Verify.verify((1 == TYPES.size() ? 1 : 0) != 0);
    }

    public static final class ExactArrayFilterFunction
    extends SqlScalarFunction {
        public static final ExactArrayFilterFunction EXACT_ARRAY_FILTER_FUNCTION = new ExactArrayFilterFunction();
        private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(ExactArrayFilterFunction.class, (String)"filter", (Class[])new Class[]{Type.class, Block.class, MethodHandle.class});

        private ExactArrayFilterFunction() {
            super(new Signature("exact_filter", FunctionKind.SCALAR, (List)ImmutableList.of((Object)Signature.typeVariable((String)"T")), (List)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"array(T)"), (List)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"array(T)"), (Object)TypeSignature.parseTypeSignature((String)"function(T,boolean)")), false));
        }

        public boolean isHidden() {
            return false;
        }

        public boolean isDeterministic() {
            return false;
        }

        public String getDescription() {
            return "return array containing elements that match the given predicate";
        }

        public ScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
            Type type = boundVariables.getTypeVariable("T");
            return new ScalarFunctionImplementation(false, (List)ImmutableList.of((Object)ScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty((ScalarFunctionImplementation.NullConvention)ScalarFunctionImplementation.NullConvention.RETURN_NULL_ON_NULL), (Object)ScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty((ScalarFunctionImplementation.NullConvention)ScalarFunctionImplementation.NullConvention.RETURN_NULL_ON_NULL)), METHOD_HANDLE.bindTo(type), this.isDeterministic());
        }

        public static Block filter(Type type, Block block, MethodHandle function) {
            int positionCount = block.getPositionCount();
            BlockBuilder resultBuilder = type.createBlockBuilder(null, positionCount);
            for (int position = 0; position < positionCount; ++position) {
                Boolean keep;
                Long input = (Long)TypeUtils.readNativeValue((Type)type, (Block)block, (int)position);
                try {
                    keep = function.invokeExact(input);
                }
                catch (Throwable t) {
                    Throwables.throwIfUnchecked((Throwable)t);
                    throw new RuntimeException(t);
                }
                if (!Boolean.TRUE.equals(keep)) continue;
                block.writePositionTo(position, resultBuilder);
            }
            return resultBuilder.build();
        }
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        @Param(value={"filter", "exact_filter"})
        private String name = "filter";
        private Page page;
        private PageProcessor pageProcessor;

        @Setup
        public void setup() {
            MetadataManager metadata = MetadataManager.createTestMetadataManager();
            metadata.addFunctions(new FunctionListBuilder().function((SqlFunction)ExactArrayFilterFunction.EXACT_ARRAY_FILTER_FUNCTION).getFunctions());
            ExpressionCompiler compiler = new ExpressionCompiler((Metadata)metadata, new PageFunctionCompiler((Metadata)metadata, 0));
            ImmutableList.Builder projectionsBuilder = ImmutableList.builder();
            Block[] blocks = new Block[TYPES.size()];
            for (int i = 0; i < TYPES.size(); ++i) {
                Type elementType = (Type)TYPES.get(i);
                ArrayType arrayType = new ArrayType(elementType);
                Signature signature = new Signature(this.name, FunctionKind.SCALAR, arrayType.getTypeSignature(), new TypeSignature[]{arrayType.getTypeSignature(), TypeSignature.parseTypeSignature((String)"function(bigint,boolean)")});
                Signature greaterThan = new Signature("$operator$" + OperatorType.GREATER_THAN.name(), FunctionKind.SCALAR, BooleanType.BOOLEAN.getTypeSignature(), new TypeSignature[]{BigintType.BIGINT.getTypeSignature(), BigintType.BIGINT.getTypeSignature()});
                projectionsBuilder.add((Object)new CallExpression(signature, (Type)arrayType, (List)ImmutableList.of((Object)Expressions.field((int)0, (Type)arrayType), (Object)new LambdaDefinitionExpression((List)ImmutableList.of((Object)BigintType.BIGINT), (List)ImmutableList.of((Object)"x"), (RowExpression)new CallExpression(greaterThan, (Type)BooleanType.BOOLEAN, (List)ImmutableList.of((Object)new VariableReferenceExpression("x", (Type)BigintType.BIGINT), (Object)Expressions.constant((Object)0L, (Type)BigintType.BIGINT)))))));
                blocks[i] = BenchmarkData.createChannel(100000, 4, arrayType);
            }
            ImmutableList projections = projectionsBuilder.build();
            this.pageProcessor = (PageProcessor)compiler.compilePageProcessor(Optional.empty(), (List)projections).get();
            this.page = new Page(blocks);
        }

        private static Block createChannel(int positionCount, int arraySize, ArrayType arrayType) {
            BlockBuilder blockBuilder = arrayType.createBlockBuilder(null, positionCount);
            for (int position = 0; position < positionCount; ++position) {
                BlockBuilder entryBuilder = blockBuilder.beginBlockEntry();
                for (int i = 0; i < arraySize; ++i) {
                    if (arrayType.getElementType().getJavaType() != Long.TYPE) {
                        throw new UnsupportedOperationException();
                    }
                    arrayType.getElementType().writeLong(entryBuilder, ThreadLocalRandom.current().nextLong());
                }
                blockBuilder.closeEntry();
            }
            return blockBuilder.build();
        }

        public PageProcessor getPageProcessor() {
            return this.pageProcessor;
        }

        public Page getPage() {
            return this.page;
        }
    }
}

