/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.FunctionExtractor;
import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.operator.DriverYieldSignal;
import com.facebook.presto.operator.project.PageProcessor;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.type.ArrayType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.sql.gen.ExpressionCompiler;
import com.facebook.presto.sql.gen.PageFunctionCompiler;
import com.facebook.presto.sql.relational.CallExpression;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.testing.TestingConnectorSession;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import io.airlift.slice.Slices;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Fork(value=2)
@Warmup(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkArraySort {
    private static final int POSITIONS = 100000;
    private static final int ARRAY_SIZE = 100;
    private static final int NUM_TYPES = 1;
    private static final List<Type> TYPES = ImmutableList.of((Object)VarcharType.VARCHAR);

    @Benchmark
    @OperationsPerInvocation(value=10000000)
    public List<Optional<Page>> arraySort(BenchmarkData data) {
        return ImmutableList.copyOf((Iterator)data.getPageProcessor().process(TestingConnectorSession.SESSION, new DriverYieldSignal(), data.getPage()));
    }

    public static void main(String[] args) throws Throwable {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        new BenchmarkArraySort().arraySort(data);
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + BenchmarkArraySort.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }

    @ScalarFunction
    @SqlType(value="array(varchar)")
    public static Block oldArraySort(@SqlType(value="array(varchar)") Block block) {
        List positions = Ints.asList((int[])new int[block.getPositionCount()]);
        for (int i = 0; i < block.getPositionCount(); ++i) {
            positions.set(i, i);
        }
        positions.sort((p1, p2) -> VarcharType.VARCHAR.compareTo(block, p1.intValue(), block, p2.intValue()));
        BlockBuilder blockBuilder = VarcharType.VARCHAR.createBlockBuilder(null, block.getPositionCount());
        Iterator iterator = positions.iterator();
        while (iterator.hasNext()) {
            int position = (Integer)iterator.next();
            VarcharType.VARCHAR.appendTo(block, position, blockBuilder);
        }
        return blockBuilder.build();
    }

    static {
        Verify.verify((1 == TYPES.size() ? 1 : 0) != 0);
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        @Param(value={"array_sort", "old_array_sort"})
        private String name = "array_sort";
        private Page page;
        private PageProcessor pageProcessor;

        @Setup
        public void setup() {
            MetadataManager metadata = MetadataManager.createTestMetadataManager();
            metadata.addFunctions(FunctionExtractor.extractFunctions(BenchmarkArraySort.class));
            ExpressionCompiler compiler = new ExpressionCompiler((Metadata)metadata, new PageFunctionCompiler((Metadata)metadata, 0));
            ImmutableList.Builder projectionsBuilder = ImmutableList.builder();
            Block[] blocks = new Block[TYPES.size()];
            for (int i = 0; i < TYPES.size(); ++i) {
                Type elementType = (Type)TYPES.get(i);
                ArrayType arrayType = new ArrayType(elementType);
                Signature signature = new Signature(this.name, FunctionKind.SCALAR, arrayType.getTypeSignature(), new TypeSignature[]{arrayType.getTypeSignature()});
                projectionsBuilder.add((Object)new CallExpression(signature, (Type)arrayType, (List)ImmutableList.of((Object)Expressions.field((int)i, (Type)arrayType))));
                blocks[i] = BenchmarkData.createChannel(100000, 100, arrayType);
            }
            ImmutableList projections = projectionsBuilder.build();
            this.pageProcessor = (PageProcessor)compiler.compilePageProcessor(Optional.empty(), (List)projections).get();
            this.page = new Page(blocks);
        }

        private static Block createChannel(int positionCount, int arraySize, ArrayType arrayType) {
            BlockBuilder blockBuilder = arrayType.createBlockBuilder(null, positionCount);
            for (int position = 0; position < positionCount; ++position) {
                BlockBuilder entryBuilder = blockBuilder.beginBlockEntry();
                for (int i = 0; i < arraySize; ++i) {
                    if (arrayType.getElementType().getJavaType() == Long.TYPE) {
                        arrayType.getElementType().writeLong(entryBuilder, ThreadLocalRandom.current().nextLong());
                        continue;
                    }
                    if (arrayType.getElementType().equals(VarcharType.VARCHAR)) {
                        arrayType.getElementType().writeSlice(entryBuilder, Slices.utf8Slice((String)"test_string"));
                        continue;
                    }
                    throw new UnsupportedOperationException();
                }
                blockBuilder.closeEntry();
            }
            return blockBuilder.build();
        }

        public PageProcessor getPageProcessor() {
            return this.pageProcessor;
        }

        public Page getPage() {
            return this.page;
        }
    }
}

