/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.operator.DriverYieldSignal;
import com.facebook.presto.operator.project.PageProcessor;
import com.facebook.presto.operator.project.PageProcessorOutput;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.sql.gen.ExpressionCompiler;
import com.facebook.presto.sql.gen.PageFunctionCompiler;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.RowExpression;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;

@State(value=Scope.Thread)
@Fork(value=3)
@Warmup(iterations=5, time=10)
@Measurement(iterations=5, time=10)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
public class BenchmarkEqualsOperator {
    private static final int FIELDS_COUNT = 10;
    private static final int COMPARISONS_COUNT = 100;
    private static final double NULLS_FRACTION = 0.05;
    private static final DriverYieldSignal SIGNAL = new DriverYieldSignal();
    private static final ConnectorSession SESSION = SessionTestUtils.TEST_SESSION.toConnectorSession();
    private PageProcessor compiledProcessor;

    @Setup
    public void setup() {
        MetadataManager metadata = MetadataManager.createTestMetadataManager();
        ExpressionCompiler expressionCompiler = new ExpressionCompiler((Metadata)metadata, new PageFunctionCompiler((Metadata)metadata, 0));
        RowExpression projection = BenchmarkEqualsOperator.generateComplexComparisonProjection(10, 100);
        this.compiledProcessor = (PageProcessor)expressionCompiler.compilePageProcessor(Optional.empty(), (List)ImmutableList.of((Object)projection)).get();
    }

    private static RowExpression generateComplexComparisonProjection(int fieldsCount, int comparisonsCount) {
        Preconditions.checkArgument((fieldsCount > 0 ? 1 : 0) != 0, (Object)"fieldsCount must be greater than zero");
        Preconditions.checkArgument((comparisonsCount > 0 ? 1 : 0) != 0, (Object)"comparisonsCount must be greater than zero");
        if (comparisonsCount == 1) {
            return BenchmarkEqualsOperator.createComparison(0, 0);
        }
        return BenchmarkEqualsOperator.createConjunction(BenchmarkEqualsOperator.createComparison(0, comparisonsCount % fieldsCount), BenchmarkEqualsOperator.generateComplexComparisonProjection(fieldsCount, comparisonsCount - 1));
    }

    private static RowExpression createConjunction(RowExpression left, RowExpression right) {
        return Expressions.call((Signature)Signature.internalScalarFunction((String)"OR", (TypeSignature)BooleanType.BOOLEAN.getTypeSignature(), (TypeSignature[])new TypeSignature[]{BooleanType.BOOLEAN.getTypeSignature(), BooleanType.BOOLEAN.getTypeSignature()}), (Type)BooleanType.BOOLEAN, (RowExpression[])new RowExpression[]{left, right});
    }

    private static RowExpression createComparison(int leftField, int rightField) {
        return Expressions.call((Signature)Signature.internalOperator((OperatorType)OperatorType.EQUAL, (TypeSignature)BooleanType.BOOLEAN.getTypeSignature(), (TypeSignature[])new TypeSignature[]{BigintType.BIGINT.getTypeSignature(), BigintType.BIGINT.getTypeSignature()}), (Type)BooleanType.BOOLEAN, (RowExpression[])new RowExpression[]{Expressions.field((int)leftField, (Type)BigintType.BIGINT), Expressions.field((int)rightField, (Type)BigintType.BIGINT)});
    }

    @Benchmark
    public List<Page> processPage(BenchmarkData data) {
        ArrayList<Page> output = new ArrayList<Page>();
        PageProcessorOutput pageProcessorOutput = this.compiledProcessor.process(SESSION, SIGNAL, data.page);
        while (pageProcessorOutput.hasNext()) {
            pageProcessorOutput.next().ifPresent(output::add);
        }
        return output;
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + BenchmarkEqualsOperator.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        Page page;

        @Setup
        public void setup() {
            ImmutableList types = ImmutableList.copyOf((Iterable)Iterables.limit((Iterable)Iterables.cycle((Object[])new BigintType[]{BigintType.BIGINT}), (int)10));
            ThreadLocalRandom random = ThreadLocalRandom.current();
            PageBuilder pageBuilder = new PageBuilder((List)types);
            while (!pageBuilder.isFull()) {
                pageBuilder.declarePosition();
                for (int channel = 0; channel < 10; ++channel) {
                    BlockBuilder blockBuilder = pageBuilder.getBlockBuilder(channel);
                    if (random.nextDouble() < 0.05) {
                        blockBuilder.appendNull();
                        continue;
                    }
                    BigintType.BIGINT.writeLong(blockBuilder, random.nextLong());
                }
            }
            this.page = pageBuilder.build();
        }
    }
}

