/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.operator.DriverYieldSignal;
import com.facebook.presto.operator.project.PageProcessor;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.type.ArrayType;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.sql.gen.ExpressionCompiler;
import com.facebook.presto.sql.gen.PageFunctionCompiler;
import com.facebook.presto.sql.relational.CallExpression;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.testing.TestingConnectorSession;
import com.facebook.presto.type.JsonType;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.DynamicSliceOutput;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;
import org.openjdk.jmh.runner.options.WarmupMode;
import org.testng.annotations.Test;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Fork(value=10)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkJsonToArrayCast {
    private static final int POSITION_COUNT = 100000;
    private static final int ARRAY_SIZE = 20;

    @Benchmark
    @OperationsPerInvocation(value=100000)
    public List<Optional<Page>> benchmark(BenchmarkData data) {
        return ImmutableList.copyOf((Iterator)data.getPageProcessor().process(TestingConnectorSession.SESSION, new DriverYieldSignal(), data.getPage()));
    }

    @Test
    public void verify() {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        new BenchmarkJsonToArrayCast().benchmark(data);
    }

    public static void main(String[] args) throws Throwable {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        new BenchmarkJsonToArrayCast().benchmark(data);
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + BenchmarkJsonToArrayCast.class.getSimpleName() + ".*").warmupMode(WarmupMode.BULK_INDI).build();
        new Runner(options).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        @Param(value={"BIGINT", "DOUBLE", "VARCHAR"})
        private String valueTypeName = "BIGINT";
        private Page page;
        private PageProcessor pageProcessor;

        @Setup
        public void setup() {
            BigintType elementType;
            switch (this.valueTypeName) {
                case "BIGINT": {
                    elementType = BigintType.BIGINT;
                    break;
                }
                case "DOUBLE": {
                    elementType = DoubleType.DOUBLE;
                    break;
                }
                case "VARCHAR": {
                    elementType = VarcharType.VARCHAR;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            Signature signature = new Signature("$operator$CAST", FunctionKind.SCALAR, new ArrayType((Type)elementType).getTypeSignature(), new TypeSignature[]{JsonType.JSON.getTypeSignature()});
            ImmutableList projections = ImmutableList.of((Object)new CallExpression(signature, (Type)new ArrayType((Type)elementType), (List)ImmutableList.of((Object)Expressions.field((int)0, (Type)JsonType.JSON))));
            MetadataManager metadata = MetadataManager.createTestMetadataManager();
            this.pageProcessor = (PageProcessor)new ExpressionCompiler((Metadata)metadata, new PageFunctionCompiler((Metadata)metadata, 0)).compilePageProcessor(Optional.empty(), (List)projections).get();
            this.page = new Page(new Block[]{BenchmarkData.createChannel(100000, 20, (Type)elementType)});
        }

        private static Block createChannel(int positionCount, int mapSize, Type elementType) {
            BlockBuilder blockBuilder = JsonType.JSON.createBlockBuilder(null, positionCount);
            for (int position = 0; position < positionCount; ++position) {
                DynamicSliceOutput jsonSlice = new DynamicSliceOutput(20 * mapSize);
                jsonSlice.appendByte(91);
                for (int i = 0; i < mapSize; ++i) {
                    if (i != 0) {
                        jsonSlice.appendByte(44);
                    }
                    String value = BenchmarkData.generateRandomJsonValue(elementType);
                    jsonSlice.appendBytes(value.getBytes());
                }
                jsonSlice.appendByte(93);
                JsonType.JSON.writeSlice(blockBuilder, jsonSlice.slice());
            }
            return blockBuilder.build();
        }

        private static String generateRandomJsonValue(Type valueType) {
            if (valueType == BigintType.BIGINT) {
                return Long.toString(ThreadLocalRandom.current().nextLong());
            }
            if (valueType == DoubleType.DOUBLE) {
                return Double.toString(ThreadLocalRandom.current().nextDouble());
            }
            if (valueType == VarcharType.VARCHAR) {
                String characters = "ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890";
                int length = ThreadLocalRandom.current().nextInt(10) + 1;
                StringBuilder builder = new StringBuilder(length + 2);
                builder.append('\"');
                for (int i = 0; i < length; ++i) {
                    builder.append(characters.charAt(ThreadLocalRandom.current().nextInt(characters.length())));
                }
                builder.append('\"');
                return builder.toString();
            }
            throw new UnsupportedOperationException();
        }

        public PageProcessor getPageProcessor() {
            return this.pageProcessor;
        }

        public Page getPage() {
            return this.page;
        }
    }
}

