/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.operator.DriverYieldSignal;
import com.facebook.presto.operator.project.PageProcessor;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.MapType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.TypeUtils;
import com.facebook.presto.sql.gen.ExpressionCompiler;
import com.facebook.presto.sql.gen.PageFunctionCompiler;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.LambdaDefinitionExpression;
import com.facebook.presto.sql.relational.RowExpression;
import com.facebook.presto.sql.relational.VariableReferenceExpression;
import com.facebook.presto.testing.TestingConnectorSession;
import com.facebook.presto.util.StructuralTestUtil;
import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;
import org.openjdk.jmh.runner.options.WarmupMode;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Fork(value=2)
@Warmup(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkTransformKey {
    private static final int POSITIONS = 100000;
    private static final int NUM_TYPES = 2;

    @Benchmark
    @OperationsPerInvocation(value=200000)
    public List<Optional<Page>> benchmark(BenchmarkData data) {
        return ImmutableList.copyOf((Iterator)data.getPageProcessor().process(TestingConnectorSession.SESSION, new DriverYieldSignal(), data.getPage()));
    }

    public static void main(String[] args) throws Throwable {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        new BenchmarkTransformKey().benchmark(data);
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).warmupMode(WarmupMode.BULK).include(".*" + BenchmarkTransformKey.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        @Param(value={"DOUBLE", "BIGINT"})
        private String type = "DOUBLE";
        private String name = "transform_keys";
        private Page page;
        private PageProcessor pageProcessor;

        @Setup
        public void setup() {
            Number increment;
            BigintType elementType;
            MetadataManager metadata = MetadataManager.createTestMetadataManager();
            ExpressionCompiler compiler = new ExpressionCompiler((Metadata)metadata, new PageFunctionCompiler((Metadata)metadata, 0));
            ImmutableList.Builder projectionsBuilder = ImmutableList.builder();
            switch (this.type) {
                case "BIGINT": {
                    elementType = BigintType.BIGINT;
                    increment = 1L;
                    break;
                }
                case "DOUBLE": {
                    elementType = DoubleType.DOUBLE;
                    increment = 1.0;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            MapType mapType = StructuralTestUtil.mapType((Type)elementType, (Type)elementType);
            Signature signature = new Signature(this.name, FunctionKind.SCALAR, mapType.getTypeSignature(), new TypeSignature[]{mapType.getTypeSignature(), TypeSignature.parseTypeSignature((String)String.format("function(%s, %s, %s)", this.type, this.type, this.type))});
            Signature add = new Signature("$operator$" + OperatorType.ADD.name(), FunctionKind.SCALAR, elementType.getTypeSignature(), new TypeSignature[]{elementType.getTypeSignature(), elementType.getTypeSignature()});
            projectionsBuilder.add((Object)Expressions.call((Signature)signature, (Type)mapType, (List)ImmutableList.of((Object)Expressions.field((int)0, (Type)mapType), (Object)new LambdaDefinitionExpression((List)ImmutableList.of((Object)elementType, (Object)elementType), (List)ImmutableList.of((Object)"x", (Object)"y"), (RowExpression)Expressions.call((Signature)add, (Type)elementType, (List)ImmutableList.of((Object)new VariableReferenceExpression("x", (Type)elementType), (Object)Expressions.constant((Object)increment, (Type)elementType)))))));
            Block block = BenchmarkData.createChannel(100000, mapType, (Type)elementType);
            ImmutableList projections = projectionsBuilder.build();
            this.pageProcessor = (PageProcessor)compiler.compilePageProcessor(Optional.empty(), (List)projections).get();
            this.page = new Page(new Block[]{block});
        }

        private static Block createChannel(int positionCount, MapType mapType, Type elementType) {
            BlockBuilder mapBlockBuilder = mapType.createBlockBuilder(null, 1);
            BlockBuilder singleMapBlockWriter = mapBlockBuilder.beginBlockEntry();
            for (int position = 0; position < positionCount; ++position) {
                Number value;
                if (elementType.equals(BigintType.BIGINT)) {
                    value = ThreadLocalRandom.current().nextLong();
                } else if (elementType.equals(DoubleType.DOUBLE)) {
                    value = ThreadLocalRandom.current().nextDouble();
                } else {
                    throw new UnsupportedOperationException();
                }
                TypeUtils.writeNativeValue((Type)elementType, (BlockBuilder)singleMapBlockWriter, (Object)position);
                TypeUtils.writeNativeValue((Type)elementType, (BlockBuilder)singleMapBlockWriter, (Object)value);
            }
            mapBlockBuilder.closeEntry();
            return mapBlockBuilder.build();
        }

        public PageProcessor getPageProcessor() {
            return this.pageProcessor;
        }

        public Page getPage() {
            return this.page;
        }
    }
}

