/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.connector.ConnectorId;
import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.FunctionListBuilder;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.metadata.SqlFunction;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.DriverYieldSignal;
import com.facebook.presto.operator.FilterAndProjectOperator;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.ScanFilterAndProjectOperator;
import com.facebook.presto.operator.SourceOperator;
import com.facebook.presto.operator.SourceOperatorFactory;
import com.facebook.presto.operator.project.InterpretedPageFilter;
import com.facebook.presto.operator.project.InterpretedPageProjection;
import com.facebook.presto.operator.project.PageFilter;
import com.facebook.presto.operator.project.PageProcessor;
import com.facebook.presto.operator.project.PageProcessorOutput;
import com.facebook.presto.operator.project.PageProjection;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.FixedPageSource;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.InMemoryRecordSet;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.RecordPageSource;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DateTimeEncoding;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.TimeZoneKey;
import com.facebook.presto.spi.type.TimestampWithTimeZoneType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.split.PageSourceProvider;
import com.facebook.presto.sql.ExpressionUtils;
import com.facebook.presto.sql.ParsingUtil;
import com.facebook.presto.sql.analyzer.ExpressionAnalysis;
import com.facebook.presto.sql.analyzer.ExpressionAnalyzer;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.gen.ExpressionCompiler;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolToInputRewriter;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.iterative.rule.CanonicalizeExpressionRewriter;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.RowExpression;
import com.facebook.presto.sql.relational.SqlToRowExpressionTranslator;
import com.facebook.presto.sql.tree.BooleanLiteral;
import com.facebook.presto.sql.tree.Cast;
import com.facebook.presto.sql.tree.DefaultTraversalVisitor;
import com.facebook.presto.sql.tree.DereferenceExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeRef;
import com.facebook.presto.sql.tree.SymbolReference;
import com.facebook.presto.testing.LocalQueryRunner;
import com.facebook.presto.testing.MaterializedResult;
import com.facebook.presto.testing.MaterializedRow;
import com.facebook.presto.testing.TestingTaskContext;
import com.facebook.presto.testing.TestingTransactionHandle;
import com.facebook.presto.type.TypeRegistry;
import com.facebook.presto.type.UnknownType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.airlift.concurrent.Threads;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.testing.Assertions;
import io.airlift.units.DataSize;
import java.io.Closeable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.openjdk.jol.info.ClassLayout;
import org.testng.Assert;

public final class FunctionAssertions
implements Closeable {
    private static final ExecutorService EXECUTOR = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)"test-%s"));
    private static final ScheduledExecutorService SCHEDULED_EXECUTOR = Executors.newScheduledThreadPool(2, Threads.daemonThreadsNamed((String)"test-scheduledExecutor-%s"));
    private static final SqlParser SQL_PARSER = new SqlParser();
    private static final Page SOURCE_PAGE = new Page(new Block[]{BlockAssertions.createLongsBlock(1234L), BlockAssertions.createStringsBlock("hello"), BlockAssertions.createDoublesBlock(12.34), BlockAssertions.createBooleansBlock(true), BlockAssertions.createLongsBlock(new DateTime(2001, 8, 22, 3, 4, 5, 321, DateTimeZone.UTC).getMillis()), BlockAssertions.createStringsBlock("%el%"), BlockAssertions.createStringsBlock(new String[]{null}), BlockAssertions.createTimestampsWithTimezoneBlock(DateTimeEncoding.packDateTimeWithZone((long)new DateTime(1970, 1, 1, 0, 1, 0, 999, DateTimeZone.UTC).getMillis(), (TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)"Z"))), BlockAssertions.createSlicesBlock(Slices.wrappedBuffer((byte[])new byte[]{-85})), BlockAssertions.createIntsBlock(1234)});
    private static final Page ZERO_CHANNEL_PAGE = new Page(1, new Block[0]);
    private static final Map<Integer, Type> INPUT_TYPES = ImmutableMap.builder().put((Object)0, (Object)BigintType.BIGINT).put((Object)1, (Object)VarcharType.VARCHAR).put((Object)2, (Object)DoubleType.DOUBLE).put((Object)3, (Object)BooleanType.BOOLEAN).put((Object)4, (Object)BigintType.BIGINT).put((Object)5, (Object)VarcharType.VARCHAR).put((Object)6, (Object)VarcharType.VARCHAR).put((Object)7, (Object)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE).put((Object)8, (Object)VarbinaryType.VARBINARY).put((Object)9, (Object)IntegerType.INTEGER).build();
    private static final Map<Symbol, Integer> INPUT_MAPPING = ImmutableMap.builder().put((Object)new Symbol("bound_long"), (Object)0).put((Object)new Symbol("bound_string"), (Object)1).put((Object)new Symbol("bound_double"), (Object)2).put((Object)new Symbol("bound_boolean"), (Object)3).put((Object)new Symbol("bound_timestamp"), (Object)4).put((Object)new Symbol("bound_pattern"), (Object)5).put((Object)new Symbol("bound_null_string"), (Object)6).put((Object)new Symbol("bound_timestamp_with_timezone"), (Object)7).put((Object)new Symbol("bound_binary_literal"), (Object)8).put((Object)new Symbol("bound_integer"), (Object)9).build();
    private static final TypeProvider SYMBOL_TYPES = TypeProvider.copyOf((Map)ImmutableMap.builder().put((Object)new Symbol("bound_long"), (Object)BigintType.BIGINT).put((Object)new Symbol("bound_string"), (Object)VarcharType.VARCHAR).put((Object)new Symbol("bound_double"), (Object)DoubleType.DOUBLE).put((Object)new Symbol("bound_boolean"), (Object)BooleanType.BOOLEAN).put((Object)new Symbol("bound_timestamp"), (Object)BigintType.BIGINT).put((Object)new Symbol("bound_pattern"), (Object)VarcharType.VARCHAR).put((Object)new Symbol("bound_null_string"), (Object)VarcharType.VARCHAR).put((Object)new Symbol("bound_timestamp_with_timezone"), (Object)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE).put((Object)new Symbol("bound_binary_literal"), (Object)VarbinaryType.VARBINARY).put((Object)new Symbol("bound_integer"), (Object)IntegerType.INTEGER).build());
    private static final PageSourceProvider PAGE_SOURCE_PROVIDER = new TestPageSourceProvider();
    private static final PlanNodeId SOURCE_ID = new PlanNodeId("scan");
    private final Session session;
    private final LocalQueryRunner runner;
    private final Metadata metadata;
    private final ExpressionCompiler compiler;

    public FunctionAssertions() {
        this(SessionTestUtils.TEST_SESSION);
    }

    public FunctionAssertions(Session session) {
        this(session, new FeaturesConfig());
    }

    public FunctionAssertions(Session session, FeaturesConfig featuresConfig) {
        this.session = Objects.requireNonNull(session, "session is null");
        this.runner = new LocalQueryRunner(session, featuresConfig);
        this.metadata = this.runner.getMetadata();
        this.compiler = this.runner.getExpressionCompiler();
    }

    public TypeRegistry getTypeRegistry() {
        return this.runner.getTypeManager();
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public FunctionAssertions addFunctions(List<? extends SqlFunction> functionInfos) {
        this.metadata.addFunctions(functionInfos);
        return this;
    }

    public FunctionAssertions addScalarFunctions(Class<?> clazz) {
        this.metadata.addFunctions(new FunctionListBuilder().scalars(clazz).getFunctions());
        return this;
    }

    public void assertFunction(String projection, Type expectedType, Object expected) {
        if (expected instanceof Slice) {
            expected = ((Slice)expected).toStringUtf8();
        }
        Object actual = this.selectSingleValue(projection, expectedType, this.compiler);
        Assert.assertEquals((Object)actual, (Object)expected);
    }

    public void assertFunctionString(String projection, Type expectedType, String expected) {
        Object actual = this.selectSingleValue(projection, expectedType, this.compiler);
        Assert.assertEquals((String)actual.toString(), (String)expected);
    }

    public void tryEvaluate(String expression, Type expectedType) {
        this.tryEvaluate(expression, expectedType, this.session);
    }

    private void tryEvaluate(String expression, Type expectedType, Session session) {
        this.selectUniqueValue(expression, expectedType, session, this.compiler);
    }

    public void tryEvaluateWithAll(String expression, Type expectedType) {
        this.tryEvaluateWithAll(expression, expectedType, this.session);
    }

    public void tryEvaluateWithAll(String expression, Type expectedType, Session session) {
        this.executeProjectionWithAll(expression, expectedType, session, this.compiler);
    }

    public void executeProjectionWithFullEngine(String projection) {
        MaterializedResult result = this.runner.execute("SELECT " + projection);
    }

    private Object selectSingleValue(String projection, Type expectedType, ExpressionCompiler compiler) {
        return this.selectUniqueValue(projection, expectedType, this.session, compiler);
    }

    private Object selectUniqueValue(String projection, Type expectedType, Session session, ExpressionCompiler compiler) {
        List<Object> results = this.executeProjectionWithAll(projection, expectedType, session, compiler);
        HashSet<Object> resultSet = new HashSet<Object>(results);
        Assert.assertTrue((resultSet.size() == 1 ? 1 : 0) != 0, (String)("Expected only one result unique result, but got " + resultSet));
        return Iterables.getOnlyElement(resultSet);
    }

    @Deprecated
    public void assertInvalidFunction(String projection) {
        try {
            this.evaluateInvalid(projection);
            Assert.fail((String)"Expected to fail");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void assertInvalidFunction(String projection, StandardErrorCode errorCode, String messagePattern) {
        try {
            this.evaluateInvalid(projection);
            Assert.fail((String)("Expected to throw a PrestoException with message matching " + messagePattern));
        }
        catch (PrestoException e) {
            try {
                Assert.assertEquals((Object)e.getErrorCode(), (Object)errorCode.toErrorCode());
                Assert.assertTrue((e.getMessage().equals(messagePattern) || e.getMessage().matches(messagePattern) ? 1 : 0) != 0, (String)String.format("Error message [%s] doesn't match [%s]", e.getMessage(), messagePattern));
            }
            catch (Throwable failure) {
                failure.addSuppressed(e);
                throw failure;
            }
        }
    }

    public void assertInvalidFunction(String projection, String messagePattern) {
        this.assertInvalidFunction(projection, StandardErrorCode.INVALID_FUNCTION_ARGUMENT, messagePattern);
    }

    public void assertInvalidFunction(String projection, SemanticErrorCode expectedErrorCode) {
        try {
            this.evaluateInvalid(projection);
            Assert.fail((String)String.format("Expected to throw %s exception", expectedErrorCode));
        }
        catch (SemanticException e) {
            try {
                Assert.assertEquals((Object)e.getCode(), (Object)expectedErrorCode);
            }
            catch (Throwable failure) {
                failure.addSuppressed(e);
                throw failure;
            }
        }
    }

    public void assertInvalidFunction(String projection, SemanticErrorCode expectedErrorCode, String message) {
        try {
            this.evaluateInvalid(projection);
            Assert.fail((String)String.format("Expected to throw %s exception", expectedErrorCode));
        }
        catch (SemanticException e) {
            try {
                Assert.assertEquals((Object)e.getCode(), (Object)expectedErrorCode);
                Assert.assertEquals((String)e.getMessage(), (String)message);
            }
            catch (Throwable failure) {
                failure.addSuppressed(e);
                throw failure;
            }
        }
    }

    public void assertInvalidFunction(String projection, ErrorCodeSupplier expectedErrorCode) {
        try {
            this.evaluateInvalid(projection);
            Assert.fail((String)String.format("Expected to throw %s exception", expectedErrorCode.toErrorCode()));
        }
        catch (PrestoException e) {
            try {
                Assert.assertEquals((Object)e.getErrorCode(), (Object)expectedErrorCode.toErrorCode());
            }
            catch (Throwable failure) {
                failure.addSuppressed(e);
                throw failure;
            }
        }
    }

    public void assertNumericOverflow(String projection, String message) {
        try {
            this.evaluateInvalid(projection);
            Assert.fail((String)("Expected to throw an NUMERIC_VALUE_OUT_OF_RANGE exception with message " + message));
        }
        catch (PrestoException e) {
            try {
                Assert.assertEquals((Object)e.getErrorCode(), (Object)StandardErrorCode.NUMERIC_VALUE_OUT_OF_RANGE.toErrorCode());
                Assert.assertEquals((String)e.getMessage(), (String)message);
            }
            catch (Throwable failure) {
                failure.addSuppressed(e);
                throw failure;
            }
        }
    }

    public void assertInvalidCast(String projection) {
        try {
            this.evaluateInvalid(projection);
            Assert.fail((String)"Expected to throw an INVALID_CAST_ARGUMENT exception");
        }
        catch (PrestoException e) {
            try {
                Assert.assertEquals((Object)e.getErrorCode(), (Object)StandardErrorCode.INVALID_CAST_ARGUMENT.toErrorCode());
            }
            catch (Throwable failure) {
                failure.addSuppressed(e);
                throw failure;
            }
        }
    }

    public void assertInvalidCast(String projection, String message) {
        try {
            this.evaluateInvalid(projection);
            Assert.fail((String)"Expected to throw an INVALID_CAST_ARGUMENT exception");
        }
        catch (PrestoException e) {
            try {
                Assert.assertEquals((Object)e.getErrorCode(), (Object)StandardErrorCode.INVALID_CAST_ARGUMENT.toErrorCode());
                Assert.assertEquals((String)e.getMessage(), (String)message);
            }
            catch (Throwable failure) {
                failure.addSuppressed(e);
                throw failure;
            }
        }
    }

    private void evaluateInvalid(String projection) {
        this.selectSingleValue(projection, (Type)UnknownType.UNKNOWN, this.compiler);
    }

    public void assertCachedInstanceHasBoundedRetainedSize(String projection) {
        Objects.requireNonNull(projection, "projection is null");
        Expression projectionExpression = FunctionAssertions.createExpression(this.session, projection, this.metadata, SYMBOL_TYPES);
        RowExpression projectionRowExpression = this.toRowExpression(this.session, projectionExpression);
        PageProcessor processor = (PageProcessor)this.compiler.compilePageProcessor(Optional.empty(), (List)ImmutableList.of((Object)projectionRowExpression)).get();
        long maxRetainedSize = 0L;
        int maxIterationCount = 0;
        for (int iterationCount = 0; iterationCount < Math.max(1000, maxIterationCount * 4); ++iterationCount) {
            PageProcessorOutput output = processor.process(this.session.toConnectorSession(), new DriverYieldSignal(), SOURCE_PAGE);
            Iterators.getOnlyElement((Iterator)output);
            long retainedSize = processor.getProjections().stream().mapToLong(this::getRetainedSizeOfCachedInstance).sum();
            if (retainedSize > maxRetainedSize) {
                maxRetainedSize = retainedSize;
                maxIterationCount = iterationCount;
            }
            if (maxRetainedSize < 0x100000L) continue;
            Assert.fail((String)String.format("The retained size of cached instance of function invocation is likely unbounded: %s", projection));
        }
    }

    private long getRetainedSizeOfCachedInstance(PageProjection projection) {
        Field[] fields = projection.getClass().getDeclaredFields();
        long retainedSize = 0L;
        for (Field field : fields) {
            field.setAccessible(true);
            String fieldName = field.getName();
            if (!fieldName.startsWith("__cachedInstance")) continue;
            try {
                retainedSize += this.getRetainedSizeOf(field.get(projection));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return retainedSize;
    }

    private long getRetainedSizeOf(Object object) {
        Field[] fields;
        if (object instanceof PageBuilder) {
            return ((PageBuilder)object).getRetainedSizeInBytes();
        }
        if (object instanceof Block) {
            return ((Block)object).getRetainedSizeInBytes();
        }
        Class<?> type = object.getClass();
        if (type.isArray()) {
            if (type == int[].class) {
                return SizeOf.sizeOf((int[])((int[])object));
            }
            if (type == boolean[].class) {
                return SizeOf.sizeOf((boolean[])((boolean[])object));
            }
            if (type == byte[].class) {
                return SizeOf.sizeOf((byte[])((byte[])object));
            }
            if (type == long[].class) {
                return SizeOf.sizeOf((long[])((long[])object));
            }
            if (type == short[].class) {
                return SizeOf.sizeOf((short[])((short[])object));
            }
            if (type == Block[].class) {
                Object[] objects = (Object[])object;
                return Arrays.stream(objects).mapToLong(this::getRetainedSizeOf).sum();
            }
            throw new IllegalArgumentException(String.format("Unknown type encountered: %s", type));
        }
        long retainedSize = ClassLayout.parseClass(type).instanceSize();
        for (Field field : fields = type.getDeclaredFields()) {
            try {
                if (field.getType().isPrimitive() || Modifier.isStatic(field.getModifiers())) continue;
                field.setAccessible(true);
                retainedSize += this.getRetainedSizeOf(field.get(object));
            }
            catch (IllegalAccessException t) {
                throw new RuntimeException(t);
            }
        }
        return retainedSize;
    }

    private List<Object> executeProjectionWithAll(String projection, Type expectedType, Session session, ExpressionCompiler compiler) {
        Objects.requireNonNull(projection, "projection is null");
        Expression projectionExpression = FunctionAssertions.createExpression(session, projection, this.metadata, SYMBOL_TYPES);
        RowExpression projectionRowExpression = this.toRowExpression(session, projectionExpression);
        ArrayList<Object> results = new ArrayList<Object>();
        if (!FunctionAssertions.needsBoundValue(projectionExpression)) {
            MaterializedResult result = this.runner.execute("SELECT " + projection);
            FunctionAssertions.assertType(result.getTypes(), expectedType);
            Assert.assertEquals((int)result.getTypes().size(), (int)1);
            Assert.assertEquals((int)result.getMaterializedRows().size(), (int)1);
            Object queryResult = ((MaterializedRow)Iterables.getOnlyElement((Iterable)result.getMaterializedRows())).getField(0);
            results.add(queryResult);
        }
        OperatorFactory operatorFactory = FunctionAssertions.compileFilterProject(Optional.empty(), projectionRowExpression, compiler);
        Object directOperatorValue = this.selectSingleValue(operatorFactory, expectedType, session);
        results.add(directOperatorValue);
        Operator interpretedFilterProject = this.interpretedFilterProject(Optional.empty(), projectionExpression, expectedType, session);
        Object interpretedValue = this.selectSingleValue(interpretedFilterProject, expectedType);
        results.add(interpretedValue);
        SourceOperatorFactory scanProjectOperatorFactory = FunctionAssertions.compileScanFilterProject(Optional.empty(), projectionRowExpression, compiler);
        Object scanOperatorValue = this.selectSingleValue(scanProjectOperatorFactory, expectedType, FunctionAssertions.createNormalSplit(), session);
        results.add(scanOperatorValue);
        Object recordValue = this.selectSingleValue(scanProjectOperatorFactory, expectedType, FunctionAssertions.createRecordSetSplit(), session);
        results.add(recordValue);
        if (!FunctionAssertions.needsBoundValue(projectionExpression)) {
            MaterializedResult result = this.runner.execute("SELECT " + projection);
            FunctionAssertions.assertType(result.getTypes(), expectedType);
            Assert.assertEquals((int)result.getTypes().size(), (int)1);
            Assert.assertEquals((int)result.getMaterializedRows().size(), (int)1);
            Object queryResult = ((MaterializedRow)Iterables.getOnlyElement((Iterable)result.getMaterializedRows())).getField(0);
            results.add(queryResult);
        }
        Assert.assertEquals((Object)projectionRowExpression.getType(), (Object)expectedType);
        return results;
    }

    private RowExpression toRowExpression(Session session, Expression projectionExpression) {
        Expression translatedProjection = new SymbolToInputRewriter(INPUT_MAPPING).rewrite(projectionExpression);
        Map expressionTypes = ExpressionAnalyzer.getExpressionTypesFromInput((Session)session, (Metadata)this.metadata, (SqlParser)SQL_PARSER, INPUT_TYPES, (Iterable)ImmutableList.of((Object)translatedProjection), (List)ImmutableList.of());
        return this.toRowExpression(translatedProjection, expressionTypes);
    }

    private Object selectSingleValue(OperatorFactory operatorFactory, Type type, Session session) {
        Operator operator = operatorFactory.createOperator(FunctionAssertions.createDriverContext(session));
        return this.selectSingleValue(operator, type);
    }

    private Object selectSingleValue(SourceOperatorFactory operatorFactory, Type type, Split split, Session session) {
        SourceOperator operator = operatorFactory.createOperator(FunctionAssertions.createDriverContext(session));
        operator.addSplit(split);
        operator.noMoreSplits();
        return this.selectSingleValue((Operator)operator, type);
    }

    private Object selectSingleValue(Operator operator, Type type) {
        Page output = FunctionAssertions.getAtMostOnePage(operator, SOURCE_PAGE);
        Assert.assertNotNull((Object)output);
        Assert.assertEquals((int)output.getPositionCount(), (int)1);
        Assert.assertEquals((int)output.getChannelCount(), (int)1);
        Block block = output.getBlock(0);
        Assert.assertEquals((int)block.getPositionCount(), (int)1);
        return type.getObjectValue(this.session.toConnectorSession(), block, 0);
    }

    public void assertFilter(String filter, boolean expected, boolean withNoInputColumns) {
        this.assertFilter(filter, expected, withNoInputColumns, this.compiler);
    }

    private void assertFilter(String filter, boolean expected, boolean withNoInputColumns, ExpressionCompiler compiler) {
        List<Boolean> results = this.executeFilterWithAll(filter, SessionTestUtils.TEST_SESSION, withNoInputColumns, compiler);
        HashSet<Boolean> resultSet = new HashSet<Boolean>(results);
        Assert.assertTrue((resultSet.size() == 1 ? 1 : 0) != 0, (String)("Expected only [" + expected + "] result unique result, but got " + resultSet));
        Assert.assertEquals((boolean)((Boolean)Iterables.getOnlyElement(resultSet)), (boolean)expected);
    }

    private List<Boolean> executeFilterWithAll(String filter, Session session, boolean executeWithNoInputColumns, ExpressionCompiler compiler) {
        Objects.requireNonNull(filter, "filter is null");
        Expression filterExpression = FunctionAssertions.createExpression(session, filter, this.metadata, SYMBOL_TYPES);
        RowExpression filterRowExpression = this.toRowExpression(session, filterExpression);
        ArrayList<Boolean> results = new ArrayList<Boolean>();
        OperatorFactory operatorFactory = FunctionAssertions.compileFilterProject(Optional.of(filterRowExpression), (RowExpression)Expressions.constant((Object)true, (Type)BooleanType.BOOLEAN), compiler);
        results.add(FunctionAssertions.executeFilter(operatorFactory, session));
        if (executeWithNoInputColumns) {
            operatorFactory = FunctionAssertions.compileFilterWithNoInputColumns(filterRowExpression, compiler);
            results.add(FunctionAssertions.executeFilterWithNoInputColumns(operatorFactory, session));
        }
        boolean interpretedValue = FunctionAssertions.executeFilter(this.interpretedFilterProject(Optional.of(filterExpression), (Expression)BooleanLiteral.TRUE_LITERAL, (Type)BooleanType.BOOLEAN, session));
        results.add(interpretedValue);
        SourceOperatorFactory scanProjectOperatorFactory = FunctionAssertions.compileScanFilterProject(Optional.of(filterRowExpression), (RowExpression)Expressions.constant((Object)true, (Type)BooleanType.BOOLEAN), compiler);
        boolean scanOperatorValue = FunctionAssertions.executeFilter(scanProjectOperatorFactory, FunctionAssertions.createNormalSplit(), session);
        results.add(scanOperatorValue);
        boolean recordValue = FunctionAssertions.executeFilter(scanProjectOperatorFactory, FunctionAssertions.createRecordSetSplit(), session);
        results.add(recordValue);
        if (!FunctionAssertions.needsBoundValue(filterExpression)) {
            Boolean queryResult;
            MaterializedResult result = this.runner.execute("SELECT TRUE WHERE " + filter);
            Assert.assertEquals((int)result.getTypes().size(), (int)1);
            if (result.getMaterializedRows().isEmpty()) {
                queryResult = false;
            } else {
                Assert.assertEquals((int)result.getMaterializedRows().size(), (int)1);
                queryResult = (Boolean)((MaterializedRow)Iterables.getOnlyElement((Iterable)result.getMaterializedRows())).getField(0);
            }
            results.add(queryResult);
        }
        return results;
    }

    public static Expression createExpression(String expression, Metadata metadata, TypeProvider symbolTypes) {
        return FunctionAssertions.createExpression(SessionTestUtils.TEST_SESSION, expression, metadata, symbolTypes);
    }

    public static Expression createExpression(Session session, String expression, Metadata metadata, TypeProvider symbolTypes) {
        Expression parsedExpression = SQL_PARSER.createExpression(expression, ParsingUtil.createParsingOptions((Session)session));
        parsedExpression = ExpressionUtils.rewriteIdentifiersToSymbolReferences((Expression)parsedExpression);
        final ExpressionAnalysis analysis = ExpressionAnalyzer.analyzeExpressionsWithSymbols((Session)session, (Metadata)metadata, (SqlParser)SQL_PARSER, (TypeProvider)symbolTypes, (Iterable)ImmutableList.of((Object)parsedExpression), (List)ImmutableList.of(), (boolean)false);
        Expression rewrittenExpression = ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ExpressionRewriter<Void>(){

            public Expression rewriteExpression(Expression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                Expression rewrittenExpression = treeRewriter.defaultRewrite(node, (Object)context);
                Type coercion = analysis.getCoercion(node);
                if (coercion != null) {
                    rewrittenExpression = new Cast(rewrittenExpression, coercion.getTypeSignature().toString(), false, analysis.isTypeOnlyCoercion(node));
                }
                return rewrittenExpression;
            }

            public Expression rewriteDereferenceExpression(DereferenceExpression node, Void context, ExpressionTreeRewriter<Void> treeRewriter) {
                if (analysis.isColumnReference((Expression)node)) {
                    return this.rewriteExpression((Expression)node, context, treeRewriter);
                }
                Expression rewrittenExpression = treeRewriter.defaultRewrite((Expression)node, (Object)context);
                Type coercion = analysis.getCoercion((Expression)node);
                if (coercion != null) {
                    rewrittenExpression = new Cast(rewrittenExpression, coercion.getTypeSignature().toString());
                }
                return rewrittenExpression;
            }
        }, (Expression)parsedExpression);
        return CanonicalizeExpressionRewriter.canonicalizeExpression((Expression)rewrittenExpression);
    }

    private static boolean executeFilterWithNoInputColumns(OperatorFactory operatorFactory, Session session) {
        return FunctionAssertions.executeFilterWithNoInputColumns(operatorFactory.createOperator(FunctionAssertions.createDriverContext(session)));
    }

    private static boolean executeFilter(OperatorFactory operatorFactory, Session session) {
        return FunctionAssertions.executeFilter(operatorFactory.createOperator(FunctionAssertions.createDriverContext(session)));
    }

    private static boolean executeFilter(SourceOperatorFactory operatorFactory, Split split, Session session) {
        SourceOperator operator = operatorFactory.createOperator(FunctionAssertions.createDriverContext(session));
        operator.addSplit(split);
        operator.noMoreSplits();
        return FunctionAssertions.executeFilter((Operator)operator);
    }

    private static boolean executeFilter(Operator operator) {
        boolean value;
        Page page = FunctionAssertions.getAtMostOnePage(operator, SOURCE_PAGE);
        if (page != null) {
            Assert.assertEquals((int)page.getPositionCount(), (int)1);
            Assert.assertEquals((int)page.getChannelCount(), (int)1);
            Assert.assertTrue((boolean)BooleanType.BOOLEAN.getBoolean(page.getBlock(0), 0));
            value = true;
        } else {
            value = false;
        }
        return value;
    }

    private static boolean executeFilterWithNoInputColumns(Operator operator) {
        boolean value;
        Page page = FunctionAssertions.getAtMostOnePage(operator, ZERO_CHANNEL_PAGE);
        if (page != null) {
            Assert.assertEquals((int)page.getPositionCount(), (int)1);
            Assert.assertEquals((int)page.getChannelCount(), (int)0);
            value = true;
        } else {
            value = false;
        }
        return value;
    }

    private static boolean needsBoundValue(Expression projectionExpression) {
        final AtomicBoolean hasSymbolReferences = new AtomicBoolean();
        new DefaultTraversalVisitor<Void, Void>(){

            protected Void visitSymbolReference(SymbolReference node, Void context) {
                hasSymbolReferences.set(true);
                return null;
            }
        }.process((Node)projectionExpression, null);
        return hasSymbolReferences.get();
    }

    private Operator interpretedFilterProject(Optional<Expression> filter, Expression projection, Type expectedType, Session session) {
        Optional<PageFilter> pageFilter = filter.map(expression -> new InterpretedPageFilter(expression, SYMBOL_TYPES, INPUT_MAPPING, this.metadata, SQL_PARSER, session));
        InterpretedPageProjection pageProjection = new InterpretedPageProjection(projection, SYMBOL_TYPES, INPUT_MAPPING, this.metadata, SQL_PARSER, session);
        Assert.assertEquals((Object)pageProjection.getType(), (Object)expectedType);
        PageProcessor processor = new PageProcessor(pageFilter, (List)ImmutableList.of((Object)pageProjection));
        FilterAndProjectOperator.FilterAndProjectOperatorFactory operatorFactory = new FilterAndProjectOperator.FilterAndProjectOperatorFactory(0, new PlanNodeId("test"), () -> processor, (List)ImmutableList.of((Object)pageProjection.getType()), new DataSize(0.0, DataSize.Unit.BYTE), 0);
        return operatorFactory.createOperator(FunctionAssertions.createDriverContext(session));
    }

    private static OperatorFactory compileFilterWithNoInputColumns(RowExpression filter, ExpressionCompiler compiler) {
        try {
            Supplier processor = compiler.compilePageProcessor(Optional.of(filter), (List)ImmutableList.of());
            return new FilterAndProjectOperator.FilterAndProjectOperatorFactory(0, new PlanNodeId("test"), processor, (List)ImmutableList.of(), new DataSize(0.0, DataSize.Unit.BYTE), 0);
        }
        catch (Throwable e) {
            if (e instanceof UncheckedExecutionException) {
                e = e.getCause();
            }
            throw new RuntimeException("Error compiling " + filter + ": " + e.getMessage(), e);
        }
    }

    private static OperatorFactory compileFilterProject(Optional<RowExpression> filter, RowExpression projection, ExpressionCompiler compiler) {
        try {
            Supplier processor = compiler.compilePageProcessor(filter, (List)ImmutableList.of((Object)projection));
            return new FilterAndProjectOperator.FilterAndProjectOperatorFactory(0, new PlanNodeId("test"), processor, (List)ImmutableList.of((Object)projection.getType()), new DataSize(0.0, DataSize.Unit.BYTE), 0);
        }
        catch (Throwable e) {
            if (e instanceof UncheckedExecutionException) {
                e = e.getCause();
            }
            throw new RuntimeException("Error compiling " + projection + ": " + e.getMessage(), e);
        }
    }

    private static SourceOperatorFactory compileScanFilterProject(Optional<RowExpression> filter, RowExpression projection, ExpressionCompiler compiler) {
        try {
            Supplier cursorProcessor = compiler.compileCursorProcessor(filter, (List)ImmutableList.of((Object)projection), (Object)SOURCE_ID);
            Supplier pageProcessor = compiler.compilePageProcessor(filter, (List)ImmutableList.of((Object)projection));
            return new ScanFilterAndProjectOperator.ScanFilterAndProjectOperatorFactory(0, new PlanNodeId("test"), SOURCE_ID, PAGE_SOURCE_PROVIDER, cursorProcessor, pageProcessor, (Iterable)ImmutableList.of(), (List)ImmutableList.of((Object)projection.getType()), new DataSize(0.0, DataSize.Unit.BYTE), 0);
        }
        catch (Throwable e) {
            if (e instanceof UncheckedExecutionException) {
                e = e.getCause();
            }
            throw new RuntimeException("Error compiling filter " + filter + ": " + e.getMessage(), e);
        }
    }

    private RowExpression toRowExpression(Expression projection, Map<NodeRef<Expression>, Type> expressionTypes) {
        return SqlToRowExpressionTranslator.translate((Expression)projection, (FunctionKind)FunctionKind.SCALAR, expressionTypes, (FunctionRegistry)this.metadata.getFunctionRegistry(), (TypeManager)this.metadata.getTypeManager(), (Session)this.session, (boolean)false);
    }

    private static Page getAtMostOnePage(Operator operator, Page sourcePage) {
        if (operator.needsInput()) {
            operator.addInput(sourcePage);
        }
        Page result = operator.getOutput();
        operator.finish();
        while (!operator.isFinished()) {
            Assert.assertTrue((boolean)operator.isBlocked().isDone());
            Page output = operator.getOutput();
            if (output == null) continue;
            Assert.assertNull((Object)result);
            result = output;
        }
        return result;
    }

    private static DriverContext createDriverContext(Session session) {
        return TestingTaskContext.createTaskContext((Executor)EXECUTOR, (ScheduledExecutorService)SCHEDULED_EXECUTOR, (Session)session).addPipelineContext(0, true, true).addDriverContext();
    }

    private static void assertType(List<Type> types, Type expectedType) {
        Assert.assertTrue((types.size() == 1 ? 1 : 0) != 0, (String)("Expected one type, but got " + types));
        Type actualType = types.get(0);
        Assert.assertEquals((Object)actualType, (Object)expectedType);
    }

    public Session getSession() {
        return this.session;
    }

    @Override
    public void close() {
        this.runner.close();
    }

    private static Split createRecordSetSplit() {
        return new Split(new ConnectorId("test"), (ConnectorTransactionHandle)TestingTransactionHandle.create(), (ConnectorSplit)new TestSplit(true));
    }

    private static Split createNormalSplit() {
        return new Split(new ConnectorId("test"), (ConnectorTransactionHandle)TestingTransactionHandle.create(), (ConnectorSplit)new TestSplit(false));
    }

    private static class TestSplit
    implements ConnectorSplit {
        private final boolean recordSet;

        private TestSplit(boolean recordSet) {
            this.recordSet = recordSet;
        }

        private boolean isRecordSet() {
            return this.recordSet;
        }

        public boolean isRemotelyAccessible() {
            return false;
        }

        public List<HostAddress> getAddresses() {
            return ImmutableList.of();
        }

        public Object getInfo() {
            return this;
        }
    }

    private static class TestPageSourceProvider
    implements PageSourceProvider {
        private TestPageSourceProvider() {
        }

        public ConnectorPageSource createPageSource(Session session, Split split, List<ColumnHandle> columns) {
            Assertions.assertInstanceOf((Object)split.getConnectorSplit(), TestSplit.class);
            TestSplit testSplit = (TestSplit)split.getConnectorSplit();
            if (testSplit.isRecordSet()) {
                InMemoryRecordSet records = InMemoryRecordSet.builder((Collection)ImmutableList.of((Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR, (Object)DoubleType.DOUBLE, (Object)BooleanType.BOOLEAN, (Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR, (Object)VarcharType.VARCHAR, (Object)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, (Object)VarbinaryType.VARBINARY, (Object)IntegerType.INTEGER)).addRow(new Object[]{1234L, "hello", 12.34, true, new DateTime(2001, 8, 22, 3, 4, 5, 321, DateTimeZone.UTC).getMillis(), "%el%", null, DateTimeEncoding.packDateTimeWithZone((long)new DateTime(1970, 1, 1, 0, 1, 0, 999, DateTimeZone.UTC).getMillis(), (TimeZoneKey)TimeZoneKey.getTimeZoneKey((String)"Z")), Slices.wrappedBuffer((byte[])new byte[]{-85}), 1234}).build();
                return new RecordPageSource((RecordSet)records);
            }
            return new FixedPageSource((Iterable)ImmutableList.of((Object)SOURCE_PAGE));
        }
    }
}

