/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import com.facebook.presto.spi.type.ArrayType;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.RowType;
import com.facebook.presto.spi.type.TimeZoneKey;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.testing.TestingSession;
import com.facebook.presto.util.StructuralTestUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.List;
import org.testng.annotations.Test;

public class TestArrayTransformFunction
extends AbstractTestFunctions {
    public TestArrayTransformFunction() {
        super(TestingSession.testSessionBuilder().setTimeZoneKey(TimeZoneKey.getTimeZoneKey((String)"Pacific/Kiritimati")).build());
    }

    @Test
    public void testBasic() {
        this.assertFunction("transform(ARRAY [5, 6], x -> 9)", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)9, (Object)9));
        this.assertFunction("transform(ARRAY [5, 6], x -> x + 1)", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)6, (Object)7));
        this.assertFunction("transform(ARRAY [5 + RANDOM(1), 6], x -> x + 1)", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)6, (Object)7));
    }

    @Test
    public void testNull() {
        this.assertFunction("transform(ARRAY [3], x -> x + 1)", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)4));
        this.assertFunction("transform(ARRAY [NULL, NULL], x -> x + 1)", (Type)new ArrayType((Type)IntegerType.INTEGER), Arrays.asList(null, null));
        this.assertFunction("transform(ARRAY [NULL, 3, NULL], x -> x + 1)", (Type)new ArrayType((Type)IntegerType.INTEGER), Arrays.asList(null, 4, null));
        this.assertFunction("transform(ARRAY [3], x -> x IS NULL)", (Type)new ArrayType((Type)BooleanType.BOOLEAN), ImmutableList.of((Object)false));
        this.assertFunction("transform(ARRAY [NULL, NULL], x -> x IS NULL)", (Type)new ArrayType((Type)BooleanType.BOOLEAN), ImmutableList.of((Object)true, (Object)true));
        this.assertFunction("transform(ARRAY [NULL, 3, NULL], x -> x IS NULL)", (Type)new ArrayType((Type)BooleanType.BOOLEAN), ImmutableList.of((Object)true, (Object)false, (Object)true));
    }

    @Test
    public void testSessionDependent() {
        this.assertFunction("transform(ARRAY['timezone: ', 'tz: '], x -> x || current_timezone())", (Type)new ArrayType((Type)VarcharType.VARCHAR), ImmutableList.of((Object)"timezone: Pacific/Kiritimati", (Object)"tz: Pacific/Kiritimati"));
    }

    @Test
    public void testInstanceFunction() {
        this.assertFunction("transform(ARRAY[2, 3, 4, NULL, 5], x -> concat(ARRAY [1], x))", (Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER)), Arrays.asList(ImmutableList.of((Object)1, (Object)2), ImmutableList.of((Object)1, (Object)3), ImmutableList.of((Object)1, (Object)4), null, ImmutableList.of((Object)1, (Object)5)));
    }

    @Test
    public void testTypeCombinations() {
        this.assertFunction("transform(ARRAY [25, 26], x -> x + 1)", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)26, (Object)27));
        this.assertFunction("transform(ARRAY [25, 26], x -> x + 1.0E0)", (Type)new ArrayType((Type)DoubleType.DOUBLE), ImmutableList.of((Object)26.0, (Object)27.0));
        this.assertFunction("transform(ARRAY [25, 26], x -> x = 25)", (Type)new ArrayType((Type)BooleanType.BOOLEAN), ImmutableList.of((Object)true, (Object)false));
        this.assertFunction("transform(ARRAY [25, 26], x -> to_base(x, 16))", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)64)), ImmutableList.of((Object)"19", (Object)"1a"));
        this.assertFunction("transform(ARRAY [25, 26], x -> ARRAY[x + 1])", (Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER)), ImmutableList.of((Object)ImmutableList.of((Object)26), (Object)ImmutableList.of((Object)27)));
        this.assertFunction("transform(ARRAY [25.6E0, 27.3E0], x -> CAST(x AS BIGINT))", (Type)new ArrayType((Type)BigintType.BIGINT), ImmutableList.of((Object)26L, (Object)27L));
        this.assertFunction("transform(ARRAY [25.6E0, 27.3E0], x -> x + 1.0E0)", (Type)new ArrayType((Type)DoubleType.DOUBLE), ImmutableList.of((Object)26.6, (Object)28.3));
        this.assertFunction("transform(ARRAY [25.6E0, 27.3E0], x -> x = 25.6E0)", (Type)new ArrayType((Type)BooleanType.BOOLEAN), ImmutableList.of((Object)true, (Object)false));
        this.assertFunction("transform(ARRAY [25.6E0, 27.3E0], x -> CAST(x AS VARCHAR))", (Type)new ArrayType((Type)VarcharType.createUnboundedVarcharType()), ImmutableList.of((Object)"25.6", (Object)"27.3"));
        this.assertFunction("transform(ARRAY [25.6E0, 27.3E0], x -> MAP(ARRAY[x + 1], ARRAY[true]))", (Type)new ArrayType((Type)StructuralTestUtil.mapType((Type)DoubleType.DOUBLE, (Type)BooleanType.BOOLEAN)), ImmutableList.of((Object)ImmutableMap.of((Object)26.6, (Object)true), (Object)ImmutableMap.of((Object)28.3, (Object)true)));
        this.assertFunction("transform(ARRAY [true, false], x -> if(x, 25, 26))", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)25, (Object)26));
        this.assertFunction("transform(ARRAY [false, true], x -> if(x, 25.6E0, 28.9E0))", (Type)new ArrayType((Type)DoubleType.DOUBLE), ImmutableList.of((Object)28.9, (Object)25.6));
        this.assertFunction("transform(ARRAY [true, false], x -> not x)", (Type)new ArrayType((Type)BooleanType.BOOLEAN), ImmutableList.of((Object)false, (Object)true));
        this.assertFunction("transform(ARRAY [false, true], x -> CAST(x AS VARCHAR))", (Type)new ArrayType((Type)VarcharType.createUnboundedVarcharType()), ImmutableList.of((Object)"false", (Object)"true"));
        this.assertFunction("transform(ARRAY [true, false], x -> ARRAY[x])", (Type)new ArrayType((Type)new ArrayType((Type)BooleanType.BOOLEAN)), ImmutableList.of((Object)ImmutableList.of((Object)true), (Object)ImmutableList.of((Object)false)));
        this.assertFunction("transform(ARRAY ['41', '42'], x -> from_base(x, 16))", (Type)new ArrayType((Type)BigintType.BIGINT), ImmutableList.of((Object)65L, (Object)66L));
        this.assertFunction("transform(ARRAY ['25.6E0', '27.3E0'], x -> CAST(x AS DOUBLE))", (Type)new ArrayType((Type)DoubleType.DOUBLE), ImmutableList.of((Object)25.6, (Object)27.3));
        this.assertFunction("transform(ARRAY ['abc', 'def'], x -> 'abc' = x)", (Type)new ArrayType((Type)BooleanType.BOOLEAN), ImmutableList.of((Object)true, (Object)false));
        this.assertFunction("transform(ARRAY ['abc', 'def'], x -> x || x)", (Type)new ArrayType((Type)VarcharType.createUnboundedVarcharType()), ImmutableList.of((Object)"abcabc", (Object)"defdef"));
        this.assertFunction("transform(ARRAY ['123', '456'], x -> ROW(x, CAST(x AS INTEGER), x > '3'))", (Type)new ArrayType((Type)RowType.anonymous((List)ImmutableList.of((Object)VarcharType.createVarcharType((int)3), (Object)IntegerType.INTEGER, (Object)BooleanType.BOOLEAN))), ImmutableList.of((Object)ImmutableList.of((Object)"123", (Object)123, (Object)false), (Object)ImmutableList.of((Object)"456", (Object)456, (Object)true)));
        this.assertFunction("transform(ARRAY [ARRAY ['abc', null, '123'], ARRAY ['def', 'x', '456']], x -> from_base(x[3], 10))", (Type)new ArrayType((Type)BigintType.BIGINT), ImmutableList.of((Object)123L, (Object)456L));
        this.assertFunction("transform(ARRAY [ARRAY ['abc', null, '123'], ARRAY ['def', 'x', '456']], x -> CAST(x[3] AS DOUBLE))", (Type)new ArrayType((Type)DoubleType.DOUBLE), ImmutableList.of((Object)123.0, (Object)456.0));
        this.assertFunction("transform(ARRAY [ARRAY ['abc', null, '123'], ARRAY ['def', 'x', '456']], x -> x[2] IS NULL)", (Type)new ArrayType((Type)BooleanType.BOOLEAN), ImmutableList.of((Object)true, (Object)false));
        this.assertFunction("transform(ARRAY [ARRAY ['abc', null, '123'], ARRAY ['def', 'x', '456']], x -> x[2])", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)3)), Arrays.asList(null, "x"));
        this.assertFunction("transform(ARRAY [MAP(ARRAY['abc', 'def'], ARRAY[123, 456]), MAP(ARRAY['ghi', 'jkl'], ARRAY[234, 567])], x -> map_keys(x))", (Type)new ArrayType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)3))), ImmutableList.of((Object)ImmutableList.of((Object)"abc", (Object)"def"), (Object)ImmutableList.of((Object)"ghi", (Object)"jkl")));
    }
}

