/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import com.facebook.presto.operator.scalar.ColorFunctions;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Type;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestColorFunctions
extends AbstractTestFunctions {
    @Test
    public void testParseRgb() {
        Assert.assertEquals((int)ColorFunctions.parseRgb((Slice)TestColorFunctions.toSlice("#000")), (int)0);
        Assert.assertEquals((int)ColorFunctions.parseRgb((Slice)TestColorFunctions.toSlice("#FFF")), (int)0xFFFFFF);
        Assert.assertEquals((int)ColorFunctions.parseRgb((Slice)TestColorFunctions.toSlice("#F00")), (int)0xFF0000);
        Assert.assertEquals((int)ColorFunctions.parseRgb((Slice)TestColorFunctions.toSlice("#0F0")), (int)65280);
        Assert.assertEquals((int)ColorFunctions.parseRgb((Slice)TestColorFunctions.toSlice("#00F")), (int)255);
        Assert.assertEquals((int)ColorFunctions.parseRgb((Slice)TestColorFunctions.toSlice("#700")), (int)0x770000);
        Assert.assertEquals((int)ColorFunctions.parseRgb((Slice)TestColorFunctions.toSlice("#070")), (int)30464);
        Assert.assertEquals((int)ColorFunctions.parseRgb((Slice)TestColorFunctions.toSlice("#007")), (int)119);
        Assert.assertEquals((int)ColorFunctions.parseRgb((Slice)TestColorFunctions.toSlice("#cde")), (int)0xCCDDEE);
    }

    @Test
    public void testGetComponent() {
        Assert.assertEquals((int)ColorFunctions.getRed((long)ColorFunctions.parseRgb((Slice)TestColorFunctions.toSlice("#789"))), (int)119);
        Assert.assertEquals((int)ColorFunctions.getGreen((long)ColorFunctions.parseRgb((Slice)TestColorFunctions.toSlice("#789"))), (int)136);
        Assert.assertEquals((int)ColorFunctions.getBlue((long)ColorFunctions.parseRgb((Slice)TestColorFunctions.toSlice("#789"))), (int)153);
    }

    @Test
    public void testToRgb() {
        Assert.assertEquals((long)ColorFunctions.rgb((long)255L, (long)0L, (long)0L), (long)0xFF0000L);
        Assert.assertEquals((long)ColorFunctions.rgb((long)0L, (long)255L, (long)0L), (long)65280L);
        Assert.assertEquals((long)ColorFunctions.rgb((long)0L, (long)0L, (long)255L), (long)255L);
    }

    @Test
    public void testColor() {
        Assert.assertEquals((long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("black")), (long)-1L);
        Assert.assertEquals((long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("red")), (long)-2L);
        Assert.assertEquals((long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("green")), (long)-3L);
        Assert.assertEquals((long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("yellow")), (long)-4L);
        Assert.assertEquals((long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("blue")), (long)-5L);
        Assert.assertEquals((long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("magenta")), (long)-6L);
        Assert.assertEquals((long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("cyan")), (long)-7L);
        Assert.assertEquals((long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("white")), (long)-8L);
        Assert.assertEquals((long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("#f00")), (long)0xFF0000L);
        Assert.assertEquals((long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("#0f0")), (long)65280L);
        Assert.assertEquals((long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("#00f")), (long)255L);
    }

    @Test
    public void testBar() {
        Assert.assertEquals((Object)ColorFunctions.bar((double)0.6, (long)5L, (long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("#f0f")), (long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("#00f"))), (Object)TestColorFunctions.toSlice("\u001b[38;5;201m\u2588\u001b[38;5;165m\u2588\u001b[38;5;129m\u2588\u001b[0m  "));
        Assert.assertEquals((Object)ColorFunctions.bar((double)1.0, (long)10L, (long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("#f00")), (long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("#0f0"))), (Object)TestColorFunctions.toSlice("\u001b[38;5;196m\u2588\u001b[38;5;202m\u2588\u001b[38;5;208m\u2588\u001b[38;5;214m\u2588\u001b[38;5;226m\u2588\u001b[38;5;226m\u2588\u001b[38;5;154m\u2588\u001b[38;5;118m\u2588\u001b[38;5;82m\u2588\u001b[38;5;46m\u2588\u001b[0m"));
        Assert.assertEquals((Object)ColorFunctions.bar((double)0.6, (long)5L, (long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("#f0f")), (long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("#00f"))), (Object)TestColorFunctions.toSlice("\u001b[38;5;201m\u2588\u001b[38;5;165m\u2588\u001b[38;5;129m\u2588\u001b[0m  "));
    }

    @Test
    public void testRenderBoolean() {
        Assert.assertEquals((Object)ColorFunctions.render((boolean)true), (Object)TestColorFunctions.toSlice("\u001b[38;5;2m\u2713\u001b[0m"));
        Assert.assertEquals((Object)ColorFunctions.render((boolean)false), (Object)TestColorFunctions.toSlice("\u001b[38;5;1m\u2717\u001b[0m"));
    }

    @Test
    public void testRenderString() {
        Assert.assertEquals((Object)ColorFunctions.render((Slice)TestColorFunctions.toSlice("hello"), (long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("red"))), (Object)TestColorFunctions.toSlice("\u001b[38;5;1mhello\u001b[0m"));
        Assert.assertEquals((Object)ColorFunctions.render((Slice)TestColorFunctions.toSlice("hello"), (long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("#f00"))), (Object)TestColorFunctions.toSlice("\u001b[38;5;196mhello\u001b[0m"));
        Assert.assertEquals((Object)ColorFunctions.render((Slice)TestColorFunctions.toSlice("hello"), (long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("#0f0"))), (Object)TestColorFunctions.toSlice("\u001b[38;5;46mhello\u001b[0m"));
        Assert.assertEquals((Object)ColorFunctions.render((Slice)TestColorFunctions.toSlice("hello"), (long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("#00f"))), (Object)TestColorFunctions.toSlice("\u001b[38;5;21mhello\u001b[0m"));
    }

    @Test
    public void testRenderLong() {
        Assert.assertEquals((Object)ColorFunctions.render((long)1234L, (long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("red"))), (Object)TestColorFunctions.toSlice("\u001b[38;5;1m1234\u001b[0m"));
        Assert.assertEquals((Object)ColorFunctions.render((long)1234L, (long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("#f00"))), (Object)TestColorFunctions.toSlice("\u001b[38;5;196m1234\u001b[0m"));
        Assert.assertEquals((Object)ColorFunctions.render((long)1234L, (long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("#0f0"))), (Object)TestColorFunctions.toSlice("\u001b[38;5;46m1234\u001b[0m"));
        Assert.assertEquals((Object)ColorFunctions.render((long)1234L, (long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("#00f"))), (Object)TestColorFunctions.toSlice("\u001b[38;5;21m1234\u001b[0m"));
    }

    @Test
    public void testRenderDouble() {
        Assert.assertEquals((Object)ColorFunctions.render((double)1234.5678, (long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("red"))), (Object)TestColorFunctions.toSlice("\u001b[38;5;1m1234.5678\u001b[0m"));
        Assert.assertEquals((Object)ColorFunctions.render((double)1234.5677490234375, (long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("red"))), (Object)TestColorFunctions.toSlice(String.format("\u001b[38;5;1m%s\u001b[0m", 1234.5677490234375)));
        Assert.assertEquals((Object)ColorFunctions.render((double)1234.5678, (long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("#f00"))), (Object)TestColorFunctions.toSlice("\u001b[38;5;196m1234.5678\u001b[0m"));
        Assert.assertEquals((Object)ColorFunctions.render((double)1234.5678, (long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("#0f0"))), (Object)TestColorFunctions.toSlice("\u001b[38;5;46m1234.5678\u001b[0m"));
        Assert.assertEquals((Object)ColorFunctions.render((double)1234.5678, (long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("#00f"))), (Object)TestColorFunctions.toSlice("\u001b[38;5;21m1234.5678\u001b[0m"));
    }

    @Test
    public void testInterpolate() {
        Assert.assertEquals((long)ColorFunctions.color((double)0.0, (double)0.0, (double)255.0, (long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("#000")), (long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("#fff"))), (long)0L);
        Assert.assertEquals((long)ColorFunctions.color((double)0.0, (double)0.0, (double)255.0, (long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("#000")), (long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("#fff"))), (long)0L);
        Assert.assertEquals((long)ColorFunctions.color((double)128.0, (double)0.0, (double)255.0, (long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("#000")), (long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("#fff"))), (long)0x808080L);
        Assert.assertEquals((long)ColorFunctions.color((double)255.0, (double)0.0, (double)255.0, (long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("#000")), (long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("#fff"))), (long)0xFFFFFFL);
        Assert.assertEquals((long)ColorFunctions.color((double)-1.0, (double)42.0, (double)52.0, (long)ColorFunctions.rgb((long)255L, (long)0L, (long)0L), (long)ColorFunctions.rgb((long)255L, (long)255L, (long)0L)), (long)0xFF0000L);
        Assert.assertEquals((long)ColorFunctions.color((double)47.0, (double)42.0, (double)52.0, (long)ColorFunctions.rgb((long)255L, (long)0L, (long)0L), (long)ColorFunctions.rgb((long)255L, (long)255L, (long)0L)), (long)0xFF8000L);
        Assert.assertEquals((long)ColorFunctions.color((double)142.0, (double)42.0, (double)52.0, (long)ColorFunctions.rgb((long)255L, (long)0L, (long)0L), (long)ColorFunctions.rgb((long)255L, (long)255L, (long)0L)), (long)0xFFFF00L);
        Assert.assertEquals((long)ColorFunctions.color((double)-42.0, (long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("#000")), (long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("#fff"))), (long)0L);
        Assert.assertEquals((long)ColorFunctions.color((double)0.0, (long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("#000")), (long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("#fff"))), (long)0L);
        Assert.assertEquals((long)ColorFunctions.color((double)0.5, (long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("#000")), (long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("#fff"))), (long)0x808080L);
        Assert.assertEquals((long)ColorFunctions.color((double)1.0, (long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("#000")), (long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("#fff"))), (long)0xFFFFFFL);
        Assert.assertEquals((long)ColorFunctions.color((double)42.0, (long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("#000")), (long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("#fff"))), (long)0xFFFFFFL);
        Assert.assertEquals((long)ColorFunctions.color((double)1.0, (long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("#000")), (long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("#fff"))), (long)0xFFFFFFL);
        Assert.assertEquals((long)ColorFunctions.color((double)-0.0, (long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("#000")), (long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("#fff"))), (long)0L);
        Assert.assertEquals((long)ColorFunctions.color((double)0.0, (long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("#000")), (long)ColorFunctions.color((Slice)TestColorFunctions.toSlice("#fff"))), (long)0L);
    }

    @Test
    public void testIndeterminate() {
        this.assertOperator(OperatorType.INDETERMINATE, "color(null)", (Type)BooleanType.BOOLEAN, true);
        this.assertOperator(OperatorType.INDETERMINATE, "color('black')", (Type)BooleanType.BOOLEAN, false);
    }

    private static Slice toSlice(String string) {
        return Slices.utf8Slice((String)string);
    }
}

