/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.Session;
import com.facebook.presto.operator.scalar.FunctionAssertions;
import com.facebook.presto.operator.scalar.TestDateTimeFunctionsBase;
import com.facebook.presto.spi.type.TimeType;
import com.facebook.presto.spi.type.TimeWithTimeZoneType;
import com.facebook.presto.spi.type.TimestampType;
import com.facebook.presto.spi.type.TimestampWithTimeZoneType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import org.joda.time.DateTime;
import org.testng.annotations.Test;

public class TestDateTimeFunctions
extends TestDateTimeFunctionsBase {
    public TestDateTimeFunctions() {
        super(false);
    }

    @Test
    public void testToIso8601ForTimestampWithoutTimeZone() {
        this.assertFunction("to_iso8601(TIMESTAMP '2001-08-22 03:04:05.321')", (Type)VarcharType.createVarcharType((int)35), "2001-08-22T03:04:05.321");
    }

    @Test
    public void testFormatDateCannotImplicitlyAddTimeZoneToTimestampLiteral() {
        this.assertInvalidFunction("format_datetime(TIMESTAMP '2001-08-22 03:04:05.321', 'YYYY/MM/dd HH:mm ZZZZ')", "format_datetime for TIMESTAMP type, cannot use 'Z' nor 'z' in format, as this type does not contain TZ information");
    }

    @Test
    public void testLocalTime() {
        Session localSession = Session.builder((Session)this.session).setStartTime(new DateTime(2017, 3, 1, 14, 30, 0, 0, DATE_TIME_ZONE).getMillis()).build();
        try (FunctionAssertions localAssertion = new FunctionAssertions(localSession);){
            localAssertion.assertFunctionString("LOCALTIME", (Type)TimeType.TIME, "14:30:00.000");
        }
    }

    @Test
    public void testCurrentTime() {
        Session localSession = Session.builder((Session)this.session).setTimeZoneKey(KATHMANDU_ZONE_KEY).setStartTime(new DateTime(2017, 3, 1, 15, 45, 0, 0, KATHMANDU_ZONE).getMillis()).build();
        try (FunctionAssertions localAssertion = new FunctionAssertions(localSession);){
            localAssertion.assertFunctionString("CURRENT_TIME", (Type)TimeWithTimeZoneType.TIME_WITH_TIME_ZONE, "15:45:00.000 Asia/Kathmandu");
        }
    }

    @Test
    public void testLocalTimestamp() {
        Session localSession = Session.builder((Session)this.session).setStartTime(new DateTime(2017, 3, 1, 14, 30, 0, 0, DATE_TIME_ZONE).getMillis()).build();
        try (FunctionAssertions localAssertion = new FunctionAssertions(localSession);){
            localAssertion.assertFunctionString("LOCALTIMESTAMP", (Type)TimestampType.TIMESTAMP, "2017-03-01 14:30:00.000");
        }
    }

    @Test
    public void testCurrentTimestamp() {
        Session localSession = Session.builder((Session)this.session).setStartTime(new DateTime(2017, 3, 1, 14, 30, 0, 0, DATE_TIME_ZONE).getMillis()).build();
        try (FunctionAssertions localAssertion = new FunctionAssertions(localSession);){
            localAssertion.assertFunctionString("CURRENT_TIMESTAMP", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, "2017-03-01 14:30:00.000 Asia/Kabul");
            localAssertion.assertFunctionString("NOW()", (Type)TimestampWithTimeZoneType.TIMESTAMP_WITH_TIME_ZONE, "2017-03-01 14:30:00.000 Asia/Kabul");
        }
    }
}

