/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.function.IsNull;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlNullable;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestIsNullAnnotation
extends AbstractTestFunctions {
    @BeforeClass
    public void setUp() {
        this.registerScalar(this.getClass());
    }

    @ScalarFunction(value="test_is_null_simple")
    @SqlType(value="bigint")
    public static long testIsNullSimple(@SqlType(value="bigint") long value, @IsNull boolean isNull) {
        if (isNull) {
            return 100L;
        }
        return 2L * value;
    }

    @ScalarFunction(value="test_is_null")
    @SqlType(value="varchar")
    public static Slice testIsNull(ConnectorSession session, @SqlType(value="integer") long longValue, @IsNull boolean isNullLong, @SqlType(value="varchar") Slice varcharNotNullable, @SqlType(value="varchar") @SqlNullable Slice varcharNullable, @SqlType(value="varchar") Slice varcharIsNull, @IsNull boolean isNullVarchar) {
        Preconditions.checkArgument((session != null ? 1 : 0) != 0, (Object)"session is null");
        StringBuilder builder = new StringBuilder();
        if (!isNullLong) {
            builder.append(longValue);
        }
        builder.append(":");
        Preconditions.checkArgument((varcharNotNullable != null ? 1 : 0) != 0, (Object)"varcharNotNullable is null while it doesn't has @SqlNullable");
        builder.append(varcharNotNullable.toStringUtf8()).append(":");
        if (varcharNullable != null) {
            builder.append(varcharNullable.toStringUtf8());
        }
        builder.append(":");
        if (!isNullVarchar) {
            builder.append(varcharIsNull.toStringUtf8());
        }
        return Slices.utf8Slice((String)builder.toString());
    }

    @ScalarFunction(value="test_is_null_void")
    @SqlType(value="boolean")
    public static boolean testIsNullVoid(@SqlType(value="unknown") boolean value, @IsNull boolean isNull) {
        return isNull;
    }

    @Test
    public void testIsNull() {
        this.assertFunction("test_is_null_simple(-100)", (Type)BigintType.BIGINT, -200L);
        this.assertFunction("test_is_null_simple(23)", (Type)BigintType.BIGINT, 46L);
        this.assertFunction("test_is_null_simple(null)", (Type)BigintType.BIGINT, 100L);
        this.assertFunction("test_is_null_simple(cast(null as bigint))", (Type)BigintType.BIGINT, 100L);
        this.assertFunction("test_is_null(23, 'aaa', 'bbb', 'ccc')", (Type)VarcharType.VARCHAR, "23:aaa:bbb:ccc");
        this.assertFunction("test_is_null(null, 'aaa', 'bbb', 'ccc')", (Type)VarcharType.VARCHAR, ":aaa:bbb:ccc");
        this.assertFunction("test_is_null(null, 'aaa', null, 'ccc')", (Type)VarcharType.VARCHAR, ":aaa::ccc");
        this.assertFunction("test_is_null(23, 'aaa', null, null)", (Type)VarcharType.VARCHAR, "23:aaa::");
        this.assertFunction("test_is_null(23, null, 'bbb', 'ccc')", (Type)VarcharType.VARCHAR, null);
        this.assertFunction("test_is_null_void(null)", (Type)BooleanType.BOOLEAN, true);
    }
}

