/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.operator.scalar.AbstractTestFunctions;
import com.facebook.presto.operator.scalar.JsonExtract;
import com.facebook.presto.operator.scalar.JsonPathTokenizer;
import com.facebook.presto.operator.scalar.TestStringFunctions;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestJsonExtract
extends AbstractTestFunctions {
    @BeforeClass
    public void setUp() {
        this.registerScalar(TestStringFunctions.class);
    }

    @Test
    public void testJsonTokenizer() {
        Assert.assertEquals(TestJsonExtract.tokenizePath("$"), (Collection)ImmutableList.of());
        Assert.assertEquals(TestJsonExtract.tokenizePath("$"), (Collection)ImmutableList.of());
        Assert.assertEquals(TestJsonExtract.tokenizePath("$.foo"), (Collection)ImmutableList.of((Object)"foo"));
        Assert.assertEquals(TestJsonExtract.tokenizePath("$[\"foo\"]"), (Collection)ImmutableList.of((Object)"foo"));
        Assert.assertEquals(TestJsonExtract.tokenizePath("$[\"foo.bar\"]"), (Collection)ImmutableList.of((Object)"foo.bar"));
        Assert.assertEquals(TestJsonExtract.tokenizePath("$[42]"), (Collection)ImmutableList.of((Object)"42"));
        Assert.assertEquals(TestJsonExtract.tokenizePath("$.42"), (Collection)ImmutableList.of((Object)"42"));
        Assert.assertEquals(TestJsonExtract.tokenizePath("$.42.63"), (Collection)ImmutableList.of((Object)"42", (Object)"63"));
        Assert.assertEquals(TestJsonExtract.tokenizePath("$.foo.42.bar.63"), (Collection)ImmutableList.of((Object)"foo", (Object)"42", (Object)"bar", (Object)"63"));
        Assert.assertEquals(TestJsonExtract.tokenizePath("$.x.foo"), (Collection)ImmutableList.of((Object)"x", (Object)"foo"));
        Assert.assertEquals(TestJsonExtract.tokenizePath("$.x[\"foo\"]"), (Collection)ImmutableList.of((Object)"x", (Object)"foo"));
        Assert.assertEquals(TestJsonExtract.tokenizePath("$.x[42]"), (Collection)ImmutableList.of((Object)"x", (Object)"42"));
        Assert.assertEquals(TestJsonExtract.tokenizePath("$.foo_42._bar63"), (Collection)ImmutableList.of((Object)"foo_42", (Object)"_bar63"));
        Assert.assertEquals(TestJsonExtract.tokenizePath("$[foo_42][_bar63]"), (Collection)ImmutableList.of((Object)"foo_42", (Object)"_bar63"));
        Assert.assertEquals(TestJsonExtract.tokenizePath("$.foo:42.:bar63"), (Collection)ImmutableList.of((Object)"foo:42", (Object)":bar63"));
        Assert.assertEquals(TestJsonExtract.tokenizePath("$[\"foo:42\"][\":bar63\"]"), (Collection)ImmutableList.of((Object)"foo:42", (Object)":bar63"));
        TestJsonExtract.assertPathToken("foo");
        TestJsonExtract.assertQuotedPathToken("-1.1");
        TestJsonExtract.assertQuotedPathToken("!@#$%^&*()[]{}/?'");
        TestJsonExtract.assertQuotedPathToken("ab\u0001c");
        TestJsonExtract.assertQuotedPathToken("ab\u0000c");
        TestJsonExtract.assertQuotedPathToken("ab\t\n\rc");
        TestJsonExtract.assertQuotedPathToken(".");
        TestJsonExtract.assertQuotedPathToken("$");
        TestJsonExtract.assertQuotedPathToken("]");
        TestJsonExtract.assertQuotedPathToken("[");
        TestJsonExtract.assertQuotedPathToken("'");
        TestJsonExtract.assertQuotedPathToken("!@#$%^&*(){}[]<>?/|.,`~\r\n\t \u0000");
        TestJsonExtract.assertQuotedPathToken("a\\\\b\\\"", "a\\b\"");
        TestJsonExtract.assertInvalidPath("$[\"a\\ \"]");
        TestJsonExtract.assertInvalidPath("$[foo:bar]");
        TestJsonExtract.assertInvalidPath(" $.x");
        TestJsonExtract.assertInvalidPath(" $.x ");
        TestJsonExtract.assertInvalidPath("$. x");
        TestJsonExtract.assertInvalidPath("$ .x");
        TestJsonExtract.assertInvalidPath("$\n.x");
        TestJsonExtract.assertInvalidPath("$.x [42]");
        TestJsonExtract.assertInvalidPath("$.x[ 42]");
        TestJsonExtract.assertInvalidPath("$.x[42 ]");
        TestJsonExtract.assertInvalidPath("$.x[ \"foo\"]");
        TestJsonExtract.assertInvalidPath("$.x[\"foo\" ]");
    }

    private static void assertPathToken(String fieldName) {
        Assert.assertTrue((fieldName.indexOf(34) < 0 ? 1 : 0) != 0);
        Assert.assertEquals(TestJsonExtract.tokenizePath("$." + fieldName), (Collection)ImmutableList.of((Object)fieldName));
        Assert.assertEquals(TestJsonExtract.tokenizePath("$.foo." + fieldName + ".bar"), (Collection)ImmutableList.of((Object)"foo", (Object)fieldName, (Object)"bar"));
        TestJsonExtract.assertPathTokenQuoting(fieldName);
    }

    private static void assertQuotedPathToken(String fieldName) {
        TestJsonExtract.assertQuotedPathToken(fieldName, fieldName);
    }

    private static void assertQuotedPathToken(String fieldName, String expectedTokenizedField) {
        TestJsonExtract.assertPathTokenQuoting(fieldName, expectedTokenizedField);
        TestJsonExtract.assertInvalidPath("$." + fieldName);
    }

    private static void assertPathTokenQuoting(String fieldName) {
        TestJsonExtract.assertPathTokenQuoting(fieldName, fieldName);
    }

    private static void assertPathTokenQuoting(String fieldName, String expectedTokenizedField) {
        Assert.assertEquals(TestJsonExtract.tokenizePath("$[\"" + fieldName + "\"]"), (Collection)ImmutableList.of((Object)expectedTokenizedField));
        Assert.assertEquals(TestJsonExtract.tokenizePath("$.foo[\"" + fieldName + "\"].bar"), (Collection)ImmutableList.of((Object)"foo", (Object)expectedTokenizedField, (Object)"bar"));
    }

    public static void assertInvalidPath(String path) {
        try {
            TestJsonExtract.tokenizePath(path);
            Assert.fail((String)"Expected PrestoException");
        }
        catch (PrestoException e) {
            Assert.assertEquals((Object)e.getErrorCode(), (Object)StandardErrorCode.INVALID_FUNCTION_ARGUMENT.toErrorCode());
        }
    }

    @Test
    public void testScalarValueJsonExtractor() throws Exception {
        JsonExtract.ScalarValueJsonExtractor extractor = new JsonExtract.ScalarValueJsonExtractor();
        Assert.assertEquals((String)TestJsonExtract.doExtract((JsonExtract.JsonExtractor<Slice>)extractor, "123"), (String)"123");
        Assert.assertEquals((String)TestJsonExtract.doExtract((JsonExtract.JsonExtractor<Slice>)extractor, "-1"), (String)"-1");
        Assert.assertEquals((String)TestJsonExtract.doExtract((JsonExtract.JsonExtractor<Slice>)extractor, "0.01"), (String)"0.01");
        Assert.assertEquals((String)TestJsonExtract.doExtract((JsonExtract.JsonExtractor<Slice>)extractor, "\"abc\""), (String)"abc");
        Assert.assertEquals((String)TestJsonExtract.doExtract((JsonExtract.JsonExtractor<Slice>)extractor, "\"\""), (String)"");
        Assert.assertEquals((String)TestJsonExtract.doExtract((JsonExtract.JsonExtractor<Slice>)extractor, "null"), null);
        Assert.assertEquals((String)TestJsonExtract.doExtract((JsonExtract.JsonExtractor<Slice>)extractor, "\"ab\\u0001c\""), (String)"ab\u0001c");
        Assert.assertEquals((String)TestJsonExtract.doExtract((JsonExtract.JsonExtractor<Slice>)extractor, "\"ab\\u0002c\""), (String)"ab\u0002c");
        Assert.assertEquals((String)TestJsonExtract.doExtract((JsonExtract.JsonExtractor<Slice>)extractor, "[1, 2, 3]"), null);
        Assert.assertEquals((String)TestJsonExtract.doExtract((JsonExtract.JsonExtractor<Slice>)extractor, "{\"a\": 1}"), null);
    }

    @Test
    public void testJsonValueJsonExtractor() throws Exception {
        JsonExtract.JsonValueJsonExtractor extractor = new JsonExtract.JsonValueJsonExtractor();
        Assert.assertEquals((String)TestJsonExtract.doExtract((JsonExtract.JsonExtractor<Slice>)extractor, "123"), (String)"123");
        Assert.assertEquals((String)TestJsonExtract.doExtract((JsonExtract.JsonExtractor<Slice>)extractor, "-1"), (String)"-1");
        Assert.assertEquals((String)TestJsonExtract.doExtract((JsonExtract.JsonExtractor<Slice>)extractor, "0.01"), (String)"0.01");
        Assert.assertEquals((String)TestJsonExtract.doExtract((JsonExtract.JsonExtractor<Slice>)extractor, "\"abc\""), (String)"\"abc\"");
        Assert.assertEquals((String)TestJsonExtract.doExtract((JsonExtract.JsonExtractor<Slice>)extractor, "\"\""), (String)"\"\"");
        Assert.assertEquals((String)TestJsonExtract.doExtract((JsonExtract.JsonExtractor<Slice>)extractor, "null"), (String)"null");
        Assert.assertEquals((String)TestJsonExtract.doExtract((JsonExtract.JsonExtractor<Slice>)extractor, "\"ab\\u0001c\""), (String)"\"ab\\u0001c\"");
        Assert.assertEquals((String)TestJsonExtract.doExtract((JsonExtract.JsonExtractor<Slice>)extractor, "\"ab\\u0002c\""), (String)"\"ab\\u0002c\"");
        Assert.assertEquals((String)TestJsonExtract.doExtract((JsonExtract.JsonExtractor<Slice>)extractor, "[1, 2, 3]"), (String)"[1,2,3]");
        Assert.assertEquals((String)TestJsonExtract.doExtract((JsonExtract.JsonExtractor<Slice>)extractor, "{\"a\": 1}"), (String)"{\"a\":1}");
    }

    @Test
    public void testArrayElementJsonExtractor() throws Exception {
        JsonExtract.ObjectFieldJsonExtractor firstExtractor = new JsonExtract.ObjectFieldJsonExtractor("0", (JsonExtract.JsonExtractor)new JsonExtract.ScalarValueJsonExtractor());
        JsonExtract.ObjectFieldJsonExtractor secondExtractor = new JsonExtract.ObjectFieldJsonExtractor("1", (JsonExtract.JsonExtractor)new JsonExtract.ScalarValueJsonExtractor());
        Assert.assertEquals((String)TestJsonExtract.doExtract((JsonExtract.JsonExtractor<Slice>)firstExtractor, "[]"), null);
        Assert.assertEquals((String)TestJsonExtract.doExtract((JsonExtract.JsonExtractor<Slice>)firstExtractor, "[1, 2, 3]"), (String)"1");
        Assert.assertEquals((String)TestJsonExtract.doExtract((JsonExtract.JsonExtractor<Slice>)secondExtractor, "[1, 2]"), (String)"2");
        Assert.assertEquals((String)TestJsonExtract.doExtract((JsonExtract.JsonExtractor<Slice>)secondExtractor, "[1, null]"), null);
        Assert.assertEquals((String)TestJsonExtract.doExtract((JsonExtract.JsonExtractor<Slice>)secondExtractor, "[1]"), null);
        Assert.assertEquals((String)TestJsonExtract.doExtract((JsonExtract.JsonExtractor<Slice>)secondExtractor, "[{\"a\": 1}, 2, 3]"), (String)"2");
    }

    @Test
    public void testObjectFieldJsonExtractor() throws Exception {
        JsonExtract.ObjectFieldJsonExtractor extractor = new JsonExtract.ObjectFieldJsonExtractor("fuu", (JsonExtract.JsonExtractor)new JsonExtract.ScalarValueJsonExtractor());
        Assert.assertEquals((String)TestJsonExtract.doExtract((JsonExtract.JsonExtractor<Slice>)extractor, "{}"), null);
        Assert.assertEquals((String)TestJsonExtract.doExtract((JsonExtract.JsonExtractor<Slice>)extractor, "{\"a\": 1}"), null);
        Assert.assertEquals((String)TestJsonExtract.doExtract((JsonExtract.JsonExtractor<Slice>)extractor, "{\"fuu\": 1}"), (String)"1");
        Assert.assertEquals((String)TestJsonExtract.doExtract((JsonExtract.JsonExtractor<Slice>)extractor, "{\"a\": 0, \"fuu\": 1}"), (String)"1");
        Assert.assertEquals((String)TestJsonExtract.doExtract((JsonExtract.JsonExtractor<Slice>)extractor, "{\"a\": [1, 2, 3], \"fuu\": 1}"), (String)"1");
    }

    @Test
    public void testFullScalarExtract() {
        Assert.assertEquals((String)TestJsonExtract.doScalarExtract("{}", "$"), null);
        Assert.assertEquals((String)TestJsonExtract.doScalarExtract("{\"fuu\": {\"bar\": 1}}", "$.fuu"), null);
        Assert.assertEquals((String)TestJsonExtract.doScalarExtract("{\"fuu\": 1}", "$.fuu"), (String)"1");
        Assert.assertEquals((String)TestJsonExtract.doScalarExtract("{\"fuu\": 1}", "$[fuu]"), (String)"1");
        Assert.assertEquals((String)TestJsonExtract.doScalarExtract("{\"fuu\": 1}", "$[\"fuu\"]"), (String)"1");
        Assert.assertEquals((String)TestJsonExtract.doScalarExtract("{\"fuu\": null}", "$.fuu"), null);
        Assert.assertEquals((String)TestJsonExtract.doScalarExtract("{\"fuu\": 1}", "$.bar"), null);
        Assert.assertEquals((String)TestJsonExtract.doScalarExtract("{\"fuu\": [\"\\u0001\"]}", "$.fuu[0]"), (String)"\u0001");
        Assert.assertEquals((String)TestJsonExtract.doScalarExtract("{\"fuu\": 1, \"bar\": \"abc\"}", "$.bar"), (String)"abc");
        Assert.assertEquals((String)TestJsonExtract.doScalarExtract("{\"fuu\": [0.1, 1, 2]}", "$.fuu[0]"), (String)"0.1");
        Assert.assertEquals((String)TestJsonExtract.doScalarExtract("{\"fuu\": [0, [100, 101], 2]}", "$.fuu[1]"), null);
        Assert.assertEquals((String)TestJsonExtract.doScalarExtract("{\"fuu\": [0, [100, 101], 2]}", "$.fuu[1][1]"), (String)"101");
        Assert.assertEquals((String)TestJsonExtract.doScalarExtract("{\"fuu\": [0, {\"bar\": {\"key\" : [\"value\"]}}, 2]}", "$.fuu[1].bar.key[0]"), (String)"value");
        Assert.assertEquals((String)TestJsonExtract.doScalarExtract("[0, 1, 2]", "$[0]"), (String)"0");
        Assert.assertEquals((String)TestJsonExtract.doScalarExtract("\"abc\"", "$"), (String)"abc");
        Assert.assertEquals((String)TestJsonExtract.doScalarExtract("123", "$"), (String)"123");
        Assert.assertEquals((String)TestJsonExtract.doScalarExtract("null", "$"), null);
        Assert.assertEquals((String)TestJsonExtract.doScalarExtract("[0, 1, 2]", "$.1"), (String)"1");
        Assert.assertEquals((String)TestJsonExtract.doScalarExtract("[0, 1, 2]", "$[1]"), (String)"1");
        Assert.assertEquals((String)TestJsonExtract.doScalarExtract("[0, 1, 2]", "$[\"1\"]"), (String)"1");
        Assert.assertEquals((String)TestJsonExtract.doScalarExtract("{\"0\" : 0, \"1\" : 1, \"2\" : 2, }", "$.1"), (String)"1");
        Assert.assertEquals((String)TestJsonExtract.doScalarExtract("{\"0\" : 0, \"1\" : 1, \"2\" : 2, }", "$[1]"), (String)"1");
        Assert.assertEquals((String)TestJsonExtract.doScalarExtract("{\"0\" : 0, \"1\" : 1, \"2\" : 2, }", "$[\"1\"]"), (String)"1");
        Assert.assertEquals((String)TestJsonExtract.doScalarExtract("{\"15day\" : 0, \"30day\" : 1, \"90day\" : 2, }", "$.30day"), (String)"1");
        Assert.assertEquals((String)TestJsonExtract.doScalarExtract("{\"15day\" : 0, \"30day\" : 1, \"90day\" : 2, }", "$[30day]"), (String)"1");
        Assert.assertEquals((String)TestJsonExtract.doScalarExtract("{\"15day\" : 0, \"30day\" : 1, \"90day\" : 2, }", "$[\"30day\"]"), (String)"1");
    }

    @Test
    public void testFullJsonExtract() {
        Assert.assertEquals((String)TestJsonExtract.doJsonExtract("{}", "$"), (String)"{}");
        Assert.assertEquals((String)TestJsonExtract.doJsonExtract("{\"fuu\": {\"bar\": 1}}", "$.fuu"), (String)"{\"bar\":1}");
        Assert.assertEquals((String)TestJsonExtract.doJsonExtract("{\"fuu\": 1}", "$.fuu"), (String)"1");
        Assert.assertEquals((String)TestJsonExtract.doJsonExtract("{\"fuu\": 1}", "$[fuu]"), (String)"1");
        Assert.assertEquals((String)TestJsonExtract.doJsonExtract("{\"fuu\": 1}", "$[\"fuu\"]"), (String)"1");
        Assert.assertEquals((String)TestJsonExtract.doJsonExtract("{\"fuu\": null}", "$.fuu"), (String)"null");
        Assert.assertEquals((String)TestJsonExtract.doJsonExtract("{\"fuu\": 1}", "$.bar"), null);
        Assert.assertEquals((String)TestJsonExtract.doJsonExtract("{\"fuu\": [\"\\u0001\"]}", "$.fuu[0]"), (String)"\"\\u0001\"");
        Assert.assertEquals((String)TestJsonExtract.doJsonExtract("{\"fuu\": 1, \"bar\": \"abc\"}", "$.bar"), (String)"\"abc\"");
        Assert.assertEquals((String)TestJsonExtract.doJsonExtract("{\"fuu\": [0.1, 1, 2]}", "$.fuu[0]"), (String)"0.1");
        Assert.assertEquals((String)TestJsonExtract.doJsonExtract("{\"fuu\": [0, [100, 101], 2]}", "$.fuu[1]"), (String)"[100,101]");
        Assert.assertEquals((String)TestJsonExtract.doJsonExtract("{\"fuu\": [0, [100, 101], 2]}", "$.fuu[1][1]"), (String)"101");
        Assert.assertEquals((String)TestJsonExtract.doJsonExtract("[0, 1, 2]", "$[0]"), (String)"0");
        Assert.assertEquals((String)TestJsonExtract.doJsonExtract("\"abc\"", "$"), (String)"\"abc\"");
        Assert.assertEquals((String)TestJsonExtract.doJsonExtract("123", "$"), (String)"123");
        Assert.assertEquals((String)TestJsonExtract.doJsonExtract("null", "$"), (String)"null");
        Assert.assertEquals((String)TestJsonExtract.doJsonExtract("{\"fuu\": {\"bar\": 1}}", "$[\"fuu\"]"), (String)"{\"bar\":1}");
        Assert.assertEquals((String)TestJsonExtract.doJsonExtract("{\"fuu\": {\"bar\": 1}}", "$[\"fuu\"][\"bar\"]"), (String)"1");
        Assert.assertEquals((String)TestJsonExtract.doJsonExtract("{\"fuu\": 1}", "$[\"fuu\"]"), (String)"1");
        Assert.assertEquals((String)TestJsonExtract.doJsonExtract("{\"fuu\": null}", "$[\"fuu\"]"), (String)"null");
        Assert.assertEquals((String)TestJsonExtract.doJsonExtract("{\"fuu\": 1}", "$[\"bar\"]"), null);
        Assert.assertEquals((String)TestJsonExtract.doJsonExtract("{\"fuu\": [\"\\u0001\"]}", "$[\"fuu\"][0]"), (String)"\"\\u0001\"");
        Assert.assertEquals((String)TestJsonExtract.doJsonExtract("{\"fuu\": 1, \"bar\": \"abc\"}", "$[\"bar\"]"), (String)"\"abc\"");
        Assert.assertEquals((String)TestJsonExtract.doJsonExtract("{\"fuu\": [0.1, 1, 2]}", "$[\"fuu\"][0]"), (String)"0.1");
        Assert.assertEquals((String)TestJsonExtract.doJsonExtract("{\"fuu\": [0, [100, 101], 2]}", "$[\"fuu\"][1]"), (String)"[100,101]");
        Assert.assertEquals((String)TestJsonExtract.doJsonExtract("{\"fuu\": [0, [100, 101], 2]}", "$[\"fuu\"][1][1]"), (String)"101");
        Assert.assertEquals((String)TestJsonExtract.doJsonExtract("{\"@$fuu\": {\".b.ar\": 1}}", "$[\"@$fuu\"]"), (String)"{\".b.ar\":1}");
        Assert.assertEquals((String)TestJsonExtract.doJsonExtract("{\"fuu..\": 1}", "$[\"fuu..\"]"), (String)"1");
        Assert.assertEquals((String)TestJsonExtract.doJsonExtract("{\"fu*u\": null}", "$[\"fu*u\"]"), (String)"null");
        Assert.assertEquals((String)TestJsonExtract.doJsonExtract("{\",fuu\": 1}", "$[\"bar\"]"), null);
        Assert.assertEquals((String)TestJsonExtract.doJsonExtract("{\",fuu\": [\"\\u0001\"]}", "$[\",fuu\"][0]"), (String)"\"\\u0001\"");
        Assert.assertEquals((String)TestJsonExtract.doJsonExtract("{\":fu:u:\": 1, \":b:ar:\": \"abc\"}", "$[\":b:ar:\"]"), (String)"\"abc\"");
        Assert.assertEquals((String)TestJsonExtract.doJsonExtract("{\"?()fuu\": [0.1, 1, 2]}", "$[\"?()fuu\"][0]"), (String)"0.1");
        Assert.assertEquals((String)TestJsonExtract.doJsonExtract("{\"f?uu\": [0, [100, 101], 2]}", "$[\"f?uu\"][1]"), (String)"[100,101]");
        Assert.assertEquals((String)TestJsonExtract.doJsonExtract("{\"fuu()\": [0, [100, 101], 2]}", "$[\"fuu()\"][1][1]"), (String)"101");
        Assert.assertEquals((String)TestJsonExtract.doJsonExtract("{\"fuu\": {\"bar\": 1}}", "$[\"fuu\"].bar"), (String)"1");
        Assert.assertEquals((String)TestJsonExtract.doJsonExtract("{\"fuu\": {\"bar\": 1}}", "$.fuu[\"bar\"]"), (String)"1");
        Assert.assertEquals((String)TestJsonExtract.doJsonExtract("{\"fuu\": [\"\\u0001\"]}", "$[\"fuu\"][0]"), (String)"\"\\u0001\"");
        Assert.assertEquals((String)TestJsonExtract.doJsonExtract("{\"fuu\": [\"\\u0001\"]}", "$.fuu[0]"), (String)"\"\\u0001\"");
        Assert.assertEquals((String)TestJsonExtract.doJsonExtract("{\"@$fuu\": {\"bar\": 1}}", "$[\"@$fuu\"].bar"), (String)"1");
        Assert.assertEquals((String)TestJsonExtract.doJsonExtract("{\",fuu\": {\"bar\": [\"\\u0001\"]}}", "$[\",fuu\"].bar[0]"), (String)"\"\\u0001\"");
        Assert.assertEquals((String)TestJsonExtract.doJsonExtract("[0, 1, 2]", "$.1"), (String)"1");
        Assert.assertEquals((String)TestJsonExtract.doJsonExtract("[0, 1, 2]", "$[1]"), (String)"1");
        Assert.assertEquals((String)TestJsonExtract.doJsonExtract("[0, 1, 2]", "$[\"1\"]"), (String)"1");
        Assert.assertEquals((String)TestJsonExtract.doJsonExtract("{\"0\" : 0, \"1\" : 1, \"2\" : 2, }", "$.1"), (String)"1");
        Assert.assertEquals((String)TestJsonExtract.doJsonExtract("{\"0\" : 0, \"1\" : 1, \"2\" : 2, }", "$[1]"), (String)"1");
        Assert.assertEquals((String)TestJsonExtract.doJsonExtract("{\"0\" : 0, \"1\" : 1, \"2\" : 2, }", "$[\"1\"]"), (String)"1");
        Assert.assertEquals((String)TestJsonExtract.doJsonExtract("{\"15day\" : 0, \"30day\" : 1, \"90day\" : 2, }", "$.30day"), (String)"1");
        Assert.assertEquals((String)TestJsonExtract.doJsonExtract("{\"15day\" : 0, \"30day\" : 1, \"90day\" : 2, }", "$[30day]"), (String)"1");
        Assert.assertEquals((String)TestJsonExtract.doJsonExtract("{\"15day\" : 0, \"30day\" : 1, \"90day\" : 2, }", "$[\"30day\"]"), (String)"1");
    }

    @Test
    public void testInvalidExtracts() {
        TestJsonExtract.assertInvalidExtract("", "", "Invalid JSON path: ''");
        TestJsonExtract.assertInvalidExtract("{}", "$.bar[2][-1]", "Invalid JSON path: '$.bar[2][-1]'");
        TestJsonExtract.assertInvalidExtract("{}", "$.fuu..bar", "Invalid JSON path: '$.fuu..bar'");
        TestJsonExtract.assertInvalidExtract("{}", "$.", "Invalid JSON path: '$.'");
        TestJsonExtract.assertInvalidExtract("", "$$", "Invalid JSON path: '$$'");
        TestJsonExtract.assertInvalidExtract("", " ", "Invalid JSON path: ' '");
        TestJsonExtract.assertInvalidExtract("", ".", "Invalid JSON path: '.'");
        TestJsonExtract.assertInvalidExtract("{ \"store\": { \"book\": [{ \"title\": \"title\" }] } }", "$.store.book[", "Invalid JSON path: '$.store.book['");
    }

    @Test
    public void testNoAutomaticEncodingDetection() {
        this.assertFunction("JSON_EXTRACT_SCALAR(UTF8(X'00 00 00 00 7b 22 72 22'), '$.x')", (Type)VarcharType.VARCHAR, null);
    }

    private static String doExtract(JsonExtract.JsonExtractor<Slice> jsonExtractor, String json) throws IOException {
        JsonFactory jsonFactory = new JsonFactory();
        JsonParser jsonParser = jsonFactory.createParser(json);
        jsonParser.nextToken();
        Slice extract = (Slice)jsonExtractor.extract(jsonParser);
        return extract == null ? null : extract.toStringUtf8();
    }

    private static String doScalarExtract(String inputJson, String jsonPath) {
        Slice value = (Slice)JsonExtract.extract((Slice)Slices.utf8Slice((String)inputJson), (JsonExtract.JsonExtractor)JsonExtract.generateExtractor((String)jsonPath, (JsonExtract.JsonExtractor)new JsonExtract.ScalarValueJsonExtractor()));
        return value == null ? null : value.toStringUtf8();
    }

    private static String doJsonExtract(String inputJson, String jsonPath) {
        Slice value = (Slice)JsonExtract.extract((Slice)Slices.utf8Slice((String)inputJson), (JsonExtract.JsonExtractor)JsonExtract.generateExtractor((String)jsonPath, (JsonExtract.JsonExtractor)new JsonExtract.JsonValueJsonExtractor()));
        return value == null ? null : value.toStringUtf8();
    }

    private static List<String> tokenizePath(String path) {
        return ImmutableList.copyOf((Iterator)new JsonPathTokenizer(path));
    }

    private static void assertInvalidExtract(String inputJson, String jsonPath, String message) {
        try {
            TestJsonExtract.doJsonExtract(inputJson, jsonPath);
        }
        catch (PrestoException e) {
            Assert.assertEquals((Object)e.getErrorCode(), (Object)StandardErrorCode.INVALID_FUNCTION_ARGUMENT.toErrorCode());
            Assert.assertEquals((String)e.getMessage(), (String)message);
        }
    }
}

