/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.util.Reflection;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Optional;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestParametricScalarImplementationValidation {
    private static final MethodHandle STATE_FACTORY = Reflection.methodHandle(TestParametricScalarImplementationValidation.class, (String)"createState", (Class[])new Class[0]);

    @Test
    public void testConnectorSessionPosition() {
        MethodHandle validFunctionMethodHandle = Reflection.methodHandle(TestParametricScalarImplementationValidation.class, (String)"validConnectorSessionParameterPosition", (Class[])new Class[]{ConnectorSession.class, Long.TYPE, Long.TYPE});
        ScalarFunctionImplementation validFunction = new ScalarFunctionImplementation(false, (List)ImmutableList.of((Object)ScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty((ScalarFunctionImplementation.NullConvention)ScalarFunctionImplementation.NullConvention.RETURN_NULL_ON_NULL), (Object)ScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty((ScalarFunctionImplementation.NullConvention)ScalarFunctionImplementation.NullConvention.RETURN_NULL_ON_NULL)), validFunctionMethodHandle, false);
        Assert.assertEquals((Object)validFunction.getMethodHandle(), (Object)validFunctionMethodHandle);
        try {
            ScalarFunctionImplementation invalidFunction = new ScalarFunctionImplementation(false, (List)ImmutableList.of((Object)ScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty((ScalarFunctionImplementation.NullConvention)ScalarFunctionImplementation.NullConvention.RETURN_NULL_ON_NULL), (Object)ScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty((ScalarFunctionImplementation.NullConvention)ScalarFunctionImplementation.NullConvention.RETURN_NULL_ON_NULL)), Reflection.methodHandle(TestParametricScalarImplementationValidation.class, (String)"invalidConnectorSessionParameterPosition", (Class[])new Class[]{Long.TYPE, Long.TYPE, ConnectorSession.class}), false);
            Assert.fail((String)"expected exception");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"ConnectorSession must be the first argument when instanceFactory is not present");
        }
        MethodHandle validFunctionWithInstanceFactoryMethodHandle = Reflection.methodHandle(TestParametricScalarImplementationValidation.class, (String)"validConnectorSessionParameterPosition", (Class[])new Class[]{Object.class, ConnectorSession.class, Long.TYPE, Long.TYPE});
        ScalarFunctionImplementation validFunctionWithInstanceFactory = new ScalarFunctionImplementation(false, (List)ImmutableList.of((Object)ScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty((ScalarFunctionImplementation.NullConvention)ScalarFunctionImplementation.NullConvention.RETURN_NULL_ON_NULL), (Object)ScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty((ScalarFunctionImplementation.NullConvention)ScalarFunctionImplementation.NullConvention.RETURN_NULL_ON_NULL)), validFunctionWithInstanceFactoryMethodHandle, Optional.of(STATE_FACTORY), false);
        Assert.assertEquals((Object)validFunctionWithInstanceFactory.getMethodHandle(), (Object)validFunctionWithInstanceFactoryMethodHandle);
        try {
            ScalarFunctionImplementation invalidFunctionWithInstanceFactory = new ScalarFunctionImplementation(false, (List)ImmutableList.of((Object)ScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty((ScalarFunctionImplementation.NullConvention)ScalarFunctionImplementation.NullConvention.RETURN_NULL_ON_NULL), (Object)ScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty((ScalarFunctionImplementation.NullConvention)ScalarFunctionImplementation.NullConvention.RETURN_NULL_ON_NULL)), Reflection.methodHandle(TestParametricScalarImplementationValidation.class, (String)"invalidConnectorSessionParameterPosition", (Class[])new Class[]{Object.class, Long.TYPE, Long.TYPE, ConnectorSession.class}), Optional.of(STATE_FACTORY), false);
            Assert.fail((String)"expected exception");
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((String)e.getMessage(), (String)"ConnectorSession must be the second argument when instanceFactory is present");
        }
    }

    public static Object createState() {
        return null;
    }

    public static long validConnectorSessionParameterPosition(ConnectorSession session, long arg1, long arg2) {
        return arg1 + arg2;
    }

    public static long validConnectorSessionParameterPosition(Object state, ConnectorSession session, long arg1, long arg2) {
        return arg1 + arg2;
    }

    public static long invalidConnectorSessionParameterPosition(long arg1, long arg2, ConnectorSession session) {
        return arg1 + arg2;
    }

    public static long invalidConnectorSessionParameterPosition(Object state, long arg1, long arg2, ConnectorSession session) {
        return arg1 + arg2;
    }
}

