/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.security;

import com.facebook.presto.connector.ConnectorId;
import com.facebook.presto.connector.informationSchema.InformationSchemaConnector;
import com.facebook.presto.connector.system.SystemConnector;
import com.facebook.presto.metadata.Catalog;
import com.facebook.presto.metadata.CatalogManager;
import com.facebook.presto.metadata.InMemoryNodeManager;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.metadata.QualifiedObjectName;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.security.AccessControlManager;
import com.facebook.presto.spi.CatalogSchemaName;
import com.facebook.presto.spi.CatalogSchemaTableName;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.connector.Connector;
import com.facebook.presto.spi.connector.ConnectorAccessControl;
import com.facebook.presto.spi.connector.ConnectorContext;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.security.AccessDeniedException;
import com.facebook.presto.spi.security.BasicPrincipal;
import com.facebook.presto.spi.security.Identity;
import com.facebook.presto.spi.security.Privilege;
import com.facebook.presto.spi.security.SystemAccessControl;
import com.facebook.presto.spi.security.SystemAccessControlFactory;
import com.facebook.presto.testing.TestingConnectorContext;
import com.facebook.presto.tpch.TpchConnectorFactory;
import com.facebook.presto.transaction.InMemoryTransactionManager;
import com.facebook.presto.transaction.TransactionBuilder;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.security.Principal;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestAccessControlManager {
    private static final Principal PRINCIPAL = new BasicPrincipal("principal");
    private static final String USER_NAME = "user_name";

    @Test(expectedExceptions={PrestoException.class}, expectedExceptionsMessageRegExp="Presto server is still initializing")
    public void testInitializing() {
        AccessControlManager accessControlManager = new AccessControlManager(InMemoryTransactionManager.createTestTransactionManager());
        accessControlManager.checkCanSetUser(Optional.empty(), "foo");
    }

    @Test
    public void testNoneSystemAccessControl() {
        AccessControlManager accessControlManager = new AccessControlManager(InMemoryTransactionManager.createTestTransactionManager());
        accessControlManager.setSystemAccessControl("allow-all", (Map)ImmutableMap.of());
        accessControlManager.checkCanSetUser(Optional.empty(), USER_NAME);
    }

    @Test
    public void testReadOnlySystemAccessControl() {
        Identity identity = new Identity(USER_NAME, Optional.of(PRINCIPAL));
        QualifiedObjectName tableName = new QualifiedObjectName("catalog", "schema", "table");
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        AccessControlManager accessControlManager = new AccessControlManager(transactionManager);
        accessControlManager.setSystemAccessControl("read-only", (Map)ImmutableMap.of());
        accessControlManager.checkCanSetUser(Optional.of(PRINCIPAL), USER_NAME);
        accessControlManager.checkCanSetSystemSessionProperty(identity, "property");
        TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> {
            accessControlManager.checkCanSetCatalogSessionProperty(transactionId, identity, "catalog", "property");
            accessControlManager.checkCanShowSchemas(transactionId, identity, "catalog");
            accessControlManager.checkCanShowTablesMetadata(transactionId, identity, new CatalogSchemaName("catalog", "schema"));
            accessControlManager.checkCanSelectFromColumns(transactionId, identity, tableName, (Set)ImmutableSet.of((Object)"column"));
            accessControlManager.checkCanCreateViewWithSelectFromColumns(transactionId, identity, tableName, (Set)ImmutableSet.of((Object)"column"));
            ImmutableSet catalogs = ImmutableSet.of((Object)"catalog");
            Assert.assertEquals((Set)accessControlManager.filterCatalogs(identity, (Set)catalogs), (Set)catalogs);
            ImmutableSet schemas = ImmutableSet.of((Object)"schema");
            Assert.assertEquals((Set)accessControlManager.filterSchemas(transactionId, identity, "catalog", (Set)schemas), (Set)schemas);
            ImmutableSet tableNames = ImmutableSet.of((Object)new SchemaTableName("schema", "table"));
            Assert.assertEquals((Set)accessControlManager.filterTables(transactionId, identity, "catalog", (Set)tableNames), (Set)tableNames);
        });
        try {
            TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanInsertIntoTable(transactionId, identity, tableName));
            Assert.fail();
        }
        catch (AccessDeniedException accessDeniedException) {
            // empty catch block
        }
    }

    @Test
    public void testSetAccessControl() {
        AccessControlManager accessControlManager = new AccessControlManager(InMemoryTransactionManager.createTestTransactionManager());
        TestSystemAccessControlFactory accessControlFactory = new TestSystemAccessControlFactory("test");
        accessControlManager.addSystemAccessControlFactory((SystemAccessControlFactory)accessControlFactory);
        accessControlManager.setSystemAccessControl("test", (Map)ImmutableMap.of());
        accessControlManager.checkCanSetUser(Optional.of(PRINCIPAL), USER_NAME);
        Assert.assertEquals((String)accessControlFactory.getCheckedUserName(), (String)USER_NAME);
        Assert.assertEquals(accessControlFactory.getCheckedPrincipal(), Optional.of(PRINCIPAL));
    }

    @Test
    public void testNoCatalogAccessControl() {
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager();
        AccessControlManager accessControlManager = new AccessControlManager(transactionManager);
        TestSystemAccessControlFactory accessControlFactory = new TestSystemAccessControlFactory("test");
        accessControlManager.addSystemAccessControlFactory((SystemAccessControlFactory)accessControlFactory);
        accessControlManager.setSystemAccessControl("test", (Map)ImmutableMap.of());
        TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanSelectFromColumns(transactionId, new Identity(USER_NAME, Optional.of(PRINCIPAL)), new QualifiedObjectName("catalog", "schema", "table"), (Set)ImmutableSet.of((Object)"column")));
    }

    @Test(expectedExceptions={PrestoException.class}, expectedExceptionsMessageRegExp="Access Denied: Cannot select from columns \\[column\\] in table or view schema.table")
    public void testDenyCatalogAccessControl() {
        CatalogManager catalogManager = new CatalogManager();
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager((CatalogManager)catalogManager);
        AccessControlManager accessControlManager = new AccessControlManager(transactionManager);
        TestSystemAccessControlFactory accessControlFactory = new TestSystemAccessControlFactory("test");
        accessControlManager.addSystemAccessControlFactory((SystemAccessControlFactory)accessControlFactory);
        accessControlManager.setSystemAccessControl("test", (Map)ImmutableMap.of());
        ConnectorId connectorId = TestAccessControlManager.registerBogusConnector(catalogManager, transactionManager, (AccessControl)accessControlManager, "catalog");
        accessControlManager.addCatalogAccessControl(connectorId, (ConnectorAccessControl)new DenyConnectorAccessControl());
        TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanSelectFromColumns(transactionId, new Identity(USER_NAME, Optional.of(PRINCIPAL)), new QualifiedObjectName("catalog", "schema", "table"), (Set)ImmutableSet.of((Object)"column")));
    }

    @Test(expectedExceptions={PrestoException.class}, expectedExceptionsMessageRegExp="Access Denied: Cannot select from table secured_catalog.schema.table")
    public void testDenySystemAccessControl() {
        CatalogManager catalogManager = new CatalogManager();
        TransactionManager transactionManager = InMemoryTransactionManager.createTestTransactionManager((CatalogManager)catalogManager);
        AccessControlManager accessControlManager = new AccessControlManager(transactionManager);
        TestSystemAccessControlFactory accessControlFactory = new TestSystemAccessControlFactory("test");
        accessControlManager.addSystemAccessControlFactory((SystemAccessControlFactory)accessControlFactory);
        accessControlManager.setSystemAccessControl("test", (Map)ImmutableMap.of());
        TestAccessControlManager.registerBogusConnector(catalogManager, transactionManager, (AccessControl)accessControlManager, "connector");
        accessControlManager.addCatalogAccessControl(new ConnectorId("connector"), (ConnectorAccessControl)new DenyConnectorAccessControl());
        TransactionBuilder.transaction((TransactionManager)transactionManager, (AccessControl)accessControlManager).execute(transactionId -> accessControlManager.checkCanSelectFromColumns(transactionId, new Identity(USER_NAME, Optional.of(PRINCIPAL)), new QualifiedObjectName("secured_catalog", "schema", "table"), (Set)ImmutableSet.of((Object)"column")));
    }

    private static ConnectorId registerBogusConnector(CatalogManager catalogManager, TransactionManager transactionManager, AccessControl accessControl, String catalogName) {
        ConnectorId connectorId = new ConnectorId(catalogName);
        Connector connector = new TpchConnectorFactory().create(catalogName, (Map)ImmutableMap.of(), (ConnectorContext)new TestingConnectorContext());
        InMemoryNodeManager nodeManager = new InMemoryNodeManager();
        MetadataManager metadata = MetadataManager.createTestMetadataManager((CatalogManager)catalogManager);
        ConnectorId systemId = ConnectorId.createSystemTablesConnectorId((ConnectorId)connectorId);
        catalogManager.registerCatalog(new Catalog(catalogName, connectorId, connector, ConnectorId.createInformationSchemaConnectorId((ConnectorId)connectorId), (Connector)new InformationSchemaConnector(catalogName, (InternalNodeManager)nodeManager, (Metadata)metadata, accessControl), systemId, (Connector)new SystemConnector(systemId, (InternalNodeManager)nodeManager, connector.getSystemTables(), transactionId -> transactionManager.getConnectorTransaction(transactionId, connectorId))));
        return connectorId;
    }

    private static class DenyConnectorAccessControl
    implements ConnectorAccessControl {
        private DenyConnectorAccessControl() {
        }

        public void checkCanSelectFromColumns(ConnectorTransactionHandle transactionHandle, Identity identity, SchemaTableName tableName, Set<String> columnNames) {
            AccessDeniedException.denySelectColumns((String)tableName.toString(), columnNames);
        }

        public void checkCanCreateSchema(ConnectorTransactionHandle transactionHandle, Identity identity, String schemaName) {
            throw new UnsupportedOperationException();
        }

        public void checkCanDropSchema(ConnectorTransactionHandle transactionHandle, Identity identity, String schemaName) {
            throw new UnsupportedOperationException();
        }

        public void checkCanRenameSchema(ConnectorTransactionHandle transactionHandle, Identity identity, String schemaName, String newSchemaName) {
            throw new UnsupportedOperationException();
        }

        public void checkCanCreateTable(ConnectorTransactionHandle transactionHandle, Identity identity, SchemaTableName tableName) {
            throw new UnsupportedOperationException();
        }

        public void checkCanDropTable(ConnectorTransactionHandle transactionHandle, Identity identity, SchemaTableName tableName) {
            throw new UnsupportedOperationException();
        }

        public void checkCanRenameTable(ConnectorTransactionHandle transactionHandle, Identity identity, SchemaTableName tableName, SchemaTableName newTableName) {
            throw new UnsupportedOperationException();
        }

        public void checkCanAddColumn(ConnectorTransactionHandle transactionHandle, Identity identity, SchemaTableName tableName) {
            throw new UnsupportedOperationException();
        }

        public void checkCanDropColumn(ConnectorTransactionHandle transactionHandle, Identity identity, SchemaTableName tableName) {
            throw new UnsupportedOperationException();
        }

        public void checkCanRenameColumn(ConnectorTransactionHandle transactionHandle, Identity identity, SchemaTableName tableName) {
            throw new UnsupportedOperationException();
        }

        public void checkCanInsertIntoTable(ConnectorTransactionHandle transactionHandle, Identity identity, SchemaTableName tableName) {
            throw new UnsupportedOperationException();
        }

        public void checkCanDeleteFromTable(ConnectorTransactionHandle transactionHandle, Identity identity, SchemaTableName tableName) {
            throw new UnsupportedOperationException();
        }

        public void checkCanCreateView(ConnectorTransactionHandle transactionHandle, Identity identity, SchemaTableName viewName) {
            throw new UnsupportedOperationException();
        }

        public void checkCanDropView(ConnectorTransactionHandle transactionHandle, Identity identity, SchemaTableName viewName) {
            throw new UnsupportedOperationException();
        }

        public void checkCanCreateViewWithSelectFromColumns(ConnectorTransactionHandle transactionHandle, Identity identity, SchemaTableName tableName, Set<String> columnNames) {
            throw new UnsupportedOperationException();
        }

        public void checkCanSetCatalogSessionProperty(ConnectorTransactionHandle transactionHandle, Identity identity, String propertyName) {
            throw new UnsupportedOperationException();
        }

        public void checkCanGrantTablePrivilege(ConnectorTransactionHandle transactionHandle, Identity identity, Privilege privilege, SchemaTableName tableName, String grantee, boolean withGrantOption) {
            throw new UnsupportedOperationException();
        }

        public void checkCanRevokeTablePrivilege(ConnectorTransactionHandle transactionHandle, Identity identity, Privilege privilege, SchemaTableName tableName, String revokee, boolean grantOptionFor) {
            throw new UnsupportedOperationException();
        }
    }

    private static class TestSystemAccessControlFactory
    implements SystemAccessControlFactory {
        private final String name;
        private Map<String, String> config;
        private Optional<Principal> checkedPrincipal;
        private String checkedUserName;

        public TestSystemAccessControlFactory(String name) {
            this.name = Objects.requireNonNull(name, "name is null");
        }

        public Map<String, String> getConfig() {
            return this.config;
        }

        public Optional<Principal> getCheckedPrincipal() {
            return this.checkedPrincipal;
        }

        public String getCheckedUserName() {
            return this.checkedUserName;
        }

        public String getName() {
            return this.name;
        }

        public SystemAccessControl create(Map<String, String> config) {
            this.config = config;
            return new SystemAccessControl(){

                public void checkCanSetUser(Optional<Principal> principal, String userName) {
                    checkedPrincipal = principal;
                    checkedUserName = userName;
                }

                public void checkCanAccessCatalog(Identity identity, String catalogName) {
                }

                public void checkCanSetSystemSessionProperty(Identity identity, String propertyName) {
                    throw new UnsupportedOperationException();
                }

                public void checkCanSelectFromColumns(Identity identity, CatalogSchemaTableName table, Set<String> columns) {
                    if (table.getCatalogName().equals("secured_catalog")) {
                        AccessDeniedException.denySelectTable((String)table.toString());
                    }
                }

                public Set<String> filterCatalogs(Identity identity, Set<String> catalogs) {
                    return catalogs;
                }
            };
        }
    }
}

