/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.failureDetector.HeartbeatFailureDetector;
import com.facebook.presto.server.testing.TestingPrestoServer;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.JsonResponseHandler;
import io.airlift.http.client.Request;
import io.airlift.http.client.ResponseHandler;
import io.airlift.http.client.jetty.JettyHttpClient;
import io.airlift.json.JsonCodec;
import io.airlift.testing.Closeables;
import java.io.Closeable;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestNodeResource {
    private TestingPrestoServer server;
    private HttpClient client;

    @BeforeMethod
    public void setup() throws Exception {
        this.server = new TestingPrestoServer();
        this.client = new JettyHttpClient();
    }

    @AfterMethod
    public void teardown() {
        Closeables.closeQuietly((Closeable[])new Closeable[]{this.server});
        Closeables.closeQuietly((Closeable[])new Closeable[]{this.client});
    }

    @Test
    public void testGetAllNodes() {
        List nodes = (List)this.client.execute(Request.Builder.prepareGet().setUri(this.server.resolve("/v1/node")).build(), (ResponseHandler)JsonResponseHandler.createJsonResponseHandler((JsonCodec)JsonCodec.listJsonCodec(HeartbeatFailureDetector.Stats.class)));
        Assert.assertTrue((boolean)nodes.isEmpty());
    }

    @Test
    public void testGetFailedNodes() {
        List nodes = (List)this.client.execute(Request.Builder.prepareGet().setUri(this.server.resolve("/v1/node/failed")).build(), (ResponseHandler)JsonResponseHandler.createJsonResponseHandler((JsonCodec)JsonCodec.listJsonCodec(HeartbeatFailureDetector.Stats.class)));
        Assert.assertTrue((boolean)nodes.isEmpty());
    }
}

