/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.server.PluginManagerConfig;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.resolver.ArtifactResolver;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.testng.annotations.Test;

public class TestPluginManagerConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((PluginManagerConfig)ConfigAssertions.recordDefaults(PluginManagerConfig.class)).setInstalledPluginsDir(new File("plugin")).setPlugins((String)null).setMavenLocalRepository(ArtifactResolver.USER_LOCAL_REPO).setMavenRemoteRepository("http://repo1.maven.org/maven2/"));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"plugin.dir", (Object)"plugins-dir").put((Object)"plugin.bundles", (Object)"a,b,c").put((Object)"maven.repo.local", (Object)"local-repo").put((Object)"maven.repo.remote", (Object)"remote-a,remote-b").build();
        PluginManagerConfig expected = new PluginManagerConfig().setInstalledPluginsDir(new File("plugins-dir")).setPlugins((List)ImmutableList.of((Object)"a", (Object)"b", (Object)"c")).setMavenLocalRepository("local-repo").setMavenRemoteRepository((List)ImmutableList.of((Object)"remote-a", (Object)"remote-b"));
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }
}

