/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.execution.QueryStats;
import com.facebook.presto.execution.resourceGroups.InternalResourceGroup;
import com.facebook.presto.operator.BlockedReason;
import com.facebook.presto.server.BasicQueryInfo;
import com.facebook.presto.server.QueryStateInfo;
import com.facebook.presto.server.ResourceGroupInfo;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.memory.MemoryPoolId;
import com.facebook.presto.spi.resourceGroups.SchedulingPolicy;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.MoreExecutors;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.joda.time.DateTime;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestQueryStateInfo {
    @Test
    public void testQueryStateInfo() {
        InternalResourceGroup.RootInternalResourceGroup root = new InternalResourceGroup.RootInternalResourceGroup("root", (group, export) -> {}, MoreExecutors.directExecutor());
        root.setSoftMemoryLimit(new DataSize(1.0, DataSize.Unit.MEGABYTE));
        root.setMaxQueuedQueries(40);
        root.setHardConcurrencyLimit(0);
        root.setSchedulingPolicy(SchedulingPolicy.WEIGHTED);
        InternalResourceGroup rootA = root.getOrCreateSubGroup("a");
        rootA.setSoftMemoryLimit(new DataSize(1.0, DataSize.Unit.MEGABYTE));
        rootA.setMaxQueuedQueries(20);
        rootA.setHardConcurrencyLimit(0);
        InternalResourceGroup rootAX = rootA.getOrCreateSubGroup("x");
        rootAX.setSoftMemoryLimit(new DataSize(1.0, DataSize.Unit.MEGABYTE));
        rootAX.setMaxQueuedQueries(10);
        rootAX.setHardConcurrencyLimit(0);
        QueryStateInfo query = QueryStateInfo.createQueuedQueryStateInfo((BasicQueryInfo)new BasicQueryInfo(this.createQueryInfo("query_root_a_x", QueryState.QUEUED, "SELECT 1")), Optional.of(rootAX.getId()), Optional.of(ImmutableList.of((Object)rootAX.getInfo(), (Object)rootA.getInfo(), (Object)root.getInfo())));
        Assert.assertEquals((String)query.getQuery(), (String)"SELECT 1");
        Assert.assertEquals((String)query.getQueryId().toString(), (String)"query_root_a_x");
        Assert.assertEquals((Object)query.getQueryState(), (Object)QueryState.QUEUED);
        Assert.assertEquals((Object)query.getProgress(), Optional.empty());
        List chainInfo = (List)query.getPathToRoot().get();
        Assert.assertEquals((int)chainInfo.size(), (int)3);
        ResourceGroupInfo rootAInfo = (ResourceGroupInfo)chainInfo.get(1);
        ResourceGroupInfo expectedRootAInfo = rootA.getInfo();
        Assert.assertEquals((Object)rootAInfo.getId(), (Object)expectedRootAInfo.getId());
        Assert.assertEquals((Object)rootAInfo.getState(), (Object)expectedRootAInfo.getState());
        Assert.assertEquals((int)rootAInfo.getNumRunningQueries(), (int)expectedRootAInfo.getNumRunningQueries());
        Assert.assertEquals((int)rootAInfo.getNumQueuedQueries(), (int)expectedRootAInfo.getNumQueuedQueries());
        ResourceGroupInfo actualRootInfo = (ResourceGroupInfo)chainInfo.get(2);
        ResourceGroupInfo expectedRootInfo = root.getInfo();
        Assert.assertEquals((Object)actualRootInfo.getId(), (Object)expectedRootInfo.getId());
        Assert.assertEquals((Object)actualRootInfo.getState(), (Object)expectedRootInfo.getState());
        Assert.assertEquals((int)actualRootInfo.getNumRunningQueries(), (int)expectedRootInfo.getNumRunningQueries());
        Assert.assertEquals((int)actualRootInfo.getNumQueuedQueries(), (int)expectedRootInfo.getNumQueuedQueries());
    }

    private QueryInfo createQueryInfo(String queryId, QueryState state, String query) {
        return new QueryInfo(new QueryId(queryId), SessionTestUtils.TEST_SESSION.toSessionRepresentation(), state, new MemoryPoolId("reserved"), true, URI.create("1"), (List)ImmutableList.of((Object)"2", (Object)"3"), query, new QueryStats(DateTime.parse((String)"1991-09-06T05:00-05:30"), DateTime.parse((String)"1991-09-06T05:01-05:30"), DateTime.parse((String)"1991-09-06T05:02-05:30"), DateTime.parse((String)"1991-09-06T06:00-05:30"), Duration.valueOf((String)"8m"), Duration.valueOf((String)"7m"), Duration.valueOf((String)"34m"), Duration.valueOf((String)"9m"), Duration.valueOf((String)"10m"), Duration.valueOf((String)"11m"), Duration.valueOf((String)"12m"), 13, 14, 15, 100, 17, 18, 34, 19, 20.0, DataSize.valueOf((String)"21GB"), DataSize.valueOf((String)"22GB"), DataSize.valueOf((String)"23GB"), DataSize.valueOf((String)"24GB"), DataSize.valueOf((String)"25GB"), true, Duration.valueOf((String)"23m"), Duration.valueOf((String)"24m"), Duration.valueOf((String)"26m"), true, (Set)ImmutableSet.of((Object)BlockedReason.WAITING_FOR_MEMORY), DataSize.valueOf((String)"27GB"), 28L, DataSize.valueOf((String)"29GB"), 30L, DataSize.valueOf((String)"31GB"), 32L, DataSize.valueOf((String)"33GB"), (List)ImmutableList.of(), (List)ImmutableList.of()), Optional.empty(), Optional.empty(), Optional.empty(), (Map)ImmutableMap.of(), (Set)ImmutableSet.of(), (Map)ImmutableMap.of(), (Set)ImmutableSet.of(), Optional.empty(), false, "33", Optional.empty(), null, null, (Set)ImmutableSet.of(), Optional.empty(), false, Optional.empty());
    }
}

