/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server;

import com.facebook.presto.client.QueryError;
import com.facebook.presto.client.QueryResults;
import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.server.testing.TestingPrestoServer;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.type.TimeZoneNotSupportedException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.http.client.BodyGenerator;
import io.airlift.http.client.FullJsonResponseHandler;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.HttpUriBuilder;
import io.airlift.http.client.JsonResponseHandler;
import io.airlift.http.client.Request;
import io.airlift.http.client.ResponseHandler;
import io.airlift.http.client.StaticBodyGenerator;
import io.airlift.http.client.StatusResponseHandler;
import io.airlift.http.client.jetty.JettyHttpClient;
import io.airlift.json.JsonCodec;
import io.airlift.testing.Closeables;
import java.io.Closeable;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public class TestServer {
    private static final JsonCodec<QueryResults> QUERY_RESULTS_CODEC = JsonCodec.jsonCodec(QueryResults.class);
    private TestingPrestoServer server;
    private HttpClient client;

    @BeforeMethod
    public void setup() throws Exception {
        this.server = new TestingPrestoServer();
        this.client = new JettyHttpClient();
    }

    @AfterMethod
    public void teardown() {
        Closeables.closeQuietly((Closeable[])new Closeable[]{this.server});
        Closeables.closeQuietly((Closeable[])new Closeable[]{this.client});
    }

    @Test
    public void testInvalidSessionError() {
        String invalidTimeZone = "this_is_an_invalid_time_zone";
        Request request = Request.Builder.preparePost().setHeader("X-Presto-User", "user").setUri(this.uriFor("/v1/statement")).setBodyGenerator((BodyGenerator)StaticBodyGenerator.createStaticBodyGenerator((String)"show catalogs", (Charset)StandardCharsets.UTF_8)).setHeader("X-Presto-Source", "source").setHeader("X-Presto-Catalog", "catalog").setHeader("X-Presto-Schema", "schema").setHeader("X-Presto-Path", "path").setHeader("X-Presto-Time-Zone", invalidTimeZone).build();
        QueryResults queryResults = (QueryResults)this.client.execute(request, (ResponseHandler)JsonResponseHandler.createJsonResponseHandler(QUERY_RESULTS_CODEC));
        while (queryResults.getNextUri() != null) {
            queryResults = (QueryResults)this.client.execute(Request.Builder.prepareGet().setUri(queryResults.getNextUri()).build(), (ResponseHandler)JsonResponseHandler.createJsonResponseHandler(QUERY_RESULTS_CODEC));
        }
        QueryError queryError = queryResults.getError();
        Assert.assertNotNull((Object)queryError);
        TimeZoneNotSupportedException expected = new TimeZoneNotSupportedException(invalidTimeZone);
        Assert.assertEquals((int)queryError.getErrorCode(), (int)expected.getErrorCode().getCode());
        Assert.assertEquals((String)queryError.getErrorName(), (String)expected.getErrorCode().getName());
        Assert.assertEquals((String)queryError.getErrorType(), (String)expected.getErrorCode().getType().name());
        Assert.assertEquals((String)queryError.getMessage(), (String)expected.getMessage());
    }

    @Test
    public void testServerStarts() {
        StatusResponseHandler.StatusResponse response = (StatusResponseHandler.StatusResponse)this.client.execute(Request.Builder.prepareGet().setUri(this.server.resolve("/v1/query")).build(), (ResponseHandler)StatusResponseHandler.createStatusResponseHandler());
        Assert.assertEquals((int)response.getStatusCode(), (int)Response.Status.OK.getStatusCode());
    }

    @Test
    public void testQuery() {
        Request request = Request.Builder.preparePost().setUri(this.uriFor("/v1/statement")).setBodyGenerator((BodyGenerator)StaticBodyGenerator.createStaticBodyGenerator((String)"show catalogs", (Charset)StandardCharsets.UTF_8)).setHeader("X-Presto-User", "user").setHeader("X-Presto-Source", "source").setHeader("X-Presto-Catalog", "catalog").setHeader("X-Presto-Schema", "schema").setHeader("X-Presto-Path", "path").setHeader("X-Presto-Client-Info", "{\"clientVersion\":\"testVersion\"}").addHeader("X-Presto-Session", "query_max_memory=1GB").addHeader("X-Presto-Session", "join_distribution_type=partitioned,hash_partition_count = 43").addHeader("X-Presto-Prepared-Statement", "foo=select * from bar").build();
        QueryResults queryResults = (QueryResults)this.client.execute(request, (ResponseHandler)JsonResponseHandler.createJsonResponseHandler(QUERY_RESULTS_CODEC));
        ImmutableList.Builder data = ImmutableList.builder();
        while (queryResults.getNextUri() != null) {
            queryResults = (QueryResults)this.client.execute(Request.Builder.prepareGet().setUri(queryResults.getNextUri()).build(), (ResponseHandler)JsonResponseHandler.createJsonResponseHandler(QUERY_RESULTS_CODEC));
            if (queryResults.getData() == null) continue;
            data.addAll(queryResults.getData());
        }
        Assert.assertNull((Object)queryResults.getError());
        QueryInfo queryInfo = this.server.getQueryManager().getQueryInfo(new QueryId(queryResults.getId()));
        Assert.assertEquals((Map)queryInfo.getSession().getSystemProperties(), (Map)ImmutableMap.builder().put((Object)"query_max_memory", (Object)"1GB").put((Object)"join_distribution_type", (Object)"partitioned").put((Object)"hash_partition_count", (Object)"43").build());
        Assert.assertEquals((String)((String)queryInfo.getSession().getClientInfo().get()), (String)"{\"clientVersion\":\"testVersion\"}");
        Assert.assertEquals((Map)queryInfo.getSession().getPreparedStatements(), (Map)ImmutableMap.builder().put((Object)"foo", (Object)"select * from bar").build());
        ImmutableList rows = data.build();
        Assert.assertEquals((Collection)rows, (Collection)ImmutableList.of((Object)ImmutableList.of((Object)"system")));
    }

    @Test
    public void testTransactionSupport() {
        Request request = Request.Builder.preparePost().setUri(this.uriFor("/v1/statement")).setBodyGenerator((BodyGenerator)StaticBodyGenerator.createStaticBodyGenerator((String)"start transaction", (Charset)StandardCharsets.UTF_8)).setHeader("X-Presto-User", "user").setHeader("X-Presto-Source", "source").setHeader("X-Presto-Transaction-Id", "none").build();
        FullJsonResponseHandler.JsonResponse queryResults = (FullJsonResponseHandler.JsonResponse)this.client.execute(request, (ResponseHandler)FullJsonResponseHandler.createFullJsonResponseHandler(QUERY_RESULTS_CODEC));
        ImmutableList.Builder data = ImmutableList.builder();
        while (true) {
            if (((QueryResults)queryResults.getValue()).getData() != null) {
                data.addAll(((QueryResults)queryResults.getValue()).getData());
            }
            if (((QueryResults)queryResults.getValue()).getNextUri() == null) break;
            queryResults = (FullJsonResponseHandler.JsonResponse)this.client.execute(Request.Builder.prepareGet().setUri(((QueryResults)queryResults.getValue()).getNextUri()).build(), (ResponseHandler)FullJsonResponseHandler.createFullJsonResponseHandler(QUERY_RESULTS_CODEC));
        }
        Assert.assertNull((Object)((QueryResults)queryResults.getValue()).getError());
        Assert.assertNotNull((Object)queryResults.getHeader("X-Presto-Started-Transaction-Id"));
    }

    @Test
    public void testNoTransactionSupport() {
        Request request = Request.Builder.preparePost().setUri(this.uriFor("/v1/statement")).setBodyGenerator((BodyGenerator)StaticBodyGenerator.createStaticBodyGenerator((String)"start transaction", (Charset)StandardCharsets.UTF_8)).setHeader("X-Presto-User", "user").setHeader("X-Presto-Source", "source").build();
        QueryResults queryResults = (QueryResults)this.client.execute(request, (ResponseHandler)JsonResponseHandler.createJsonResponseHandler(QUERY_RESULTS_CODEC));
        while (queryResults.getNextUri() != null) {
            queryResults = (QueryResults)this.client.execute(Request.Builder.prepareGet().setUri(queryResults.getNextUri()).build(), (ResponseHandler)JsonResponseHandler.createJsonResponseHandler(QUERY_RESULTS_CODEC));
        }
        Assert.assertNotNull((Object)queryResults.getError());
        Assert.assertEquals((int)queryResults.getError().getErrorCode(), (int)StandardErrorCode.INCOMPATIBLE_CLIENT.toErrorCode().getCode());
    }

    public URI uriFor(String path) {
        return HttpUriBuilder.uriBuilderFrom((URI)this.server.getBaseUrl()).replacePath(path).build();
    }
}

