/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spiller;

import com.facebook.presto.block.BlockEncodingManager;
import com.facebook.presto.execution.buffer.PagesSerde;
import com.facebook.presto.execution.buffer.PagesSerdeFactory;
import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.operator.PageAssertions;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.BlockEncoding;
import com.facebook.presto.spi.block.BlockEncodingSerde;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.spiller.FileSingleStreamSpiller;
import com.facebook.presto.spiller.SpillerStats;
import com.facebook.presto.type.TypeRegistry;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.io.Files;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.File;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

public class TestFileSingleStreamSpiller {
    private static final List<Type> TYPES = ImmutableList.of((Object)BigintType.BIGINT, (Object)DoubleType.DOUBLE, (Object)VarbinaryType.VARBINARY);
    private final ListeningExecutorService executor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool());
    private final File spillPath = Files.createTempDir();

    @AfterMethod
    public void tearDown() throws Exception {
        this.executor.shutdown();
        MoreFiles.deleteRecursively((Path)this.spillPath.toPath(), (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
    }

    @Test
    public void testSpill() throws Exception {
        PagesSerdeFactory serdeFactory = new PagesSerdeFactory((BlockEncodingSerde)new BlockEncodingManager((TypeManager)new TypeRegistry(), new BlockEncoding[0]), false);
        PagesSerde serde = serdeFactory.createPagesSerde();
        SpillerStats spillerStats = new SpillerStats();
        LocalMemoryContext memoryContext = AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext("test");
        FileSingleStreamSpiller spiller = new FileSingleStreamSpiller(serde, this.executor, this.spillPath.toPath(), spillerStats, bytes -> {}, memoryContext);
        Page page = this.buildPage();
        Assert.assertEquals((long)memoryContext.getBytes(), (long)4096L);
        spiller.spill(page).get();
        spiller.spill((Iterator)Iterators.forArray((Object[])new Page[]{page, page, page})).get();
        Assert.assertEquals((int)MoreFiles.listFiles((Path)this.spillPath.toPath()).size(), (int)1);
        Iterator spilledPagesIterator = spiller.getSpilledPages();
        Assert.assertEquals((long)memoryContext.getBytes(), (long)4096L);
        ImmutableList spilledPages = ImmutableList.copyOf((Iterator)spilledPagesIterator);
        Assert.assertEquals((int)4, (int)spilledPages.size());
        for (int i = 0; i < 4; ++i) {
            PageAssertions.assertPageEquals(TYPES, page, (Page)spilledPages.get(i));
        }
        spiller.close();
        Assert.assertEquals((int)MoreFiles.listFiles((Path)this.spillPath.toPath()).size(), (int)0);
        Assert.assertEquals((long)memoryContext.getBytes(), (long)0L);
    }

    private Page buildPage() {
        BlockBuilder col1 = BigintType.BIGINT.createBlockBuilder(null, 1);
        BlockBuilder col2 = DoubleType.DOUBLE.createBlockBuilder(null, 1);
        BlockBuilder col3 = VarbinaryType.VARBINARY.createBlockBuilder(null, 1);
        col1.writeLong(42L).closeEntry();
        col2.writeLong(Double.doubleToLongBits(43.0)).closeEntry();
        col3.writeLong(Double.doubleToLongBits(43.0)).writeLong(1L).closeEntry();
        return new Page(new Block[]{col1.build(), col2.build(), col3.build()});
    }
}

