/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql;

import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.block.BlockAssertions;
import com.facebook.presto.block.BlockEncodingManager;
import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockEncoding;
import com.facebook.presto.spi.block.BlockEncodingSerde;
import com.facebook.presto.spi.block.IntArrayBlock;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.type.ArrayType;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.RowType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.relational.CallExpression;
import com.facebook.presto.sql.relational.ConstantExpression;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.RowExpression;
import com.facebook.presto.sql.relational.Signatures;
import com.facebook.presto.sql.relational.optimizer.ExpressionOptimizer;
import com.facebook.presto.type.JsonType;
import com.facebook.presto.type.TypeRegistry;
import com.facebook.presto.util.StructuralTestUtil;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import io.airlift.testing.Assertions;
import java.util.Collection;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestExpressionOptimizer {
    private TypeRegistry typeManager;
    private ExpressionOptimizer optimizer;

    @BeforeClass
    public void setUp() {
        this.typeManager = new TypeRegistry();
        this.optimizer = new ExpressionOptimizer(new FunctionRegistry((TypeManager)this.typeManager, (BlockEncodingSerde)new BlockEncodingManager((TypeManager)this.typeManager, new BlockEncoding[0]), new FeaturesConfig()), (TypeManager)this.typeManager, SessionTestUtils.TEST_SESSION);
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.typeManager = null;
        this.optimizer = null;
    }

    @Test(timeOut=10000L)
    public void testPossibleExponentialOptimizationTime() {
        ConstantExpression expression = Expressions.constant((Object)1L, (Type)BigintType.BIGINT);
        for (int i = 0; i < 100; ++i) {
            Signature signature = Signature.internalOperator((String)OperatorType.ADD.name(), (TypeSignature)TypeSignature.parseTypeSignature((String)"bigint"), (TypeSignature[])new TypeSignature[]{TypeSignature.parseTypeSignature((String)"bigint"), TypeSignature.parseTypeSignature((String)"bigint")});
            expression = new CallExpression(signature, (Type)BigintType.BIGINT, (List)ImmutableList.of((Object)expression, (Object)Expressions.constant((Object)1L, (Type)BigintType.BIGINT)));
        }
        this.optimizer.optimize((RowExpression)expression);
    }

    @Test
    public void testIfConstantOptimization() {
        Assert.assertEquals((Object)this.optimizer.optimize(TestExpressionOptimizer.ifExpression((RowExpression)Expressions.constant((Object)true, (Type)BooleanType.BOOLEAN), 1L, 2L)), (Object)Expressions.constant((Object)1L, (Type)BigintType.BIGINT));
        Assert.assertEquals((Object)this.optimizer.optimize(TestExpressionOptimizer.ifExpression((RowExpression)Expressions.constant((Object)false, (Type)BooleanType.BOOLEAN), 1L, 2L)), (Object)Expressions.constant((Object)2L, (Type)BigintType.BIGINT));
        Assert.assertEquals((Object)this.optimizer.optimize(TestExpressionOptimizer.ifExpression((RowExpression)Expressions.constant(null, (Type)BooleanType.BOOLEAN), 1L, 2L)), (Object)Expressions.constant((Object)2L, (Type)BigintType.BIGINT));
        Signature bigintEquals = Signature.internalOperator((String)OperatorType.EQUAL.name(), (TypeSignature)BooleanType.BOOLEAN.getTypeSignature(), (TypeSignature[])new TypeSignature[]{BigintType.BIGINT.getTypeSignature(), BigintType.BIGINT.getTypeSignature()});
        CallExpression condition = new CallExpression(bigintEquals, (Type)BooleanType.BOOLEAN, (List)ImmutableList.of((Object)Expressions.constant((Object)3L, (Type)BigintType.BIGINT), (Object)Expressions.constant((Object)3L, (Type)BigintType.BIGINT)));
        Assert.assertEquals((Object)this.optimizer.optimize(TestExpressionOptimizer.ifExpression((RowExpression)condition, 1L, 2L)), (Object)Expressions.constant((Object)1L, (Type)BigintType.BIGINT));
    }

    @Test
    public void testCastWithJsonParseOptimization() {
        Signature jsonParseSignature = new Signature("json_parse", FunctionKind.SCALAR, JsonType.JSON.getTypeSignature(), (List)ImmutableList.of((Object)VarcharType.VARCHAR.getTypeSignature()));
        Signature jsonCastSignature = new Signature(Signatures.CAST, FunctionKind.SCALAR, TypeSignature.parseTypeSignature((String)"array(integer)"), (List)ImmutableList.of((Object)JsonType.JSON.getTypeSignature()));
        CallExpression jsonCastExpression = new CallExpression(jsonCastSignature, (Type)new ArrayType((Type)IntegerType.INTEGER), (List)ImmutableList.of((Object)Expressions.call((Signature)jsonParseSignature, (Type)JsonType.JSON, (RowExpression[])new RowExpression[]{Expressions.constant((Object)Slices.utf8Slice((String)"[1, 2]"), (Type)VarcharType.VARCHAR)})));
        RowExpression resultExpression = this.optimizer.optimize((RowExpression)jsonCastExpression);
        Assertions.assertInstanceOf((Object)resultExpression, ConstantExpression.class);
        Object resultValue = ((ConstantExpression)resultExpression).getValue();
        Assertions.assertInstanceOf((Object)resultValue, IntArrayBlock.class);
        Assert.assertEquals(BlockAssertions.toValues((Type)IntegerType.INTEGER, (Block)((IntArrayBlock)resultValue)), (Collection)ImmutableList.of((Object)1, (Object)2));
        jsonCastSignature = new Signature(Signatures.CAST, FunctionKind.SCALAR, TypeSignature.parseTypeSignature((String)"array(varchar)"), (List)ImmutableList.of((Object)JsonType.JSON.getTypeSignature()));
        jsonCastExpression = new CallExpression(jsonCastSignature, (Type)new ArrayType((Type)VarcharType.VARCHAR), (List)ImmutableList.of((Object)Expressions.call((Signature)jsonParseSignature, (Type)JsonType.JSON, (RowExpression[])new RowExpression[]{Expressions.field((int)1, (Type)VarcharType.VARCHAR)})));
        resultExpression = this.optimizer.optimize((RowExpression)jsonCastExpression);
        Assert.assertEquals((Object)resultExpression, (Object)Expressions.call((Signature)Signature.internalScalarFunction((String)"$internal$json_string_to_array_cast", (TypeSignature)TypeSignature.parseTypeSignature((String)"array(varchar)"), (TypeSignature[])new TypeSignature[]{TypeSignature.parseTypeSignature((String)"varchar")}), (Type)new ArrayType((Type)VarcharType.VARCHAR), (RowExpression[])new RowExpression[]{Expressions.field((int)1, (Type)VarcharType.VARCHAR)}));
        jsonCastSignature = new Signature(Signatures.CAST, FunctionKind.SCALAR, TypeSignature.parseTypeSignature((String)"map(integer,varchar)"), (List)ImmutableList.of((Object)JsonType.JSON.getTypeSignature()));
        jsonCastExpression = new CallExpression(jsonCastSignature, (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)VarcharType.VARCHAR), (List)ImmutableList.of((Object)Expressions.call((Signature)jsonParseSignature, (Type)JsonType.JSON, (RowExpression[])new RowExpression[]{Expressions.field((int)1, (Type)VarcharType.VARCHAR)})));
        resultExpression = this.optimizer.optimize((RowExpression)jsonCastExpression);
        Assert.assertEquals((Object)resultExpression, (Object)Expressions.call((Signature)Signature.internalScalarFunction((String)"$internal$json_string_to_map_cast", (TypeSignature)TypeSignature.parseTypeSignature((String)"map(integer,varchar)"), (TypeSignature[])new TypeSignature[]{TypeSignature.parseTypeSignature((String)"varchar")}), (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)VarcharType.VARCHAR), (RowExpression[])new RowExpression[]{Expressions.field((int)1, (Type)VarcharType.VARCHAR)}));
        jsonCastSignature = new Signature(Signatures.CAST, FunctionKind.SCALAR, TypeSignature.parseTypeSignature((String)"row(varchar,bigint)"), (List)ImmutableList.of((Object)JsonType.JSON.getTypeSignature()));
        jsonCastExpression = new CallExpression(jsonCastSignature, (Type)RowType.anonymous((List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT)), (List)ImmutableList.of((Object)Expressions.call((Signature)jsonParseSignature, (Type)JsonType.JSON, (RowExpression[])new RowExpression[]{Expressions.field((int)1, (Type)VarcharType.VARCHAR)})));
        resultExpression = this.optimizer.optimize((RowExpression)jsonCastExpression);
        Assert.assertEquals((Object)resultExpression, (Object)Expressions.call((Signature)Signature.internalScalarFunction((String)"$internal$json_string_to_row_cast", (TypeSignature)TypeSignature.parseTypeSignature((String)"row(varchar,bigint)"), (TypeSignature[])new TypeSignature[]{TypeSignature.parseTypeSignature((String)"varchar")}), (Type)RowType.anonymous((List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BigintType.BIGINT)), (RowExpression[])new RowExpression[]{Expressions.field((int)1, (Type)VarcharType.VARCHAR)}));
    }

    private static RowExpression ifExpression(RowExpression condition, long trueValue, long falseValue) {
        Signature signature = new Signature("IF", FunctionKind.SCALAR, BigintType.BIGINT.getTypeSignature(), new TypeSignature[]{BooleanType.BOOLEAN.getTypeSignature(), BigintType.BIGINT.getTypeSignature(), BigintType.BIGINT.getTypeSignature()});
        return new CallExpression(signature, (Type)BigintType.BIGINT, (List)ImmutableList.of((Object)condition, (Object)Expressions.constant((Object)trueValue, (Type)BigintType.BIGINT), (Object)Expressions.constant((Object)falseValue, (Type)BigintType.BIGINT)));
    }
}

