/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql;

import com.facebook.presto.sql.SqlEnvironmentConfig;
import com.facebook.presto.sql.SqlPath;
import com.facebook.presto.sql.parser.ParsingException;
import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.testing.ConfigAssertions;
import java.util.Map;
import org.testng.annotations.Test;

public class TestSqlEnvironmentConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((SqlEnvironmentConfig)ConfigAssertions.recordDefaults(SqlEnvironmentConfig.class)).setPath(null));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"sql.path", (Object)"a.b, c.d").build();
        SqlEnvironmentConfig expected = new SqlEnvironmentConfig().setPath("a.b, c.d");
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }

    @Test(expectedExceptions={ParsingException.class}, expectedExceptionsMessageRegExp="\\Qline 1:9: mismatched input '.'. Expecting: ',', <EOF>\\E")
    public void testInvalidPath() {
        SqlEnvironmentConfig config = new SqlEnvironmentConfig().setPath("too.many.qualifiers");
        new SqlPath(config.getPath()).getParsedPath();
    }
}

