/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql;

import com.facebook.presto.Session;
import com.facebook.presto.SessionTestUtils;
import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.DecimalType;
import com.facebook.presto.spi.type.Decimals;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.sql.analyzer.ExpressionAnalyzer;
import com.facebook.presto.sql.analyzer.Scope;
import com.facebook.presto.sql.planner.ExpressionInterpreter;
import com.facebook.presto.sql.planner.LiteralEncoder;
import com.facebook.presto.sql.planner.NoOpSymbolResolver;
import com.facebook.presto.sql.planner.SymbolResolver;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.iterative.rule.test.PlanBuilder;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.RowExpression;
import com.facebook.presto.sql.relational.SqlToRowExpressionTranslator;
import com.facebook.presto.sql.tree.CoalesceExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeRef;
import com.facebook.presto.testing.assertions.Assert;
import com.google.common.collect.ImmutableMap;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Map;
import org.testng.annotations.Test;

public class TestSqlToRowExpressionTranslator {
    private final Metadata metadata = MetadataManager.createTestMetadataManager();
    private final LiteralEncoder literalEncoder = new LiteralEncoder(this.metadata.getBlockEncodingSerde());

    @Test(timeOut=10000L)
    public void testPossibleExponentialOptimizationTime() {
        LongLiteral expression = new LongLiteral("1");
        ImmutableMap.Builder types = ImmutableMap.builder();
        types.put((Object)NodeRef.of((Node)expression), (Object)BigintType.BIGINT);
        for (int i = 0; i < 100; ++i) {
            expression = new CoalesceExpression((Expression)expression, (Expression)new LongLiteral("2"), new Expression[0]);
            types.put((Object)NodeRef.of((Node)expression), (Object)BigintType.BIGINT);
        }
        this.translateAndOptimize((Expression)expression, (Map<NodeRef<Expression>, Type>)types.build());
    }

    @Test
    public void testOptimizeDecimalLiteral() {
        Assert.assertEquals((Object)this.translateAndOptimize(PlanBuilder.expression("CAST(NULL AS DECIMAL(7,2))")), (Object)Expressions.constant(null, (Type)DecimalType.createDecimalType((int)7, (int)2)));
        Assert.assertEquals((Object)this.translateAndOptimize(PlanBuilder.expression("DECIMAL '42'")), (Object)Expressions.constant((Object)42L, (Type)DecimalType.createDecimalType((int)2, (int)0)));
        Assert.assertEquals((Object)this.translateAndOptimize(PlanBuilder.expression("CAST(42 AS DECIMAL(7,2))")), (Object)Expressions.constant((Object)4200L, (Type)DecimalType.createDecimalType((int)7, (int)2)));
        Assert.assertEquals((Object)this.translateAndOptimize(this.simplifyExpression(PlanBuilder.expression("CAST(42 AS DECIMAL(7,2))"))), (Object)Expressions.constant((Object)4200L, (Type)DecimalType.createDecimalType((int)7, (int)2)));
        Assert.assertEquals((Object)this.translateAndOptimize(PlanBuilder.expression("CAST(NULL AS DECIMAL(35,2))")), (Object)Expressions.constant(null, (Type)DecimalType.createDecimalType((int)35, (int)2)));
        Assert.assertEquals((Object)this.translateAndOptimize(PlanBuilder.expression("DECIMAL '123456789012345678901234567890'")), (Object)Expressions.constant((Object)Decimals.encodeScaledValue((BigDecimal)new BigDecimal("123456789012345678901234567890")), (Type)DecimalType.createDecimalType((int)30, (int)0)));
        Assert.assertEquals((Object)this.translateAndOptimize(PlanBuilder.expression("CAST(DECIMAL '123456789012345678901234567890' AS DECIMAL(35,2))")), (Object)Expressions.constant((Object)Decimals.encodeScaledValue((BigDecimal)new BigDecimal("123456789012345678901234567890.00")), (Type)DecimalType.createDecimalType((int)35, (int)2)));
        Assert.assertEquals((Object)this.translateAndOptimize(this.simplifyExpression(PlanBuilder.expression("CAST(DECIMAL '123456789012345678901234567890' AS DECIMAL(35,2))"))), (Object)Expressions.constant((Object)Decimals.encodeScaledValue((BigDecimal)new BigDecimal("123456789012345678901234567890.00")), (Type)DecimalType.createDecimalType((int)35, (int)2)));
    }

    private RowExpression translateAndOptimize(Expression expression) {
        return this.translateAndOptimize(expression, this.getExpressionTypes(expression));
    }

    private RowExpression translateAndOptimize(Expression expression, Map<NodeRef<Expression>, Type> types) {
        return SqlToRowExpressionTranslator.translate((Expression)expression, (FunctionKind)FunctionKind.SCALAR, types, (FunctionRegistry)this.metadata.getFunctionRegistry(), (TypeManager)this.metadata.getTypeManager(), (Session)SessionTestUtils.TEST_SESSION, (boolean)true);
    }

    private Expression simplifyExpression(Expression expression) {
        Map<NodeRef<Expression>, Type> expressionTypes = this.getExpressionTypes(expression);
        ExpressionInterpreter interpreter = ExpressionInterpreter.expressionOptimizer((Expression)expression, (Metadata)this.metadata, (Session)SessionTestUtils.TEST_SESSION, expressionTypes);
        Object value = interpreter.optimize((SymbolResolver)NoOpSymbolResolver.INSTANCE);
        return this.literalEncoder.toExpression(value, expressionTypes.get(NodeRef.of((Node)expression)));
    }

    private Map<NodeRef<Expression>, Type> getExpressionTypes(Expression expression) {
        ExpressionAnalyzer expressionAnalyzer = ExpressionAnalyzer.createWithoutSubqueries((FunctionRegistry)this.metadata.getFunctionRegistry(), (TypeManager)this.metadata.getTypeManager(), (Session)SessionTestUtils.TEST_SESSION, (TypeProvider)TypeProvider.empty(), Collections.emptyList(), node -> new IllegalStateException("Expected node: %s" + node), (boolean)false);
        expressionAnalyzer.analyze(expression, Scope.create());
        return expressionAnalyzer.getExpressionTypes();
    }
}

