/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.operator.aggregation.arrayagg.ArrayAggGroupImplementation;
import com.facebook.presto.operator.aggregation.histogram.HistogramGroupImplementation;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.analyzer.RegexLibrary;
import com.google.common.collect.ImmutableMap;
import io.airlift.configuration.ConfigurationFactory;
import io.airlift.configuration.testing.ConfigAssertions;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.testng.annotations.Test;

public class TestFeaturesConfig {
    @Test
    public void testDefaults() {
        ConfigAssertions.assertRecordedDefaults((Object)((FeaturesConfig)ConfigAssertions.recordDefaults(FeaturesConfig.class)).setCpuCostWeight(75.0).setMemoryCostWeight(10.0).setNetworkCostWeight(15.0).setDistributedIndexJoinsEnabled(false).setJoinDistributionType(FeaturesConfig.JoinDistributionType.PARTITIONED).setGroupedExecutionForAggregationEnabled(false).setConcurrentLifespansPerTask(0).setFastInequalityJoins(true).setColocatedJoinsEnabled(false).setSpatialJoinsEnabled(true).setJoinReorderingStrategy(FeaturesConfig.JoinReorderingStrategy.ELIMINATE_CROSS_JOINS).setMaxReorderedJoins(9).setRedistributeWrites(true).setScaleWriters(false).setWriterMinSize(new DataSize(32.0, DataSize.Unit.MEGABYTE)).setOptimizeMetadataQueries(false).setOptimizeHashGeneration(true).setPushTableWriteThroughUnion(true).setDictionaryAggregation(false).setLegacyArrayAgg(false).setGroupByUsesEqualTo(false).setLegacyMapSubscript(false).setRegexLibrary(RegexLibrary.JONI).setRe2JDfaStatesLimit(Integer.MAX_VALUE).setRe2JDfaRetries(5).setSpillEnabled(false).setAggregationOperatorUnspillMemoryLimit(DataSize.valueOf((String)"4MB")).setSpillerSpillPaths("").setSpillerThreads(4).setSpillMaxUsedSpaceThreshold(0.9).setMemoryRevokingThreshold(0.9).setMemoryRevokingTarget(0.5).setOptimizeMixedDistinctAggregations(false).setLegacyLogFunction(false).setIterativeOptimizerEnabled(true).setIterativeOptimizerTimeout(new Duration(3.0, TimeUnit.MINUTES)).setEnableNewStatsCalculator(true).setExchangeCompressionEnabled(false).setLegacyTimestamp(true).setLegacyRoundNBigint(false).setLegacyRowFieldOrdinalAccess(false).setLegacyCharToVarcharCoercion(false).setEnableIntermediateAggregations(false).setPushAggregationThroughJoin(true).setParseDecimalLiteralsAsDouble(false).setForceSingleNodeOutput(true).setPagesIndexEagerCompactionEnabled(false).setFilterAndProjectMinOutputPageSize(new DataSize(500.0, DataSize.Unit.KILOBYTE)).setFilterAndProjectMinOutputPageRowCount(256).setUseMarkDistinct(true).setPreferPartialAggregation(true).setHistogramGroupImplementation(HistogramGroupImplementation.NEW).setArrayAggGroupImplementation(ArrayAggGroupImplementation.NEW).setDistributedSortEnabled(true).setMaxGroupingSets(2048).setLegacyUnnestArrayRows(false).setPreAllocateMemoryThreshold(DataSize.succinctBytes((long)0L)));
    }

    @Test
    public void testExplicitPropertyMappings() {
        ImmutableMap properties = new ImmutableMap.Builder().put((Object)"cpu-cost-weight", (Object)"0.4").put((Object)"memory-cost-weight", (Object)"0.3").put((Object)"network-cost-weight", (Object)"0.2").put((Object)"experimental.iterative-optimizer-enabled", (Object)"false").put((Object)"experimental.iterative-optimizer-timeout", (Object)"10s").put((Object)"experimental.enable-new-stats-calculator", (Object)"false").put((Object)"deprecated.legacy-array-agg", (Object)"true").put((Object)"deprecated.legacy-log-function", (Object)"true").put((Object)"deprecated.group-by-uses-equal", (Object)"true").put((Object)"deprecated.legacy-map-subscript", (Object)"true").put((Object)"deprecated.legacy-round-n-bigint", (Object)"true").put((Object)"deprecated.legacy-row-field-ordinal-access", (Object)"true").put((Object)"deprecated.legacy-char-to-varchar-coercion", (Object)"true").put((Object)"distributed-index-joins-enabled", (Object)"true").put((Object)"join-distribution-type", (Object)"BROADCAST").put((Object)"grouped-execution-for-aggregation-enabled", (Object)"true").put((Object)"concurrent-lifespans-per-task", (Object)"1").put((Object)"fast-inequality-joins", (Object)"false").put((Object)"colocated-joins-enabled", (Object)"true").put((Object)"spatial-joins-enabled", (Object)"false").put((Object)"optimizer.join-reordering-strategy", (Object)"NONE").put((Object)"optimizer.max-reordered-joins", (Object)"5").put((Object)"redistribute-writes", (Object)"false").put((Object)"scale-writers", (Object)"true").put((Object)"writer-min-size", (Object)"42GB").put((Object)"optimizer.optimize-metadata-queries", (Object)"true").put((Object)"optimizer.optimize-hash-generation", (Object)"false").put((Object)"optimizer.optimize-mixed-distinct-aggregations", (Object)"true").put((Object)"optimizer.push-table-write-through-union", (Object)"false").put((Object)"optimizer.dictionary-aggregation", (Object)"true").put((Object)"optimizer.push-aggregation-through-join", (Object)"false").put((Object)"regex-library", (Object)"RE2J").put((Object)"re2j.dfa-states-limit", (Object)"42").put((Object)"re2j.dfa-retries", (Object)"42").put((Object)"experimental.spill-enabled", (Object)"true").put((Object)"experimental.aggregation-operator-unspill-memory-limit", (Object)"100MB").put((Object)"experimental.spiller-spill-path", (Object)"/tmp/custom/spill/path1,/tmp/custom/spill/path2").put((Object)"experimental.spiller-threads", (Object)"42").put((Object)"experimental.spiller-max-used-space-threshold", (Object)"0.8").put((Object)"experimental.memory-revoking-threshold", (Object)"0.2").put((Object)"experimental.memory-revoking-target", (Object)"0.8").put((Object)"exchange.compression-enabled", (Object)"true").put((Object)"deprecated.legacy-timestamp", (Object)"false").put((Object)"optimizer.enable-intermediate-aggregations", (Object)"true").put((Object)"parse-decimal-literals-as-double", (Object)"true").put((Object)"optimizer.force-single-node-output", (Object)"false").put((Object)"pages-index.eager-compaction-enabled", (Object)"true").put((Object)"experimental.filter-and-project-min-output-page-size", (Object)"1MB").put((Object)"experimental.filter-and-project-min-output-page-row-count", (Object)"2048").put((Object)"histogram.implementation", (Object)"LEGACY").put((Object)"arrayagg.implementation", (Object)"LEGACY").put((Object)"optimizer.use-mark-distinct", (Object)"false").put((Object)"optimizer.prefer-partial-aggregation", (Object)"false").put((Object)"distributed-sort", (Object)"false").put((Object)"analyzer.max-grouping-sets", (Object)"2047").put((Object)"deprecated.legacy-unnest-array-rows", (Object)"true").put((Object)"experimental.preallocate-memory-threshold", (Object)"5TB").build();
        FeaturesConfig expected = new FeaturesConfig().setCpuCostWeight(0.4).setMemoryCostWeight(0.3).setNetworkCostWeight(0.2).setIterativeOptimizerEnabled(false).setIterativeOptimizerTimeout(new Duration(10.0, TimeUnit.SECONDS)).setEnableNewStatsCalculator(false).setDistributedIndexJoinsEnabled(true).setJoinDistributionType(FeaturesConfig.JoinDistributionType.BROADCAST).setGroupedExecutionForAggregationEnabled(true).setConcurrentLifespansPerTask(1).setFastInequalityJoins(false).setColocatedJoinsEnabled(true).setSpatialJoinsEnabled(false).setJoinReorderingStrategy(FeaturesConfig.JoinReorderingStrategy.NONE).setMaxReorderedJoins(5).setRedistributeWrites(false).setScaleWriters(true).setWriterMinSize(new DataSize(42.0, DataSize.Unit.GIGABYTE)).setOptimizeMetadataQueries(true).setOptimizeHashGeneration(false).setOptimizeMixedDistinctAggregations(true).setPushTableWriteThroughUnion(false).setDictionaryAggregation(true).setPushAggregationThroughJoin(false).setLegacyArrayAgg(true).setGroupByUsesEqualTo(true).setLegacyMapSubscript(true).setRegexLibrary(RegexLibrary.RE2J).setRe2JDfaStatesLimit(42).setRe2JDfaRetries(42).setSpillEnabled(true).setAggregationOperatorUnspillMemoryLimit(DataSize.valueOf((String)"100MB")).setSpillerSpillPaths("/tmp/custom/spill/path1,/tmp/custom/spill/path2").setSpillerThreads(42).setSpillMaxUsedSpaceThreshold(0.8).setMemoryRevokingThreshold(0.2).setMemoryRevokingTarget(0.8).setLegacyLogFunction(true).setExchangeCompressionEnabled(true).setLegacyTimestamp(false).setLegacyRoundNBigint(true).setLegacyRowFieldOrdinalAccess(true).setLegacyCharToVarcharCoercion(true).setEnableIntermediateAggregations(true).setParseDecimalLiteralsAsDouble(true).setForceSingleNodeOutput(false).setPagesIndexEagerCompactionEnabled(true).setFilterAndProjectMinOutputPageSize(new DataSize(1.0, DataSize.Unit.MEGABYTE)).setFilterAndProjectMinOutputPageRowCount(2048).setUseMarkDistinct(false).setPreferPartialAggregation(false).setHistogramGroupImplementation(HistogramGroupImplementation.LEGACY).setArrayAggGroupImplementation(ArrayAggGroupImplementation.LEGACY).setDistributedSortEnabled(false).setMaxGroupingSets(2047).setLegacyUnnestArrayRows(true).setPreAllocateMemoryThreshold(DataSize.valueOf((String)"5TB"));
        ConfigAssertions.assertFullMapping((Map)properties, (Object)expected);
    }

    @Test(expectedExceptions={RuntimeException.class}, expectedExceptionsMessageRegExp=".*\\Qexperimental.spiller-spill-path must be configured when experimental.spill-enabled is set to true\\E.*")
    public void testValidateSpillConfiguredIfEnabled() {
        new ConfigurationFactory((Map)ImmutableMap.of((Object)"experimental.spill-enabled", (Object)"true")).build(FeaturesConfig.class);
    }
}

