/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.operator.DriverYieldSignal;
import com.facebook.presto.operator.project.PageProcessor;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.sql.gen.ExpressionCompiler;
import com.facebook.presto.sql.gen.PageFunctionCompiler;
import com.facebook.presto.sql.relational.Expressions;
import com.facebook.presto.sql.relational.RowExpression;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.tpch.LineItem;
import io.airlift.tpch.LineItemGenerator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.SECONDS)
@Fork(value=5)
@Warmup(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
public class BenchmarkPageProcessor {
    private static final int EXTENDED_PRICE = 0;
    private static final int DISCOUNT = 1;
    private static final int SHIP_DATE = 2;
    private static final int QUANTITY = 3;
    private static final Slice MIN_SHIP_DATE = Slices.utf8Slice((String)"1994-01-01");
    private static final Slice MAX_SHIP_DATE = Slices.utf8Slice((String)"1995-01-01");
    private Page inputPage;
    private PageProcessor compiledProcessor;
    private static final RowExpression FILTER = Expressions.call((Signature)new Signature("AND", FunctionKind.SCALAR, TypeSignature.parseTypeSignature((String)"boolean"), new TypeSignature[0]), (Type)BooleanType.BOOLEAN, (RowExpression[])new RowExpression[]{Expressions.call((Signature)Signature.internalOperator((OperatorType)OperatorType.GREATER_THAN_OR_EQUAL, (TypeSignature)BooleanType.BOOLEAN.getTypeSignature(), (TypeSignature[])new TypeSignature[]{VarcharType.VARCHAR.getTypeSignature(), VarcharType.VARCHAR.getTypeSignature()}), (Type)BooleanType.BOOLEAN, (RowExpression[])new RowExpression[]{Expressions.field((int)2, (Type)VarcharType.VARCHAR), Expressions.constant((Object)MIN_SHIP_DATE, (Type)VarcharType.VARCHAR)}), Expressions.call((Signature)new Signature("AND", FunctionKind.SCALAR, TypeSignature.parseTypeSignature((String)"boolean"), new TypeSignature[0]), (Type)BooleanType.BOOLEAN, (RowExpression[])new RowExpression[]{Expressions.call((Signature)Signature.internalOperator((OperatorType)OperatorType.LESS_THAN, (TypeSignature)BooleanType.BOOLEAN.getTypeSignature(), (TypeSignature[])new TypeSignature[]{VarcharType.VARCHAR.getTypeSignature(), VarcharType.VARCHAR.getTypeSignature()}), (Type)BooleanType.BOOLEAN, (RowExpression[])new RowExpression[]{Expressions.field((int)2, (Type)VarcharType.VARCHAR), Expressions.constant((Object)MAX_SHIP_DATE, (Type)VarcharType.VARCHAR)}), Expressions.call((Signature)new Signature("AND", FunctionKind.SCALAR, TypeSignature.parseTypeSignature((String)"boolean"), new TypeSignature[0]), (Type)BooleanType.BOOLEAN, (RowExpression[])new RowExpression[]{Expressions.call((Signature)Signature.internalOperator((OperatorType)OperatorType.GREATER_THAN_OR_EQUAL, (TypeSignature)BooleanType.BOOLEAN.getTypeSignature(), (TypeSignature[])new TypeSignature[]{DoubleType.DOUBLE.getTypeSignature(), DoubleType.DOUBLE.getTypeSignature()}), (Type)BooleanType.BOOLEAN, (RowExpression[])new RowExpression[]{Expressions.field((int)1, (Type)DoubleType.DOUBLE), Expressions.constant((Object)0.05, (Type)DoubleType.DOUBLE)}), Expressions.call((Signature)new Signature("AND", FunctionKind.SCALAR, TypeSignature.parseTypeSignature((String)"boolean"), new TypeSignature[0]), (Type)BooleanType.BOOLEAN, (RowExpression[])new RowExpression[]{Expressions.call((Signature)Signature.internalOperator((OperatorType)OperatorType.LESS_THAN_OR_EQUAL, (TypeSignature)BooleanType.BOOLEAN.getTypeSignature(), (TypeSignature[])new TypeSignature[]{DoubleType.DOUBLE.getTypeSignature(), DoubleType.DOUBLE.getTypeSignature()}), (Type)BooleanType.BOOLEAN, (RowExpression[])new RowExpression[]{Expressions.field((int)1, (Type)DoubleType.DOUBLE), Expressions.constant((Object)0.07, (Type)DoubleType.DOUBLE)}), Expressions.call((Signature)Signature.internalOperator((OperatorType)OperatorType.LESS_THAN, (TypeSignature)BooleanType.BOOLEAN.getTypeSignature(), (TypeSignature[])new TypeSignature[]{DoubleType.DOUBLE.getTypeSignature(), DoubleType.DOUBLE.getTypeSignature()}), (Type)BooleanType.BOOLEAN, (RowExpression[])new RowExpression[]{Expressions.field((int)3, (Type)DoubleType.DOUBLE), Expressions.constant((Object)24.0, (Type)DoubleType.DOUBLE)})})})})});
    private static final RowExpression PROJECT = Expressions.call((Signature)Signature.internalOperator((OperatorType)OperatorType.MULTIPLY, (TypeSignature)DoubleType.DOUBLE.getTypeSignature(), (TypeSignature[])new TypeSignature[]{DoubleType.DOUBLE.getTypeSignature(), DoubleType.DOUBLE.getTypeSignature()}), (Type)DoubleType.DOUBLE, (RowExpression[])new RowExpression[]{Expressions.field((int)0, (Type)DoubleType.DOUBLE), Expressions.field((int)1, (Type)DoubleType.DOUBLE)});

    @Setup
    public void setup() {
        this.inputPage = BenchmarkPageProcessor.createInputPage();
        MetadataManager metadata = MetadataManager.createTestMetadataManager();
        this.compiledProcessor = (PageProcessor)new ExpressionCompiler((Metadata)metadata, new PageFunctionCompiler((Metadata)metadata, 0)).compilePageProcessor(Optional.of(FILTER), (List)ImmutableList.of((Object)PROJECT)).get();
    }

    @Benchmark
    public Page handCoded() {
        PageBuilder pageBuilder = new PageBuilder((List)ImmutableList.of((Object)DoubleType.DOUBLE));
        int count = Tpch1FilterAndProject.process(this.inputPage, 0, this.inputPage.getPositionCount(), pageBuilder);
        Preconditions.checkState((count == this.inputPage.getPositionCount() ? 1 : 0) != 0);
        return pageBuilder.build();
    }

    @Benchmark
    public List<Optional<Page>> compiled() {
        return ImmutableList.copyOf((Iterator)this.compiledProcessor.process(null, new DriverYieldSignal(), this.inputPage));
    }

    public static void main(String[] args) throws RunnerException {
        new BenchmarkPageProcessor().setup();
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + BenchmarkPageProcessor.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }

    private static Page createInputPage() {
        PageBuilder pageBuilder = new PageBuilder((List)ImmutableList.of((Object)DoubleType.DOUBLE, (Object)DoubleType.DOUBLE, (Object)VarcharType.VARCHAR, (Object)DoubleType.DOUBLE));
        LineItemGenerator lineItemGenerator = new LineItemGenerator(1.0, 1, 1);
        Iterator iterator = lineItemGenerator.iterator();
        for (int i = 0; i < 10000; ++i) {
            pageBuilder.declarePosition();
            LineItem lineItem = (LineItem)iterator.next();
            DoubleType.DOUBLE.writeDouble(pageBuilder.getBlockBuilder(0), lineItem.getExtendedPrice());
            DoubleType.DOUBLE.writeDouble(pageBuilder.getBlockBuilder(1), lineItem.getDiscount());
            DateType.DATE.writeLong(pageBuilder.getBlockBuilder(2), (long)lineItem.getShipDate());
            DoubleType.DOUBLE.writeDouble(pageBuilder.getBlockBuilder(3), (double)lineItem.getQuantity());
        }
        return pageBuilder.build();
    }

    private static final class Tpch1FilterAndProject {
        private Tpch1FilterAndProject() {
        }

        public static int process(Page page, int start, int end, PageBuilder pageBuilder) {
            int position;
            Block discountBlock = page.getBlock(1);
            for (position = start; position < end; ++position) {
                if (!Tpch1FilterAndProject.filter(position, discountBlock, page.getBlock(2), page.getBlock(3))) continue;
                Tpch1FilterAndProject.project(position, pageBuilder, page.getBlock(0), discountBlock);
            }
            return position;
        }

        private static void project(int position, PageBuilder pageBuilder, Block extendedPriceBlock, Block discountBlock) {
            pageBuilder.declarePosition();
            if (discountBlock.isNull(position) || extendedPriceBlock.isNull(position)) {
                pageBuilder.getBlockBuilder(0).appendNull();
            } else {
                DoubleType.DOUBLE.writeDouble(pageBuilder.getBlockBuilder(0), DoubleType.DOUBLE.getDouble(extendedPriceBlock, position) * DoubleType.DOUBLE.getDouble(discountBlock, position));
            }
        }

        private static boolean filter(int position, Block discountBlock, Block shipDateBlock, Block quantityBlock) {
            return !shipDateBlock.isNull(position) && VarcharType.VARCHAR.getSlice(shipDateBlock, position).compareTo(MIN_SHIP_DATE) >= 0 && !shipDateBlock.isNull(position) && VarcharType.VARCHAR.getSlice(shipDateBlock, position).compareTo(MAX_SHIP_DATE) < 0 && !discountBlock.isNull(position) && DoubleType.DOUBLE.getDouble(discountBlock, position) >= 0.05 && !discountBlock.isNull(position) && DoubleType.DOUBLE.getDouble(discountBlock, position) <= 0.07 && !quantityBlock.isNull(position) && DoubleType.DOUBLE.getDouble(quantityBlock, position) < 24.0;
        }
    }
}

