/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.SequencePageBuilder;
import com.facebook.presto.Session;
import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataManager;
import com.facebook.presto.operator.DriverYieldSignal;
import com.facebook.presto.operator.index.PageRecordSet;
import com.facebook.presto.operator.project.CursorProcessor;
import com.facebook.presto.operator.project.PageProcessor;
import com.facebook.presto.operator.scalar.FunctionAssertions;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.sql.analyzer.ExpressionAnalyzer;
import com.facebook.presto.sql.gen.ExpressionCompiler;
import com.facebook.presto.sql.gen.PageFunctionCompiler;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolToInputRewriter;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.relational.RowExpression;
import com.facebook.presto.sql.relational.SqlToRowExpressionTranslator;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.testing.TestingSession;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Fork(value=10)
@Warmup(iterations=10)
@Measurement(iterations=10)
@BenchmarkMode(value={Mode.AverageTime})
public class PageProcessorBenchmark {
    private static final Map<String, Type> TYPE_MAP = ImmutableMap.of((Object)"bigint", (Object)BigintType.BIGINT, (Object)"varchar", (Object)VarcharType.VARCHAR);
    private static final SqlParser SQL_PARSER = new SqlParser();
    private static final Metadata METADATA = MetadataManager.createTestMetadataManager();
    private static final Session TEST_SESSION = TestingSession.testSessionBuilder().build();
    private static final int POSITIONS = 1024;
    private final DriverYieldSignal yieldSignal = new DriverYieldSignal();
    private final Map<Symbol, Type> symbolTypes = new HashMap<Symbol, Type>();
    private final Map<Symbol, Integer> sourceLayout = new HashMap<Symbol, Integer>();
    private CursorProcessor cursorProcessor;
    private PageProcessor pageProcessor;
    private Page inputPage;
    private RecordSet recordSet;
    private List<Type> types;
    @Param(value={"2", "4", "8", "16", "32"})
    int columnCount;
    @Param(value={"varchar", "bigint"})
    String type;
    @Param(value={"false", "true"})
    boolean dictionaryBlocks;

    @Setup
    public void setup() {
        Type type = TYPE_MAP.get(this.type);
        for (int i = 0; i < this.columnCount; ++i) {
            Symbol symbol = new Symbol(type.getDisplayName().toLowerCase(Locale.ENGLISH) + i);
            this.symbolTypes.put(symbol, type);
            this.sourceLayout.put(symbol, i);
        }
        List<RowExpression> projections = this.getProjections(type);
        this.types = projections.stream().map(RowExpression::getType).collect(Collectors.toList());
        MetadataManager metadata = MetadataManager.createTestMetadataManager();
        PageFunctionCompiler pageFunctionCompiler = new PageFunctionCompiler((Metadata)metadata, 0);
        this.inputPage = PageProcessorBenchmark.createPage(this.types, this.dictionaryBlocks);
        this.pageProcessor = (PageProcessor)new ExpressionCompiler((Metadata)metadata, pageFunctionCompiler).compilePageProcessor(Optional.of(this.getFilter(type)), projections).get();
        this.recordSet = new PageRecordSet(this.types, this.inputPage);
        this.cursorProcessor = (CursorProcessor)new ExpressionCompiler((Metadata)metadata, pageFunctionCompiler).compileCursorProcessor(Optional.of(this.getFilter(type)), projections, (Object)"key").get();
    }

    @Benchmark
    public Page rowOriented() {
        PageBuilder pageBuilder = new PageBuilder(this.types);
        this.cursorProcessor.process(null, this.yieldSignal, this.recordSet.cursor(), pageBuilder);
        return pageBuilder.build();
    }

    @Benchmark
    public List<Optional<Page>> columnOriented() {
        return ImmutableList.copyOf((Iterator)this.pageProcessor.process(null, new DriverYieldSignal(), this.inputPage));
    }

    private RowExpression getFilter(Type type) {
        if (type == VarcharType.VARCHAR) {
            return this.rowExpression("cast(varchar0 as bigint) % 2 = 0", (Type)VarcharType.VARCHAR);
        }
        if (type == BigintType.BIGINT) {
            return this.rowExpression("bigint0 % 2 = 0", (Type)BigintType.BIGINT);
        }
        throw new IllegalArgumentException("filter not supported for type : " + type);
    }

    private List<RowExpression> getProjections(Type type) {
        ImmutableList.Builder builder;
        block3: {
            block2: {
                builder = ImmutableList.builder();
                if (type != BigintType.BIGINT) break block2;
                for (int i = 0; i < this.columnCount; ++i) {
                    builder.add((Object)this.rowExpression("bigint" + i + " + 5", type));
                }
                break block3;
            }
            if (type != VarcharType.VARCHAR) break block3;
            for (int i = 0; i < this.columnCount; ++i) {
                builder.add((Object)this.rowExpression("concat(varchar" + i + ", 'foo')", type));
            }
        }
        return builder.build();
    }

    private RowExpression rowExpression(String expression, Type type) {
        SymbolToInputRewriter symbolToInputRewriter = new SymbolToInputRewriter(this.sourceLayout);
        Expression inputReferenceExpression = symbolToInputRewriter.rewrite(FunctionAssertions.createExpression(expression, METADATA, TypeProvider.copyOf(this.symbolTypes)));
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (int i = 0; i < this.columnCount; ++i) {
            builder.put((Object)i, (Object)type);
        }
        ImmutableMap types = builder.build();
        Map expressionTypes = ExpressionAnalyzer.getExpressionTypesFromInput((Session)TEST_SESSION, (Metadata)METADATA, (SqlParser)SQL_PARSER, (Map)types, (Expression)inputReferenceExpression, Collections.emptyList());
        return SqlToRowExpressionTranslator.translate((Expression)inputReferenceExpression, (FunctionKind)FunctionKind.SCALAR, (Map)expressionTypes, (FunctionRegistry)METADATA.getFunctionRegistry(), (TypeManager)METADATA.getTypeManager(), (Session)TEST_SESSION, (boolean)true);
    }

    private static Page createPage(List<? extends Type> types, boolean dictionary) {
        if (dictionary) {
            return SequencePageBuilder.createSequencePageWithDictionaryBlocks(types, 1024);
        }
        return SequencePageBuilder.createSequencePage(types, 1024);
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + PageProcessorBenchmark.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }
}

